/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.item.Filter;
import mods.railcraft.api.item.MinecartFactory;
import mods.railcraft.client.emblem.EmblemClientUtil;
import mods.railcraft.world.item.CartItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class LocomotiveItem
extends CartItem
implements Filter {
    private final DyeColor defaultPrimary;
    private final DyeColor defaultSecondary;

    public LocomotiveItem(MinecartFactory minecartPlacer, DyeColor primary, DyeColor secondary, Item.Properties properties) {
        super(minecartPlacer, properties);
        this.defaultPrimary = primary;
        this.defaultSecondary = secondary;
    }

    @Override
    public boolean matches(ItemStack matcher, ItemStack target) {
        return target.m_41720_() == this && LocomotiveItem.getPrimaryColor(matcher) == LocomotiveItem.getPrimaryColor(target) && LocomotiveItem.getSecondaryColor(matcher) == LocomotiveItem.getSecondaryColor(target);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag adv) {
        GameProfile owner = LocomotiveItem.getOwner(stack);
        if (owner != null && !StringUtils.isBlank((CharSequence)owner.getName())) {
            tooltip.add((Component)Component.m_237110_((String)Translations.Tips.LOCOMOTIVE_ITEM_OWNER, (Object[])new Object[]{owner.getName()}).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.LOCOMOTIVE_ITEM_PRIMARY).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("color.minecraft." + LocomotiveItem.getPrimaryColor(stack).m_41065_()))).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.LOCOMOTIVE_ITEM_SECONDARY).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("color.minecraft." + LocomotiveItem.getSecondaryColor(stack).m_41065_()))).m_130940_(ChatFormatting.GRAY));
        float whistle = LocomotiveItem.getWhistlePitch(stack);
        String whistleText = whistle < 0.0f ? "???" : String.format("%.2f", Float.valueOf(whistle));
        tooltip.add((Component)Component.m_237110_((String)Translations.Tips.LOCOMOTIVE_ITEM_WHISTLE, (Object[])new Object[]{whistleText}).m_130940_(ChatFormatting.GRAY));
        LocomotiveItem.getEmblem(stack).flatMap(EmblemClientUtil.packageManager()::getEmblem).ifPresent(emblem -> tooltip.add((Component)Component.m_237110_((String)"gui.railcraft.locomotive.tips.item.emblem", (Object[])new Object[]{emblem.displayName()})));
    }

    public static void setItemColorData(ItemStack stack, DyeColor primaryColor, DyeColor secondaryColor) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("primaryColor", primaryColor.m_41060_());
        tag.m_128405_("secondaryColor", secondaryColor.m_41060_());
    }

    public static void setItemWhistleData(ItemStack stack, float whistlePitch) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128350_("whistlePitch", whistlePitch);
    }

    public static float getWhistlePitch(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("whistlePitch", 5)) {
            return -1.0f;
        }
        return tag.m_128457_("whistlePitch");
    }

    public static void setOwnerData(ItemStack stack, GameProfile owner) {
        CompoundTag tag = stack.m_41784_();
        NbtUtils.m_129230_((CompoundTag)tag, (GameProfile)owner);
    }

    @Nullable
    public static GameProfile getOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return NbtUtils.m_129228_((CompoundTag)tag);
    }

    public static void setEmblem(ItemStack stack, String emblemIdentifier) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("emblem", emblemIdentifier);
    }

    public static Optional<String> getEmblem(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return !tag.m_128425_("emblem", 8) ? Optional.empty() : Optional.of(tag.m_128461_("emblem"));
    }

    public static void setModel(ItemStack stack, String modelTag) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("model", modelTag);
    }

    public static String getModel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_("model", 8)) {
            return "default";
        }
        return tag.m_128461_("model");
    }

    public static DyeColor getPrimaryColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("primaryColor", 3)) {
            return DyeColor.m_41053_((int)tag.m_128451_("primaryColor"));
        }
        return ((LocomotiveItem)stack.m_41720_()).defaultPrimary;
    }

    public static DyeColor getSecondaryColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("secondaryColor", 3)) {
            return DyeColor.m_41053_((int)tag.m_128451_("secondaryColor"));
        }
        return ((LocomotiveItem)stack.m_41720_()).defaultSecondary;
    }
}

