/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.UpdateAuraByKeyMessage;
import mods.railcraft.world.item.RailcraftArmorMaterial;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GogglesItem
extends ArmorItem {
    public GogglesItem(Item.Properties properties) {
        super((ArmorMaterial)RailcraftArmorMaterial.GOGGLES, ArmorItem.Type.HELMET, properties);
    }

    public static Aura getAura(ItemStack itemStack) {
        CompoundTag tag;
        if (itemStack.m_41782_() && (tag = itemStack.m_41783_()).m_128441_("aura")) {
            return Aura.values()[tag.m_128451_("aura")];
        }
        return Aura.NONE;
    }

    public static Aura incrementAura(ItemStack itemStack) {
        Aura aura = GogglesItem.getAura(itemStack).getNext();
        if (aura == Aura.TRACKING) {
            aura.getNext();
        }
        itemStack.m_41784_().m_128405_("aura", aura.ordinal());
        return aura;
    }

    public static void changeAuraByKey(LocalPlayer player) {
        ItemStack itemStack = player.m_6844_(EquipmentSlot.HEAD);
        if (itemStack.m_41619_()) {
            return;
        }
        Aura aura = GogglesItem.incrementAura(itemStack);
        player.m_5661_(GogglesItem.getDescriptionText(aura.getDisplayName(), false), true);
        NetworkChannel.GAME.sendToServer(new UpdateAuraByKeyMessage(itemStack.m_41783_()));
    }

    public static boolean isGoggleAuraActive(Player player, Aura aura) {
        ItemStack itemStack = player.m_6844_(EquipmentSlot.HEAD);
        return itemStack.m_41720_() instanceof GogglesItem && GogglesItem.getAura(itemStack) == aura;
    }

    private static Component getDescriptionText(MutableComponent value, boolean tooltip) {
        MutableComponent title = Component.m_237115_((String)Translations.Tips.GOOGLES_AURA);
        if (tooltip) {
            title.m_130940_(ChatFormatting.GRAY);
        }
        return title.m_130946_(" ").m_7220_((Component)value.m_130940_(ChatFormatting.DARK_PURPLE));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            Aura aura = GogglesItem.incrementAura(itemStack);
            player.m_5661_(GogglesItem.getDescriptionText(aura.getDisplayName(), false), true);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> lines, TooltipFlag adv) {
        lines.add(GogglesItem.getDescriptionText(GogglesItem.getAura(itemStack).getDisplayName(), true));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.GOOGLES_DESC).m_130940_(ChatFormatting.GRAY));
    }

    public static enum Aura {
        NONE(Translations.Tips.GOOGLES_AURA_NONE),
        TRACKING(Translations.Tips.GOOGLES_AURA_TRACKING),
        TUNING(Translations.Tips.GOOGLES_AURA_TUNING),
        SHUNTING(Translations.Tips.GOOGLES_AURA_SHUNTING),
        SIGNALLING(Translations.Tips.GOOGLES_AURA_SIGNALLING),
        SURVEYING(Translations.Tips.GOOGLES_AURA_SURVEYING),
        WORLDSPIKE(Translations.Tips.GOOGLES_AURA_WORLDSPIKE);

        private final String translationKey;

        private Aura(String translationKey) {
            this.translationKey = translationKey;
        }

        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)this.translationKey);
        }

        public Aura getNext() {
            return (Aura)EnumUtil.next((Enum)this, (Enum[])Aura.values());
        }
    }
}

