/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.Translations;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.FirestoneItemEntity;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirestoneItem
extends Item {
    public static final Predicate<ItemStack> SPAWNS_FIRE = itemStack -> itemStack.m_41619_() || itemStack.m_150930_((Item)RailcraftItems.RAW_FIRESTONE.get()) || itemStack.m_150930_((Item)RailcraftItems.CUT_FIRESTONE.get()) || itemStack.m_150930_((Item)RailcraftItems.CRACKED_FIRESTONE.get()) || ContainerTools.isItemStackBlock(itemStack, (Block)RailcraftBlocks.FIRESTONE_ORE.get());
    private final boolean spawnsFire;

    public FirestoneItem(boolean spawnsFire, Item.Properties properties) {
        super(properties);
        this.spawnsFire = spawnsFire;
    }

    public boolean spawnsFire() {
        return this.spawnsFire;
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    @NotNull
    public FirestoneItemEntity createEntity(Level level, Entity entity, ItemStack itemStack) {
        return FirestoneItem.createEntityItem(level, entity, itemStack);
    }

    public boolean isRepairable(ItemStack itemStack) {
        return false;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return false;
    }

    public void fillItemCategory(CreativeModeTab.Output output) {
        output.m_246342_(new ItemStack((ItemLike)this));
        ItemStack item = new ItemStack((ItemLike)this);
        if (item.m_41763_()) {
            item.m_41721_(item.m_41776_() - 1);
            output.m_246342_(item);
        }
    }

    @NotNull
    public static FirestoneItemEntity createEntityItem(Level level, Entity entity, ItemStack itemStack) {
        FirestoneItemEntity firestone = new FirestoneItemEntity(level, entity.m_20182_(), itemStack);
        firestone.m_32052_(entity.m_20148_());
        firestone.m_20256_(entity.m_20184_());
        firestone.m_32060_();
        return firestone;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (this.spawnsFire && level.m_46469_().m_46207_(GameRules.f_46131_) && entity instanceof Player) {
            Player player = (Player)entity;
            if (level.m_213780_().m_188503_(12) % 4 == 0) {
                FirestoneItem.trySpawnFire(player.m_9236_(), player.m_20183_(), stack, (Entity)player);
            }
        }
    }

    public static boolean trySpawnFire(Level level, BlockPos pos, ItemStack stack, Entity entity) {
        boolean spawnedFire = false;
        for (int i = 0; i < stack.m_41613_(); ++i) {
            spawnedFire |= FirestoneItem.spawnFire(level, pos, entity);
        }
        if (spawnedFire && stack.m_41763_() && stack.m_41773_() < stack.m_41776_() - 1 && entity instanceof Player) {
            Player player = (Player)entity;
            stack.m_41622_(1, (LivingEntity)player, t -> {});
        }
        return spawnedFire;
    }

    public static boolean spawnFire(Level level, BlockPos pos, @Nullable Entity entity) {
        RandomSource random = level.m_213780_();
        int x = pos.m_123341_() - 5 + random.m_188503_(12);
        int y = pos.m_123342_() - 5 + random.m_188503_(12);
        int z = pos.m_123343_() - 5 + random.m_188503_(12);
        y = Mth.m_14045_((int)y, (int)(level.m_141937_() + 2), (int)(level.m_151558_() - 1));
        BlockPos firePos = new BlockPos(x, y, z);
        BlockState blockState = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)firePos);
        return level.m_8055_(firePos).m_60795_() && blockState.m_60710_((LevelReader)level, firePos) && level.m_46597_(firePos, blockState);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (stack.m_150930_((Item)RailcraftItems.RAW_FIRESTONE.get())) {
            tooltipComponents.add((Component)Component.m_237115_((String)Translations.Tips.RAW_FIRESTONE).m_130940_(ChatFormatting.GRAY));
        } else if (stack.m_150930_((Item)RailcraftItems.CUT_FIRESTONE.get())) {
            tooltipComponents.add((Component)Component.m_237115_((String)Translations.Tips.CUT_FIRESTONE).m_130940_(ChatFormatting.GRAY));
        }
    }
}

