/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.inventory.SimpleDataSlot;
import mods.railcraft.world.inventory.slot.RollingResultSlot;
import mods.railcraft.world.inventory.slot.UnmodifiableSlot;
import mods.railcraft.world.level.block.entity.ManualRollingMachineBlockEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ManualRollingMachineMenu
extends RailcraftMenu {
    public static final String CLICK_TO_CRAFT_TAG = "clickToCraft";
    private final ManualRollingMachineBlockEntity blockEntity;
    private final ManualRollingMachineBlockEntity.RollingCraftingContainer craftMatrix;
    private final ResultContainer craftResult;
    private final ContainerMapper resultSlot;

    protected ManualRollingMachineMenu(MenuType<?> type, int id, Inventory inventory, ManualRollingMachineBlockEntity blockEntity, int xs, int xy) {
        super(type, id, inventory.f_35978_, blockEntity::isStillValid);
        this.blockEntity = blockEntity;
        this.craftMatrix = blockEntity.getCraftMatrix(this);
        this.resultSlot = blockEntity.getInvResult();
        this.craftResult = new ResultContainer(){

            public void m_6836_(int index, ItemStack stack) {
                super.m_6836_(index, stack);
                stack.m_41784_().m_128379_(ManualRollingMachineMenu.CLICK_TO_CRAFT_TAG, true);
            }
        };
        this.m_38897_(new SlotRollingMachine((Container)this.craftResult, 0, xs, xy));
        this.m_38897_((Slot)new RollingResultSlot(this.getPlayer(), (CraftingContainer)this.craftMatrix, this.resultSlot, 0, 124, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.m_38897_(new Slot((Container)this.craftMatrix, x + y * 3, 30 + x * 18, 17 + y * 18));
            }
        }
        this.addInventorySlots(inventory);
        this.m_38895_(new SimpleDataSlot(this.blockEntity::getProgress, this.blockEntity::setProgress));
        this.m_38895_(new SimpleDataSlot(this.blockEntity::getProcessTime, this.blockEntity::setProcessTime));
        this.m_6199_((Container)this.craftMatrix);
    }

    public ManualRollingMachineMenu(int id, Inventory inventory, ManualRollingMachineBlockEntity blockEntity) {
        this((MenuType)RailcraftMenuTypes.MANUAL_ROLLING_MACHINE.get(), id, inventory, blockEntity, 93, 27);
    }

    public void m_6199_(Container container) {
        this.craftResult.m_6836_(0, this.blockEntity.getRecipe().map(r -> r.assemble((CraftingContainer)this.craftMatrix, this.blockEntity.level().m_9598_())).orElse(ItemStack.f_41583_));
    }

    public float rollingProgress() {
        int requiredTime = this.blockEntity.getProcessTime();
        int currentTick = this.blockEntity.getProgress();
        return Mth.m_14036_((float)((float)currentTick / (float)requiredTime), (float)0.0f, (float)1.0f);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, (Container)this.craftMatrix);
        this.m_150411_(player, this.resultSlot);
    }

    private class SlotRollingMachine
    extends UnmodifiableSlot {
        SlotRollingMachine(Container contents, int id, int x, int y) {
            super(contents, id, x, y);
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            ManualRollingMachineMenu.this.blockEntity.setUseLast();
        }
    }
}

