/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import java.util.Collections;
import mods.railcraft.Translations;
import mods.railcraft.world.entity.vehicle.locomotive.CreativeLocomotive;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.inventory.slot.ItemFilterSlot;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import mods.railcraft.world.inventory.slot.UnmodifiableSlot;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class LocomotiveMenu<T extends Locomotive>
extends RailcraftMenu {
    public static final int DEFAULT_HEIGHT = 161;
    private final T locomotive;
    public String ownerName;

    public LocomotiveMenu(@Nullable MenuType<?> type, int id, Inventory playerInv, T locomotive) {
        this(type, id, playerInv, locomotive, 161);
    }

    protected LocomotiveMenu(@Nullable MenuType<?> type, int id, Inventory inventory, T locomotive, int guiHeight) {
        super(type, id, inventory.f_35978_, arg_0 -> locomotive.m_6542_(arg_0));
        this.locomotive = locomotive;
        RailcraftSlot slotTicket = new ItemFilterSlot(TicketItem.FILTER, (Container)locomotive, ((Locomotive)locomotive).m_6643_() - 2, 116, guiHeight - 111).setStackLimit(1);
        slotTicket.setTooltip(Collections.singletonList(Component.m_237115_((String)Translations.Tips.LOCOMOTIVE_SLOT_TICKET)));
        this.m_38897_(slotTicket);
        this.m_38897_(new UnmodifiableSlot((Container)locomotive, ((Locomotive)locomotive).m_6643_() - 1, 134, guiHeight - 111));
        this.addInventorySlots(inventory, guiHeight);
    }

    public static LocomotiveMenu<CreativeLocomotive> creative(int id, Inventory inventory, CreativeLocomotive entity) {
        return new LocomotiveMenu<CreativeLocomotive>((MenuType)RailcraftMenuTypes.CREATIVE_LOCOMOTIVE.get(), id, inventory, entity);
    }

    public T getLocomotive() {
        return this.locomotive;
    }

    @Override
    public boolean m_6875_(Player player) {
        return true;
    }
}

