/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle.locomotive;

import java.util.Set;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.LocomotiveMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CreativeLocomotive
extends Locomotive
implements WorldlyContainer {
    private static final int SLOT_TICKET = 0;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 1);
    private static final Set<Locomotive.Mode> ALLOWED_MODES = Set.of(Locomotive.Mode.RUNNING, Locomotive.Mode.SHUTDOWN);
    private final Container invTicket = new ContainerMapper((Container)this, 0, 2).ignoreItemChecks();

    public CreativeLocomotive(EntityType<?> type, Level level) {
        super(type, level);
    }

    public CreativeLocomotive(ItemStack itemStack, double x, double y, double z, ServerLevel level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.CREATIVE_LOCOMOTIVE.get(), x, y, z, level);
    }

    @Override
    public Set<Locomotive.Mode> getSupportedModes() {
        return ALLOWED_MODES;
    }

    @Override
    protected DyeColor getDefaultPrimaryColor() {
        return DyeColor.BLACK;
    }

    @Override
    protected DyeColor getDefaultSecondaryColor() {
        return DyeColor.MAGENTA;
    }

    @Override
    public SoundEvent getWhistleSound() {
        return (SoundEvent)RailcraftSoundEvents.ELECTRIC_WHISTLE.get();
    }

    @Override
    protected int getIdleFuelUse() {
        return 0;
    }

    @Override
    public int retrieveFuel() {
        return 100;
    }

    @Override
    public Item getItem() {
        return (Item)RailcraftItems.CREATIVE_LOCOMOTIVE.get();
    }

    @Override
    public float getOptimalDistance(RollingStock cart) {
        return 0.92f;
    }

    @Override
    protected Container ticketContainer() {
        return this.invTicket;
    }

    @Override
    public int m_6643_() {
        return 2;
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction side) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction side) {
        return slot == 0;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 0) {
            return TicketItem.FILTER.test(stack);
        }
        return false;
    }

    @Override
    public boolean needsFuel() {
        return false;
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory playerInventory) {
        return new LocomotiveMenu<CreativeLocomotive>((MenuType)RailcraftMenuTypes.CREATIVE_LOCOMOTIVE.get(), id, playerInventory, this);
    }
}

