/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.Linkable;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Side;
import mods.railcraft.api.carts.Train;
import mods.railcraft.api.carts.TunnelBoreHead;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.entity.vehicle.TunnelBorePart;
import mods.railcraft.world.inventory.TunnelBoreMenu;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class TunnelBore
extends RailcraftMinecart
implements Linkable {
    public static final float SPEED = 0.03f;
    public static final float LENGTH = 6.2f;
    public static final float WIDTH = 3.0f;
    public static final float HEIGHT = 3.0f;
    public static final int MAX_FILL_DEPTH = 10;
    public static final int FAIL_DELAY = 200;
    public static final int STANDARD_DELAY = 5;
    public static final int LAYER_DELAY = 40;
    public static final int BALLAST_DELAY = 10;
    public static final int FUEL_CONSUMPTION = 12;
    public static final float HARDNESS_MULTIPLIER = 8.0f;
    public static final Set<BlockState> MINEABLE_STATES = new HashSet<BlockState>();
    public static final Set<Block> MINEABLE_BLOCKS = Set.of(Blocks.f_50129_, Blocks.f_50125_, Blocks.f_50128_, Blocks.f_50249_, Blocks.f_50079_, Blocks.f_50262_, Blocks.f_50092_, Blocks.f_50036_, Blocks.f_50083_, Blocks.f_50141_, Blocks.f_50126_, Blocks.f_50186_, Blocks.f_50190_, Blocks.f_50072_, Blocks.f_50180_, Blocks.f_50073_, Blocks.f_50181_, Blocks.f_50195_, Blocks.f_50200_, Blocks.f_50250_, Blocks.f_50133_, Blocks.f_50189_, Blocks.f_49992_, Blocks.f_50062_, Blocks.f_50135_, Blocks.f_50069_, Blocks.f_50093_, Blocks.f_50081_, Blocks.f_50191_, Blocks.f_50033_, Blocks.f_50259_);
    public static final Set<TagKey<Block>> MINEABLE_TAGS = Set.of(Tags.Blocks.ORES, Tags.Blocks.NETHERRACK, Tags.Blocks.COBBLESTONE, Tags.Blocks.OBSIDIAN, Tags.Blocks.GRAVEL, BlockTags.f_144274_, BlockTags.f_13035_, BlockTags.f_13104_, BlockTags.f_13106_, BlockTags.f_13041_, RailcraftTags.Blocks.MAGIC_ORE);
    public static final Set<Block> REPLACEABLE_BLOCKS = Set.of(Blocks.f_50081_);
    public static final Set<TagKey<Block>> REPLACEABLE_TAGS = Set.of(BlockTags.f_13041_);
    private static final EntityDataAccessor<Boolean> HAS_FUEL = SynchedEntityData.m_135353_(TunnelBore.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(TunnelBore.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> FACING = SynchedEntityData.m_135353_(TunnelBore.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<ItemStack> BORE_HEAD = SynchedEntityData.m_135353_(TunnelBore.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final ContainerMapper fuelContainer = ContainerMapper.make((Container)this, 1, 6).addFilters(StackFilter.FUEL);
    private final ContainerMapper ballastContainer = ContainerMapper.make((Container)this, 7, 9).addFilters(StackFilter.BALLAST);
    private final ContainerMapper trackContainer = ContainerMapper.make((Container)this, 16, 9).addFilters(StackFilter.TRACK);
    protected int delay;
    protected boolean placeRail;
    protected boolean placeBallast;
    protected boolean boreLayer;
    protected int boreRotationAngle;
    private boolean active;
    private int clock;
    private int burnTime;
    private int fuel;
    private final boolean constructed;
    private final TunnelBorePart[] parts;
    private final List<ContainerMapper> containers;

    public TunnelBore(EntityType<TunnelBore> type, Level level) {
        this(level, 0.0, 0.0, 0.0, Direction.SOUTH);
    }

    public TunnelBore(Level level, double x, double y, double z, Direction facing) {
        super((EntityType)RailcraftEntityTypes.TUNNEL_BORE.get(), x, y, z, level);
        this.setFacing(facing);
        float headW = 1.5f;
        float headH = 2.6f;
        float headSO = 0.7f;
        this.parts = new TunnelBorePart[]{new TunnelBorePart(this, headW, headH, 1.85f, -headSO), new TunnelBorePart(this, headW, headH, 1.85f, headSO), new TunnelBorePart(this, headW, headH, 2.3f, -headSO), new TunnelBorePart(this, headW, headH, 2.3f, headSO), new TunnelBorePart(this, 2.0f, 1.9f, 0.6f), new TunnelBorePart(this, 1.6f, 1.4f, -1.0f), new TunnelBorePart(this, 1.6f, 1.4f, -2.2f)};
        this.constructed = true;
        this.containers = List.of(this.fuelContainer, this.ballastContainer, this.trackContainer);
        this.m_20234_(f_19843_.getAndAdd(this.parts.length + 1) + 1);
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].m_20234_(id + i + 1);
        }
    }

    public ItemStack m_142340_() {
        return ((Item)RailcraftItems.TUNNEL_BORE.get()).m_7968_();
    }

    public static void addMineableBlock(Block block) {
        TunnelBore.addMineableBlock(block.m_49966_());
    }

    public static void addMineableBlock(BlockState blockState) {
        MINEABLE_STATES.add(blockState);
    }

    public boolean canHeadHarvestBlock(ItemStack head, BlockState targetState) {
        return !head.m_41619_() && (!targetState.m_60834_() || head.m_41735_(targetState));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMineableBlock(BlockState blockState) {
        if ((Boolean)RailcraftConfig.SERVER.boreMinesAllBlocks.get() != false) return true;
        if (MINEABLE_BLOCKS.contains(blockState.m_60734_())) return true;
        if (MINEABLE_STATES.contains(blockState)) return true;
        if (!MINEABLE_TAGS.stream().anyMatch(arg_0 -> ((BlockState)blockState).m_204336_(arg_0))) return false;
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_FUEL, (Object)false);
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(BORE_HEAD, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(FACING, (Object)Direction.NORTH);
    }

    public boolean isMinecartPowered() {
        return (Boolean)this.f_19804_.m_135370_(HAS_FUEL);
    }

    public void setMinecartPowered(boolean powered) {
        this.f_19804_.m_135381_(HAS_FUEL, (Object)powered);
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource source, float damage) {
        block6: {
            if (this.m_9236_().m_5776_() || this.m_213877_()) break block6;
            if (this.m_6673_(source)) {
                return false;
            }
            this.m_38160_(-this.m_38177_());
            this.m_38154_(10);
            this.m_5834_();
            this.m_38109_(this.m_38169_() + damage * 10.0f);
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
            var5_3 = source.m_7639_();
            if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_3;
            if (player.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.m_38169_() > 120.0f) {
                this.m_20153_();
                if (flag && !this.m_8077_()) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                } else {
                    this.m_7617_(source);
                }
            }
            return true;
        }
        return true;
    }

    private void setYaw() {
        int yaw = switch (this.getFacing()) {
            case Direction.NORTH -> 180;
            case Direction.EAST -> 270;
            case Direction.SOUTH -> 0;
            case Direction.WEST -> 90;
            default -> 0;
        };
        this.m_19915_(yaw, this.m_146909_());
    }

    public int m_6643_() {
        return 25;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6034_(double x, double y, double z) {
        if (!this.constructed) {
            super.m_6034_(x, y, z);
            return;
        }
        this.m_20343_(x, y, z);
        double halfWidth = 1.5;
        double height = this.m_20206_();
        double len = 3.1f;
        double minX = x;
        double maxX = x;
        double minZ = z;
        double maxZ = z;
        if (this.getFacing() == Direction.WEST || this.getFacing() == Direction.EAST) {
            minX -= len;
            maxX += len;
            minZ -= halfWidth;
            maxZ += halfWidth;
        } else {
            minX -= halfWidth;
            maxX += halfWidth;
            minZ -= len;
            maxZ += len;
        }
        this.m_20011_(new AABB(minX, y, minZ, maxX, y + height, maxZ));
    }

    public void m_8119_() {
        ++this.clock;
        if (!this.m_9236_().m_5776_()) {
            if (this.clock % 64 == 0) {
                this.forceUpdateBoreHead();
                this.setMinecartPowered(false);
                this.setMoving(false);
            }
            this.stockBallast();
            this.stockTracks();
        }
        super.m_8119_();
        for (TunnelBorePart part : this.parts) {
            part.m_8119_();
        }
        if (!this.m_9236_().m_5776_()) {
            this.updateFuel();
            if (this.hasFuel() && this.getDelay() == 0) {
                this.setActive(true);
                RailShape dir = RailShape.NORTH_SOUTH;
                if (this.getFacing() == Direction.WEST || this.getFacing() == Direction.EAST) {
                    dir = RailShape.EAST_WEST;
                }
                if (this.getDelay() == 0) {
                    float offset = 1.5f;
                    BlockPos targetPos = new BlockPos((Vec3i)this.getPositionAhead(offset)).m_7495_();
                    if (this.placeBallast) {
                        boolean placed = this.placeBallast(targetPos);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeBallast = false;
                    } else if (!Block.m_49936_((BlockGetter)this.m_9236_(), (BlockPos)targetPos)) {
                        this.placeBallast = true;
                        this.setDelay(10);
                    }
                }
                if (this.getDelay() == 0) {
                    float offset = 0.8f;
                    BlockPos targetPos = new BlockPos((Vec3i)this.getPositionAhead(offset));
                    BlockState existingState = this.m_9236_().m_8055_(targetPos);
                    if (this.placeRail) {
                        boolean placed = this.placeTrack(targetPos, existingState, dir);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeRail = false;
                    } else if (BaseRailBlock.m_49416_((BlockState)existingState)) {
                        if (dir != TrackUtil.getTrackDirection((BlockGetter)this.m_9236_(), targetPos, (AbstractMinecart)this)) {
                            TrackUtil.setRailShape(this.m_9236_(), targetPos, dir);
                            this.setDelay(5);
                        }
                    } else if (existingState.m_60795_() || REPLACEABLE_BLOCKS.contains(existingState.m_60734_())) {
                        this.placeRail = true;
                        this.setDelay(5);
                    } else {
                        this.setDelay(200);
                        this.setActive(false);
                    }
                }
                if (this.getDelay() == 0) {
                    float offset = 3.3f;
                    BlockPos targetPos = new BlockPos((Vec3i)this.getPositionAhead(offset));
                    if (this.boreLayer) {
                        boolean bored = this.boreLayer(targetPos, dir);
                        if (bored) {
                            this.setDelay(40);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.boreLayer = false;
                    } else if (this.checkForLava(targetPos, dir)) {
                        this.setDelay(200);
                        this.setActive(false);
                    } else {
                        this.setDelay((int)Math.ceil(this.getLayerHardness(targetPos, dir)));
                        if (this.getDelay() != 0) {
                            this.boreLayer = true;
                        }
                    }
                }
            }
            if (this.isMinecartPowered()) {
                BlockPos headPos = this.getPositionAhead(3.3);
                double size = 0.8;
                List<LivingEntity> entities = EntitySearcher.findLiving().and(ModEntitySelector.KILLABLE).box(builder -> builder.setBoundsToPoint((Vec3i)headPos).inflateHorizontally(size).raiseCeiling(2.0).build()).list(this.m_9236_());
                entities.forEach(e -> e.m_6469_((DamageSource)RailcraftDamageSources.bore(this.m_9236_().m_9598_()), 2.0f));
                ItemStack head = this.m_8020_(0);
                if (!head.m_41619_()) {
                    head.m_220157_(entities.size(), this.f_19796_, MinecartUtil.getFakePlayer((AbstractMinecart)this));
                }
            }
            this.setMoving(this.hasFuel() && this.getDelay() == 0);
            if (this.getDelay() > 0) {
                this.setDelay(this.getDelay() - 1);
            }
        }
        Vec3 motion = this.m_20184_();
        if (this.isMoving()) {
            float factorX = -Mth.m_14031_((float)((float)Math.toRadians(this.m_146908_())));
            float factorZ = Mth.m_14089_((float)((float)Math.toRadians(this.m_146908_())));
            this.m_20334_(0.03f * factorX, motion.m_7098_(), 0.03f * factorZ);
        } else {
            this.m_20334_(0.0, motion.m_7098_(), 0.0);
        }
        this.emitParticles();
        if (this.isMinecartPowered()) {
            this.boreRotationAngle += 5;
        }
    }

    public float getMaxCartSpeedOnRail() {
        return 0.03f;
    }

    public Item m_213728_() {
        return (Item)RailcraftItems.TUNNEL_BORE.get();
    }

    private void updateFuel() {
        if (!this.m_9236_().m_5776_()) {
            if (this.isMinecartPowered()) {
                this.spendFuel();
            }
            this.stockFuel();
            if (this.outOfFuel()) {
                this.addFuel();
            }
            this.setMinecartPowered(this.hasFuel() && this.isActive());
        }
    }

    protected BlockPos getPositionAhead(double offset) {
        double x = this.m_20185_();
        double z = this.m_20189_();
        if (this.getFacing() == Direction.EAST) {
            x += offset;
        } else if (this.getFacing() == Direction.WEST) {
            x -= offset;
        }
        if (this.getFacing() == Direction.NORTH) {
            z -= offset;
        } else if (this.getFacing() == Direction.SOUTH) {
            z += offset;
        }
        return BlockPos.m_274561_((double)x, (double)this.m_20186_(), (double)z);
    }

    protected double getOffsetX(double x, double forwardOffset, double sideOffset) {
        return switch (this.getFacing()) {
            case Direction.NORTH -> x + sideOffset;
            case Direction.SOUTH -> x - sideOffset;
            case Direction.EAST -> x + forwardOffset;
            case Direction.WEST -> x - forwardOffset;
            default -> x;
        };
    }

    protected double getOffsetZ(double z, double forwardOffset, double sideOffset) {
        return switch (this.getFacing()) {
            case Direction.NORTH -> z - forwardOffset;
            case Direction.SOUTH -> z + forwardOffset;
            case Direction.EAST -> z - sideOffset;
            case Direction.WEST -> z + sideOffset;
            default -> z;
        };
    }

    protected void emitParticles() {
        if (this.isMinecartPowered()) {
            double randomFactor = 0.125;
            double forwardOffset = -0.35;
            double smokeYOffset = 2.8;
            double flameYOffset = 1.1;
            double smokeSideOffset = 0.92;
            double flameSideOffset = 1.14;
            double smokeX1 = this.m_20185_();
            double smokeX2 = this.m_20185_();
            double smokeZ1 = this.m_20189_();
            double smokeZ2 = this.m_20189_();
            double flameX1 = this.m_20185_();
            double flameX2 = this.m_20185_();
            double flameZ1 = this.m_20189_();
            double flameZ2 = this.m_20189_();
            if (this.getFacing() == Direction.NORTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 += forwardOffset;
                smokeZ2 += forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 += forwardOffset + this.f_19796_.m_188583_() * randomFactor;
                flameZ2 += forwardOffset + this.f_19796_.m_188583_() * randomFactor;
            } else if (this.getFacing() == Direction.EAST) {
                smokeX1 -= forwardOffset;
                smokeX2 -= forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 -= forwardOffset + this.f_19796_.m_188583_() * randomFactor;
                flameX2 -= forwardOffset + this.f_19796_.m_188583_() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            } else if (this.getFacing() == Direction.SOUTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 -= forwardOffset;
                smokeZ2 -= forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 -= forwardOffset + this.f_19796_.m_188583_() * randomFactor;
                flameZ2 -= forwardOffset + this.f_19796_.m_188583_() * randomFactor;
            } else if (this.getFacing() == Direction.WEST) {
                smokeX1 += forwardOffset;
                smokeX2 += forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 += forwardOffset + this.f_19796_.m_188583_() * randomFactor;
                flameX2 += forwardOffset + this.f_19796_.m_188583_() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            }
            if (this.f_19796_.m_188503_(4) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, smokeX1, this.m_20186_() + smokeYOffset, smokeZ1, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, flameX1, this.m_20186_() + flameYOffset + this.f_19796_.m_188583_() * randomFactor, flameZ1, 0.0, 0.0, 0.0);
            }
            if (this.f_19796_.m_188503_(4) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, smokeX2, this.m_20186_() + smokeYOffset, smokeZ2, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, flameX2, this.m_20186_() + flameYOffset + this.f_19796_.m_188583_() * randomFactor, flameZ2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void stockBallast() {
        ItemStack stack = RollingStock.getOrThrow((AbstractMinecart)this).pullItem(this.ballastContainer::canFit);
        if (!stack.m_41619_()) {
            this.ballastContainer.insert(stack);
        }
    }

    protected boolean placeBallast(BlockPos targetPos) {
        if (!Block.m_49936_((BlockGetter)this.m_9236_(), (BlockPos)targetPos)) {
            return this.ballastContainer.stream().filter(slot -> {
                BlockItem blockItem;
                Item patt20650$temp;
                return slot.hasItem() && (patt20650$temp = slot.item().m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)patt20650$temp).m_40614_().m_204297_().m_203656_(RailcraftTags.Blocks.BALLAST);
            }).findFirst().map(slot -> {
                BlockPos.MutableBlockPos searchPos = targetPos.m_122032_();
                for (int i = 0; i < 10; ++i) {
                    BlockState state;
                    searchPos.m_122173_(Direction.DOWN);
                    if (Block.m_49936_((BlockGetter)this.m_9236_(), (BlockPos)searchPos)) {
                        state = ContainerTools.getBlockStateFromStack(slot.item(), this.m_9236_(), targetPos);
                        if (state == null) continue;
                        slot.extract();
                        this.m_9236_().m_46597_(targetPos, state);
                        return true;
                    }
                    state = this.m_9236_().m_8055_((BlockPos)searchPos);
                    if (state.m_60795_() || state.m_278721_()) continue;
                    LevelUtil.playerRemoveBlock(this.m_9236_(), searchPos.m_7949_(), (Player)MinecartUtil.getFakePlayer((AbstractMinecart)this), this.m_9236_().m_46469_().m_46207_(GameRules.f_46136_) && (Boolean)RailcraftConfig.SERVER.boreDestorysBlocks.get() == false);
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    protected void stockTracks() {
        ItemStack stack = RollingStock.getOrThrow((AbstractMinecart)this).pullItem(this.trackContainer::canFit);
        if (!stack.m_41619_()) {
            this.trackContainer.insert(stack);
        }
    }

    protected boolean placeTrack(BlockPos targetPos, BlockState oldState, RailShape shape) {
        ServerPlayer owner = MinecartUtil.getFakePlayer((AbstractMinecart)this);
        if (REPLACEABLE_BLOCKS.contains(oldState.m_60734_())) {
            LevelUtil.destroyBlock(this.m_9236_(), targetPos, (Player)owner, true);
        }
        if (oldState.m_60795_() && Block.m_49936_((BlockGetter)this.m_9236_(), (BlockPos)targetPos.m_7495_())) {
            return this.trackContainer.stream().filter(SlotAccessor::hasItem).peek(slot -> {
                boolean placed = TrackUtil.placeRailAt(slot.item(), (ServerLevel)this.m_9236_(), targetPos, shape);
                if (placed) {
                    slot.extract();
                }
            }).findFirst().isPresent();
        }
        return false;
    }

    protected boolean checkForLava(BlockPos targetPos, RailShape dir) {
        int xStart = targetPos.m_123341_() - 1;
        int zStart = targetPos.m_123343_() - 1;
        int xEnd = targetPos.m_123341_() + 1;
        int zEnd = targetPos.m_123343_() + 1;
        if (dir == RailShape.NORTH_SOUTH) {
            --xStart;
            ++xEnd;
        } else {
            --zStart;
            ++zEnd;
        }
        int y = targetPos.m_123342_();
        for (BlockPos blockPos : BlockPos.m_121976_((int)xStart, (int)y, (int)zStart, (int)xEnd, (int)(y + 3), (int)zEnd)) {
            Fluid fluid = this.m_9236_().m_6425_(blockPos).m_76152_();
            if (fluid != Fluids.f_76195_ && fluid != Fluids.f_76194_) continue;
            return true;
        }
        return false;
    }

    private <T> T layerAction(BlockPos targetPos, RailShape trackShape, T initialValue, BiFunction<BlockPos, RailShape, T> action, BiFunction<T, T, T> sum) {
        int jj;
        T returnValue = initialValue;
        int x = targetPos.m_123341_();
        int y = targetPos.m_123342_();
        int z = targetPos.m_123343_();
        for (jj = y; jj < y + 3; ++jj) {
            returnValue = sum.apply(returnValue, action.apply(new BlockPos(x, jj, z), trackShape));
        }
        if (trackShape == RailShape.NORTH_SOUTH) {
            --x;
        } else {
            --z;
        }
        for (jj = y; jj < y + 3; ++jj) {
            returnValue = sum.apply(returnValue, action.apply(new BlockPos(x, jj, z), trackShape));
        }
        x = targetPos.m_123341_();
        z = targetPos.m_123343_();
        if (trackShape == RailShape.NORTH_SOUTH) {
            ++x;
        } else {
            ++z;
        }
        for (jj = y; jj < y + 3; ++jj) {
            returnValue = sum.apply(returnValue, action.apply(new BlockPos(x, jj, z), trackShape));
        }
        return returnValue;
    }

    protected boolean boreLayer(BlockPos targetPos, RailShape dir) {
        return this.layerAction(targetPos, dir, true, this::mineBlock, (s, r) -> s != false && r != false);
    }

    protected boolean mineBlock(BlockPos targetPos, RailShape preferredShape) {
        RailShape targetShape;
        BlockState targetState = this.m_9236_().m_8055_(targetPos);
        if (targetState.m_60795_()) {
            return true;
        }
        if (BaseRailBlock.m_49416_((BlockState)targetState) ? preferredShape == (targetShape = TrackUtil.getTrackDirection((BlockGetter)this.m_9236_(), targetPos, targetState, (AbstractMinecart)this)) : targetState.m_60734_() == Blocks.f_50081_) {
            return true;
        }
        ItemStack head = this.m_8020_(0);
        if (head.m_41619_()) {
            return false;
        }
        if (!this.canMineBlock(targetPos, targetState)) {
            return false;
        }
        ServerPlayer fakePlayer = MinecartUtil.getFakePlayerWith((AbstractMinecart)this, head);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.m_9236_(), targetPos, targetState, (Player)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        if (!((Boolean)RailcraftConfig.SERVER.boreDestorysBlocks.get()).booleanValue() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46136_)) {
            targetState.m_287290_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81463_, (Object)head).m_287286_(LootContextParams.f_81458_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_())).forEach(stack -> {
                if (StackFilter.FUEL.test((ItemStack)stack)) {
                    stack = this.fuelContainer.insert((ItemStack)stack);
                }
                if (!stack.m_41619_() && ContainerTools.isItemStackBlock(stack, Blocks.f_49994_)) {
                    stack = this.ballastContainer.insert((ItemStack)stack);
                }
                if (!stack.m_41619_()) {
                    stack = RollingStock.getOrThrow((AbstractMinecart)this).pushItem((ItemStack)stack);
                }
                if (!stack.m_41619_()) {
                    Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)stack);
                }
            });
        }
        LevelUtil.setAir(this.m_9236_(), targetPos);
        if (head.m_220157_(1, this.f_19796_, fakePlayer)) {
            this.m_6836_(0, ItemStack.f_41583_);
        }
        return true;
    }

    private boolean canMineBlock(BlockPos targetPos, BlockState existingState) {
        ItemStack head = this.m_8020_(0);
        if (existingState.m_60800_((BlockGetter)this.m_9236_(), targetPos) < 0.0f) {
            return false;
        }
        return this.isMineableBlock(existingState) && this.canHeadHarvestBlock(head, existingState);
    }

    protected double getLayerHardness(BlockPos targetPos, RailShape dir) {
        Item item;
        double hardness = this.layerAction(targetPos, dir, Float.valueOf(0.0f), this::getBlockHardness, (s, r) -> Float.valueOf(s.floatValue() + r.floatValue())).floatValue();
        hardness *= 8.0;
        ItemStack boreSlot = this.m_8020_(0);
        if (!boreSlot.m_41619_() && (item = boreSlot.m_41720_()) instanceof TunnelBoreHead) {
            TunnelBoreHead head = (TunnelBoreHead)item;
            double dig = head.getDigModifier();
            hardness /= dig;
            int e = boreSlot.getEnchantmentLevel(Enchantments.f_44984_);
            hardness /= (double)(e * e) * 0.2 + 1.0;
        }
        return hardness /= ((Double)RailcraftConfig.SERVER.boreMininigSpeedMultiplier.get()).doubleValue();
    }

    protected float getBlockHardness(BlockPos pos, RailShape dir) {
        RailShape trackMeta;
        BlockState blockState = this.m_9236_().m_8055_(pos);
        if (blockState.m_60795_()) {
            return 0.0f;
        }
        if (BaseRailBlock.m_49416_((BlockState)blockState) && dir == (trackMeta = TrackUtil.getTrackDirection((BlockGetter)this.m_9236_(), pos, blockState, (AbstractMinecart)this))) {
            return 0.0f;
        }
        if (blockState.m_60734_() == Blocks.f_50081_) {
            return 0.0f;
        }
        if (blockState.m_60734_() == Blocks.f_50080_) {
            return 15.0f;
        }
        if (!this.canMineBlock(pos, blockState)) {
            return 0.1f;
        }
        float hardness = blockState.m_60800_((BlockGetter)this.m_9236_(), pos);
        if (hardness <= 0.0f) {
            hardness = 0.1f;
        }
        return hardness;
    }

    public boolean m_7337_(Entity other) {
        return other instanceof LivingEntity;
    }

    public float getBoreRotationAngle() {
        return (float)Math.toRadians(this.boreRotationAngle);
    }

    @Override
    protected void m_7380_(CompoundTag data) {
        super.m_7380_(data);
        data.m_128405_("facing", this.getFacing().m_122411_());
        data.m_128405_("delay", this.getDelay());
        data.m_128379_("active", this.isActive());
        data.m_128405_("burnTime", this.getBurnTime());
        data.m_128405_("fuel", this.fuel);
    }

    @Override
    protected void m_7378_(CompoundTag data) {
        super.m_7378_(data);
        this.setFacing(Direction.m_122376_((int)data.m_128451_("facing")));
        this.setDelay(data.m_128451_("delay"));
        this.setActive(data.m_128471_("active"));
        this.setBurnTime(data.m_128451_("burnTime"));
        this.setFuel(data.m_128451_("fuel"));
    }

    protected int getDelay() {
        return this.delay;
    }

    protected void setDelay(int i) {
        this.delay = i;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        Train.State state;
        this.active = active;
        Train.State state2 = state = active ? Train.State.STOPPED : Train.State.NORMAL;
        if (!this.m_9236_().m_5776_()) {
            RollingStock.getOrThrow((AbstractMinecart)this).train().setState(state);
        }
    }

    protected boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    protected void setMoving(boolean moving) {
        this.f_19804_.m_135381_(MOVING, (Object)moving);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public boolean outOfFuel() {
        return this.getFuel() <= 12;
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    protected void stockFuel() {
        ItemStack stack = RollingStock.getOrThrow((AbstractMinecart)this).pullItem(this.fuelContainer::canFit);
        if (!stack.m_41619_()) {
            this.fuelContainer.insert(stack);
        }
    }

    protected void addFuel() {
        int burn = 0;
        for (int slot = 0; slot < this.fuelContainer.m_6643_(); ++slot) {
            ItemStack stack = this.fuelContainer.m_8020_(slot);
            if (stack.m_41619_() || (burn = ForgeHooks.getBurnTime((ItemStack)stack, null)) <= 0) continue;
            if (stack.m_41720_().hasCraftingRemainingItem(stack)) {
                this.fuelContainer.m_6836_(slot, stack.m_41720_().getCraftingRemainingItem(stack));
                break;
            }
            this.fuelContainer.m_7407_(slot, 1);
            break;
        }
        if (burn > 0) {
            this.setBurnTime(burn + this.getFuel());
            this.setFuel(this.getFuel() + burn);
        }
    }

    public int getBurnProgressScaled(int i) {
        int burn = this.getBurnTime();
        if (burn == 0) {
            return 0;
        }
        return this.getFuel() * i / burn;
    }

    protected void spendFuel() {
        this.setFuel(this.getFuel() - 12);
    }

    protected void forceUpdateBoreHead() {
        ItemStack boreStack = this.m_8020_(0);
        if (!boreStack.m_41619_()) {
            boreStack = boreStack.m_41777_();
        }
        this.f_19804_.m_135381_(BORE_HEAD, (Object)boreStack);
    }

    @Nullable
    public TunnelBoreHead getBoreHead() {
        ItemStack boreStack = (ItemStack)this.f_19804_.m_135370_(BORE_HEAD);
        Item item = boreStack.m_41720_();
        if (item instanceof TunnelBoreHead) {
            TunnelBoreHead head = (TunnelBoreHead)item;
            return head;
        }
        return null;
    }

    protected void m_7114_() {
        this.m_20256_(this.m_20184_().m_82542_(0.991999979019165, 0.0, 0.991999979019165));
    }

    @Override
    public boolean isPoweredCart() {
        return true;
    }

    public void m_6596_() {
        if (!this.isActive()) {
            this.setDelay(5);
        }
    }

    public final Direction getFacing() {
        return (Direction)this.f_19804_.m_135370_(FACING);
    }

    protected final void setFacing(Direction facing) {
        this.f_19804_.m_135381_(FACING, (Object)facing);
        this.setYaw();
    }

    @Override
    public Optional<Side> disabledSide() {
        return Optional.of(Side.FRONT);
    }

    @Override
    public boolean isLinkableWith(RollingStock cart) {
        BlockPos pos = this.getPositionAhead(-3.1f);
        float dist = 2.5f;
        dist *= dist;
        return cart.entity().m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < (double)dist;
    }

    @Override
    public float getLinkageDistance(RollingStock cart) {
        return 4.0f;
    }

    @Override
    public float getOptimalDistance(RollingStock cart) {
        return 3.1f;
    }

    @Override
    public void linked(RollingStock cart) {
    }

    @Override
    public void unlinked(RollingStock cart) {
    }

    @Override
    public boolean canBeAdjusted(RollingStock cart) {
        return !this.isActive();
    }

    public boolean shouldDoRailFunctions() {
        return false;
    }

    public PartEntity<?>[] getParts() {
        return this.parts;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.containers.stream().filter(m -> m.containsSlot(index)).allMatch(m -> m.filter().test(stack));
    }

    public boolean attackEntityFromPart(TunnelBorePart part, DamageSource damageSource, float damage) {
        return this.m_6469_(damageSource, damage);
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory inventory) {
        return new TunnelBoreMenu(id, inventory, this);
    }
}

