/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.Optional;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.FluidTransferHandler;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.FilteredMinecart;
import mods.railcraft.world.inventory.TankMinecartMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.material.FluidItemHelper;
import mods.railcraft.world.level.material.FluidTools;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class TankMinecart
extends FilteredMinecart
implements WorldlyContainer,
FluidTransferHandler {
    private static final EntityDataAccessor<CompoundTag> FLUID_STACK_TAG = SynchedEntityData.m_135353_(TankMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> FILLING = SynchedEntityData.m_135353_(TankMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_PROCESSING = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 3);
    private final StandardTank tank;
    private final LazyOptional<IFluidHandler> fluidHandlerCapability;
    private final ContainerMapper invLiquids;
    private int fluidProcessingTimer;
    private FluidTools.ProcessState processState;

    public TankMinecart(EntityType<?> type, Level level) {
        super(type, level);
        this.tank = StandardTank.ofBuckets((Integer)RailcraftConfig.SERVER.tankCartFluidCapacity.get()).changeCallback(this::tankChanged).setValidator(fluidStack -> this.getFilterFluid().map(arg_0 -> ((FluidStack)fluidStack).isFluidEqual(arg_0)).orElse(true));
        this.fluidHandlerCapability = LazyOptional.of(() -> this.tank);
        this.invLiquids = ContainerMapper.make((Container)this).ignoreItemChecks();
        this.processState = FluidTools.ProcessState.RESET;
    }

    public TankMinecart(ItemStack itemStack, double x, double y, double z, Level level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.TANK_MINECART.get(), x, y, z, level);
        this.tank = StandardTank.ofBuckets((Integer)RailcraftConfig.SERVER.tankCartFluidCapacity.get()).changeCallback(this::tankChanged).setValidator(fluidStack -> this.getFilterFluid().map(arg_0 -> ((FluidStack)fluidStack).isFluidEqual(arg_0)).orElse(true));
        this.fluidHandlerCapability = LazyOptional.of(() -> this.tank);
        this.invLiquids = ContainerMapper.make((Container)this).ignoreItemChecks();
        this.processState = FluidTools.ProcessState.RESET;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLUID_STACK_TAG, (Object)new CompoundTag());
        this.f_19804_.m_135372_(FILLING, (Object)false);
    }

    private void tankChanged() {
        this.f_19804_.m_135381_(FLUID_STACK_TAG, (Object)this.tank.getFluid().writeToNBT(new CompoundTag()));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        if (key.equals(FLUID_STACK_TAG)) {
            this.tank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)this.f_19804_.m_135370_(FLUID_STACK_TAG))));
        }
    }

    public StandardTank getTankManager() {
        return this.tank;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.FLUID_HANDLER ? this.fluidHandlerCapability.cast() : super.getCapability(capability, facing);
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.invLiquids);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ContainerTools.dropIfInvalid(this.m_9236_(), this.m_20183_(), (Container)this, 0);
        ContainerTools.drop(this.m_9236_(), this.m_20183_(), (Container)this, 1, FluidItemHelper::isContainer);
        ContainerTools.drop(this.m_9236_(), this.m_20183_(), (Container)this, 2, FluidItemHelper::isContainer);
        if (this.fluidProcessingTimer++ >= 8) {
            this.fluidProcessingTimer = 0;
            this.processState = FluidTools.processContainer(this.invLiquids, this.tank, FluidTools.ProcessType.DRAIN_THEN_FILL, this.processState);
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (FluidTools.interactWithFluidHandler(player, hand, (IFluidHandler)this.getTankManager())) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public int m_6643_() {
        return 3;
    }

    @Override
    protected void m_7378_(CompoundTag data) {
        super.m_7378_(data);
        this.processState = FluidTools.ProcessState.getByName(data.m_128461_("processState")).orElse(FluidTools.ProcessState.RESET);
        this.tank.readFromNBT(data.m_128469_("tank"));
    }

    @Override
    protected void m_7380_(CompoundTag data) {
        super.m_7380_(data);
        data.m_128359_("processState", this.processState.m_7912_());
        CompoundTag tankTag = new CompoundTag();
        this.tank.writeToNBT(tankTag);
        data.m_128365_("tank", (Tag)tankTag);
    }

    public boolean isFilling() {
        return (Boolean)this.f_19804_.m_135370_(FILLING);
    }

    @Override
    public void setFilling(boolean filling) {
        this.f_19804_.m_135381_(FILLING, (Object)filling);
    }

    public Optional<FluidStack> getFilterFluid() {
        return FluidUtil.getFluidContained((ItemStack)this.getFilterItem());
    }

    public Container getInvLiquids() {
        return this.invLiquids;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return slot == 0 && FluidItemHelper.isContainer(stack);
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction side) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction side) {
        return slot == 2;
    }

    @Override
    public boolean canPassFluidRequests(FluidStack fluid) {
        return this.getFilterFluid().map(filter -> filter.isFluidEqual(fluid)).orElseGet(() -> this.tank.isEmpty() && this.tank.getFluid().isFluidEqual(fluid));
    }

    @Override
    public boolean canAcceptPushedFluid(RollingStock requester, FluidStack fluid) {
        return this.canPassFluidRequests(fluid);
    }

    @Override
    public boolean canProvidePulledFluid(RollingStock requester, FluidStack fluid) {
        return this.canPassFluidRequests(fluid);
    }

    @Override
    public ItemStack m_142340_() {
        return ((Item)RailcraftItems.TANK_MINECART.get()).m_7968_();
    }

    public Item m_213728_() {
        return (Item)RailcraftItems.TANK_MINECART.get();
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory playerInventory) {
        return new TankMinecartMenu(id, playerInventory, this);
    }
}

