/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class FilteredInvWrapper
extends InvWrapper {
    private final boolean allowInsert;
    private final boolean allowExtract;

    public FilteredInvWrapper(Container inv, boolean allowInsert, boolean allowExtract) {
        super(inv);
        this.allowInsert = allowInsert;
        this.allowExtract = allowExtract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FilteredInvWrapper that = (FilteredInvWrapper)((Object)o);
        return super.equals(o) && that.allowInsert == this.allowInsert && that.allowExtract == this.allowExtract;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.allowInsert) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.allowExtract) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (!this.allowInsert) {
            return;
        }
        super.setStackInSlot(slot, stack);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (!this.allowInsert) {
            return false;
        }
        return super.isItemValid(slot, stack);
    }
}

