/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import mods.railcraft.api.item.Filter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerTools {
    public static void requiresNotEmpty(ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalStateException("Item cannot be empty.");
        }
    }

    public static boolean canMerge(ItemStack target, ItemStack source) {
        return target.m_41619_() || source.m_41619_() || ItemStack.m_41656_((ItemStack)target, (ItemStack)source) && target.m_41613_() + source.m_41613_() <= target.m_41741_();
    }

    public static int[] buildSlotArray(int start, int size) {
        return IntStream.range(0, size).map(i -> start + i).toArray();
    }

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack.m_41613_() == 1) {
            return stack.m_41720_().getCraftingRemainingItem(stack);
        }
        stack.m_41620_(1);
        return stack;
    }

    public static void dropIfInvalid(Level level, BlockPos blockPos, Container container, int index) {
        ContainerTools.drop(level, blockPos, container, index, item -> container.m_7013_(index, item));
    }

    public static void drop(Level level, BlockPos blockPos, Container container, int index, Predicate<ItemStack> predicate) {
        ItemStack item = container.m_8020_(index);
        if (!item.m_41619_() && !predicate.test(item)) {
            container.m_6836_(index, ItemStack.f_41583_);
            Containers.m_18992_((Level)level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)item);
        }
    }

    public static boolean matchesFilter(ItemStack filter, ItemStack stack) {
        if (stack.m_41619_() || filter.m_41619_()) {
            return false;
        }
        Item item = filter.m_41720_();
        if (item instanceof Filter) {
            Filter filterItem = (Filter)item;
            return filterItem.matches(filter, stack);
        }
        return ItemStack.m_41656_((ItemStack)stack, (ItemStack)filter);
    }

    public static boolean isItemEqualStrict(@Nullable ItemStack a, @Nullable ItemStack b) {
        if (a.m_41619_() && b.m_41619_()) {
            return true;
        }
        if (a.m_41619_() || b.m_41619_()) {
            return false;
        }
        if (a.m_41720_() != b.m_41720_()) {
            return false;
        }
        if (a.m_41613_() != b.m_41613_()) {
            return false;
        }
        if (a.m_41773_() != b.m_41773_()) {
            return false;
        }
        return a.m_41783_() == null || b.m_41783_() == null || a.m_41783_().equals((Object)b.m_41783_());
    }

    public static ListTag writeContainer(Container container) {
        ListTag tag = new ListTag();
        for (byte i = 0; i < container.m_6643_(); i = (byte)((byte)(i + 1))) {
            ItemStack itemStack = container.m_8020_((int)i);
            if (itemStack.m_41619_()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128344_("index", i);
            itemStack.m_41739_(slotTag);
            tag.add((Object)slotTag);
        }
        return tag;
    }

    public static void readContainer(Container container, ListTag tag) {
        for (int i = 0; i < tag.size(); i = (int)((byte)(i + 1))) {
            CompoundTag slotTag = tag.m_128728_(i);
            byte slot = slotTag.m_128445_("index");
            if (slot < 0 || slot >= container.m_6643_()) continue;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)slotTag);
            container.m_6836_((int)slot, itemStack);
        }
    }

    public static boolean isItemStackBlock(ItemStack itemStack, Block block) {
        BlockItem item;
        Item item2;
        return !itemStack.m_41619_() && (item2 = itemStack.m_41720_()) instanceof BlockItem && (item = (BlockItem)item2).m_40614_() == block;
    }

    public static Block getBlockFromStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return Blocks.f_50016_;
        }
        Item item = stack.m_41720_();
        return item instanceof BlockItem ? ((BlockItem)item).m_40614_() : Blocks.f_50016_;
    }

    public static BlockState getBlockStateFromStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return Blocks.f_50016_.m_49966_();
        }
        return ContainerTools.getBlockFromStack(stack).m_49966_();
    }

    @Nullable
    public static BlockState getBlockStateFromStack(ItemStack stack, Level level, BlockPos pos) {
        if (stack.m_41619_()) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_().m_5573_(new BlockPlaceContext(level, null, InteractionHand.MAIN_HAND, stack, new BlockHitResult(new Vec3(0.5, 0.5, 0.5), Direction.UP, pos.m_7494_(), false)));
        }
        return null;
    }

    public static boolean isStackFull(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41613_() == stack.m_41741_();
    }
}

