/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.List;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ContainerSlotAccessor;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.world.module.ModuleProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AdvancedContainer
extends SimpleContainer
implements ContainerManipulator<ModifiableSlotAccessor> {
    private final List<ModifiableSlotAccessor> slots;
    @Nullable
    private Listener listener;
    private int maxStackSize = 64;

    public AdvancedContainer(int size) {
        super(size);
        this.slots = ContainerSlotAccessor.createSlots((Container)this, 0, size).toList();
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.slots.stream();
    }

    public AdvancedContainer listener(Container container) {
        return this.listener(new ContainerCallback(container));
    }

    public AdvancedContainer listener(ModuleProvider moduleProvider) {
        return this.listener(new ModuleProviderCallback(moduleProvider));
    }

    public AdvancedContainer listener(Listener callback) {
        this.listener = callback;
        this.m_19164_(callback);
        return this;
    }

    public AdvancedContainer phantom() {
        this.maxStackSize = 127;
        return this;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public int m_6893_() {
        return this.maxStackSize;
    }

    public boolean m_6542_(Player player) {
        return this.listener == null || this.listener.stillValid(player);
    }

    public void m_5856_(Player player) {
        if (this.listener != null) {
            this.listener.startOpen(player);
        }
    }

    public void m_5785_(Player player) {
        if (this.listener != null) {
            this.listener.stopOpen(player);
        }
    }

    public void m_7797_(ListTag tag) {
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag slotTag = tag.m_128728_(i);
            this.m_6836_(slotTag.m_128451_("index"), ItemStack.m_41712_((CompoundTag)slotTag));
        }
    }

    public ListTag m_7927_() {
        ListTag tag = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128405_("index", i);
            this.m_8020_(i).m_41739_(slotTag);
            tag.add((Object)slotTag);
        }
        return tag;
    }

    public static AdvancedContainer copyOf(Container original) {
        AdvancedContainer copy = new AdvancedContainer(original.m_6643_());
        for (int i = 0; i < original.m_6643_(); ++i) {
            ItemStack itemStack = original.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            copy.m_6836_(i, itemStack.m_41777_());
        }
        return copy;
    }

    public static class ContainerCallback
    implements Listener {
        private final Container container;

        public ContainerCallback(Container container) {
            this.container = container;
        }

        @Override
        public boolean stillValid(Player player) {
            return this.container.m_6542_(player);
        }

        @Override
        public void startOpen(Player player) {
            this.container.m_5856_(player);
        }

        @Override
        public void stopOpen(Player player) {
            this.container.m_5785_(player);
        }

        public void m_5757_(Container container) {
            this.container.m_6596_();
        }
    }

    public static interface Listener
    extends ContainerListener {
        default public boolean stillValid(Player player) {
            return true;
        }

        default public void startOpen(Player player) {
        }

        default public void stopOpen(Player player) {
        }
    }

    public static class ModuleProviderCallback
    implements Listener {
        private final ModuleProvider moduleProvider;

        public ModuleProviderCallback(ModuleProvider moduleProvider) {
            this.moduleProvider = moduleProvider;
        }

        @Override
        public boolean stillValid(Player player) {
            return this.moduleProvider.isStillValid(player);
        }

        public void m_5757_(Container container) {
            this.moduleProvider.save();
        }
    }
}

