/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.util.Predicates;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.ArrayUtils;

public final class EntitySearcher {
    private static final EntityTypeTest<Entity, Entity> ANY_TYPE = new EntityTypeTest<Entity, Entity>(){

        public Entity tryCast(Entity entity) {
            return entity;
        }

        public Class<? extends Entity> m_142225_() {
            return Entity.class;
        }
    };

    public static SearchParameters<AbstractMinecart> findMinecarts() {
        return EntitySearcher.find(AbstractMinecart.class);
    }

    public static SearchParameters<LivingEntity> findLiving() {
        return EntitySearcher.find(LivingEntity.class);
    }

    public static SearchParameters<Entity> find() {
        return EntitySearcher.find(ANY_TYPE);
    }

    public static <T extends Entity> SearchParameters<T> find(Class<T> clazz) {
        return EntitySearcher.find(EntityTypeTest.m_156916_(clazz));
    }

    public static <T extends Entity> SearchParameters<T> find(EntityTypeTest<Entity, T> typeTest) {
        return new SearchParameters<T>(typeTest);
    }

    public static class SearchParameters<T extends Entity> {
        private final EntityTypeTest<Entity, T> typeTest;
        private BoxBuilder box = BoxBuilder.create();
        private Predicate<T> filter = ModEntitySelector.LIVING::test;

        public SearchParameters(EntityTypeTest<Entity, T> typeTest) {
            this.typeTest = typeTest;
        }

        public Stream<T> stream(Level level) {
            return this.list(level).stream();
        }

        public List<T> list(Level level) {
            if (this.box.isUndefined()) {
                throw new NullPointerException("Improperly defined EntitySearcher without a search box");
            }
            return level.m_142425_(this.typeTest, this.box.build(), this.filter::test);
        }

        public SearchParameters<T> except(Entity entity) {
            this.filter = this.filter.and((? super T e) -> e != entity);
            return this;
        }

        public SearchParameters<T> in(AABB aabb) {
            this.box.fromAABB(aabb);
            return this;
        }

        public SearchParameters<T> box(Consumer<BoxBuilder> consumer) {
            consumer.accept(this.box);
            return this;
        }

        public SearchParameters<T> at(BlockPos pos) {
            this.box.at(pos);
            return this;
        }

        public SearchParameters<T> around(Entity entity) {
            this.box.fromAABB(entity.m_20191_());
            return this;
        }

        public SearchParameters<T> inflateHorizontally(double distance) {
            this.box.inflateHorizontally(distance);
            return this;
        }

        public SearchParameters<T> inflate(double distance) {
            this.box.inflate(distance);
            return this;
        }

        public SearchParameters<T> upTo(double distance) {
            this.box.upTo(distance);
            return this;
        }

        @SafeVarargs
        public final SearchParameters<T> and(Predicate<? super T> ... filters) {
            if (!ArrayUtils.isEmpty((Object[])filters)) {
                this.filter = Predicates.and(this.filter, filters);
            }
            return this;
        }
    }
}

