/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class RailcraftDataSerializers {
    public static final EntityDataSerializer<FluidStack> FLUID_STACK = new EntityDataSerializer<FluidStack>(){

        public void write(FriendlyByteBuf buf, FluidStack value) {
            buf.writeFluidStack(value);
        }

        public FluidStack read(FriendlyByteBuf buf) {
            return buf.readFluidStack();
        }

        public FluidStack copy(FluidStack value) {
            return value.copy();
        }
    };
    public static final EntityDataSerializer<byte[]> BYTE_ARRAY = new EntityDataSerializer<byte[]>(){

        public void write(FriendlyByteBuf packetBuffer, byte[] bytes) {
            packetBuffer.m_130087_(bytes);
        }

        public byte[] read(FriendlyByteBuf packetBuffer) {
            return packetBuffer.m_130052_();
        }

        public byte[] copy(byte[] value) {
            return Arrays.copyOf(value, value.length);
        }
    };
    public static final EntityDataSerializer<Optional<GameProfile>> OPTIONAL_GAME_PROFILE = new EntityDataSerializer<Optional<GameProfile>>(){

        public void write(FriendlyByteBuf packetBuffer, Optional<GameProfile> gameProfile) {
            packetBuffer.m_236835_(gameProfile, FriendlyByteBuf::m_236803_);
        }

        public Optional<GameProfile> read(FriendlyByteBuf packetBuffer) {
            return packetBuffer.m_236860_(FriendlyByteBuf::m_236875_);
        }

        public Optional<GameProfile> copy(Optional<GameProfile> gameProfile) {
            return gameProfile;
        }
    };
    private static final DeferredRegister<EntityDataSerializer<?>> deferredRegister = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"railcraft");

    public static void register(IEventBus modEventBus) {
        deferredRegister.register("fluid_stack", () -> FLUID_STACK);
        deferredRegister.register("byte_array", () -> BYTE_ARRAY);
        deferredRegister.register("optional_game_profile", () -> OPTIONAL_GAME_PROFILE);
        deferredRegister.register(modEventBus);
    }

    public static <T extends Enum<T>> void setEnum(SynchedEntityData dataManager, EntityDataAccessor<Byte> parameter, Enum<T> value) {
        dataManager.m_135381_(parameter, (Object)((byte)value.ordinal()));
    }

    public static <T extends Enum<T>> T getEnum(SynchedEntityData dataManager, EntityDataAccessor<Byte> parameter, T[] values) {
        return values[(Byte)dataManager.m_135370_(parameter)];
    }
}

