/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.CrusherRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CrusherRecipeCategory
implements IRecipeCategory<CrusherRecipe> {
    private static final int WIDTH = 144;
    private static final int HEIGHT = 54;
    private static final ResourceLocation CRUSHER_BACKGROUND = new ResourceLocation("railcraft", "textures/gui/container/crusher.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;

    public CrusherRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(CRUSHER_BACKGROUND, 0, 171, 144, 54);
        ItemStack itemStack = new ItemStack((ItemLike)RailcraftItems.CRUSHER.get());
        this.icon = guiHelper.createDrawableItemStack(itemStack);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(CRUSHER_BACKGROUND, 144, 171, 29, 53), 500, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<CrusherRecipe> getRecipeType() {
        return RecipeTypes.CRUSHER;
    }

    public Component getTitle() {
        return Component.m_237115_((String)Translations.Jei.CRUSHER);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CrusherRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 58, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrusherRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 19).addIngredients((Ingredient)ingredients.get(0));
        List<Tuple<ItemStack, Double>> outputs = recipe.getProbabilityItems();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                ItemStack itemStack = ItemStack.f_41583_;
                if (outputs.size() > index - 1) {
                    itemStack = (ItemStack)outputs.get(index - 1).m_14418_();
                }
                IRecipeSlotBuilder recipeLayout = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 91 + x * 18, y * 18 + 1).addItemStack(itemStack);
                if (itemStack.m_41619_()) continue;
                recipeLayout.addTooltipCallback((recipeSlotView, tooltip) -> {
                    double probability = (Double)((Tuple)outputs.get(index - 1)).m_14419_() * 100.0;
                    MutableComponent probText = Component.m_237110_((String)Translations.Jei.CRUSHER_TIP, (Object[])new Object[]{probability}).m_130940_(ChatFormatting.GRAY);
                    tooltip.add(probText);
                });
            }
        }
    }
}

