/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CrusherRecipeBuilder {
    public static final int DEFAULT_PROCESSING_TIME = 200;
    private static final int MAX_SLOTS = 9;
    private final Ingredient ingredient;
    private final List<Tuple<ItemStack, Double>> probabilityItems;
    private final int processTime;

    private CrusherRecipeBuilder(Ingredient ingredient, int processTime) {
        this.ingredient = ingredient;
        this.probabilityItems = new ArrayList<Tuple<ItemStack, Double>>();
        this.processTime = processTime;
    }

    public static CrusherRecipeBuilder crush(Ingredient ingredient) {
        return CrusherRecipeBuilder.crush(ingredient, 200);
    }

    public static CrusherRecipeBuilder crush(Ingredient ingredient, int processTime) {
        return new CrusherRecipeBuilder(ingredient, processTime);
    }

    public CrusherRecipeBuilder addResult(ItemLike item, int quantity, double probability) {
        if (this.probabilityItems.size() >= 9) {
            throw new IllegalStateException("Reached the maximum number of available slots as a result: 9");
        }
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalStateException("The probability must be between 0 and 1! You have inserted: " + probability);
        }
        ItemStack itemStack = new ItemStack(item, quantity);
        this.probabilityItems.add((Tuple<ItemStack, Double>)new Tuple((Object)itemStack, (Object)probability));
        return this;
    }

    public void save(Consumer<FinishedRecipe> finishedRecipe) {
        String itemPath = Arrays.stream(this.ingredient.m_43908_()).filter(x -> !x.m_150930_(Items.f_42127_)).findFirst().map(x -> ForgeRegistries.ITEMS.getKey((Object)x.m_41720_()).m_135815_()).orElseThrow();
        this.save(finishedRecipe, itemPath);
    }

    public void save(Consumer<FinishedRecipe> finishedRecipe, String path) {
        ResourceLocation customResourceLocation = new ResourceLocation("railcraft", "crusher/crushing_" + path);
        finishedRecipe.accept(new Result(customResourceLocation, this.ingredient, this.probabilityItems, this.processTime));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final List<Tuple<ItemStack, Double>> probabilityItems;
        private final int processTime;

        public Result(ResourceLocation resourceLocation, Ingredient ingredient, List<Tuple<ItemStack, Double>> probabilityItems, int processTime) {
            this.id = resourceLocation;
            this.ingredient = ingredient;
            this.probabilityItems = probabilityItems;
            this.processTime = processTime;
        }

        public void m_7917_(JsonObject jsonOut) {
            jsonOut.addProperty("processTime", (Number)this.processTime);
            jsonOut.add("ingredient", this.ingredient.m_43942_());
            JsonArray result = new JsonArray();
            for (Tuple<ItemStack, Double> item : this.probabilityItems) {
                JsonObject pattern = new JsonObject();
                JsonObject itemStackObject = new JsonObject();
                itemStackObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)((ItemStack)item.m_14418_()).m_41720_()).toString());
                itemStackObject.addProperty("count", (Number)((ItemStack)item.m_14418_()).m_41613_());
                pattern.add("result", (JsonElement)itemStackObject);
                pattern.addProperty("probability", (Number)item.m_14419_());
                result.add((JsonElement)pattern);
            }
            jsonOut.add("output", (JsonElement)result);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RailcraftRecipeSerializers.CRUSHER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

