/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mods.railcraft.data.recipes.builders.RailcraftSpecialRecipeBuilder;
import mods.railcraft.data.recipes.providers.BlastFurnaceRecipeProvider;
import mods.railcraft.data.recipes.providers.CokeOvenRecipeProvider;
import mods.railcraft.data.recipes.providers.CrusherRecipeProvider;
import mods.railcraft.data.recipes.providers.RollingRecipeProvider;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.VariantRegistrar;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class RailcraftRecipeProvider
extends RecipeProvider {
    public RailcraftRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        CokeOvenRecipeProvider.genRecipes(consumer);
        BlastFurnaceRecipeProvider.genRecipes(consumer);
        CrusherRecipeProvider.genRecipes(consumer);
        RollingRecipeProvider.genRecipes(consumer);
        this.buildMultiblockBlocks(consumer);
        this.buildBlockStorageRecipes(consumer);
        this.buildIngotsRecipes(consumer);
        this.buildGears(consumer);
        this.buildKits(consumer);
        this.buildTankBlocks(consumer);
        this.buildPost(consumer);
        this.buildStrengthenedGlass(consumer);
        this.buildTie(consumer);
        this.buildCement(consumer);
        this.buildRails(consumer);
        this.buildTracks(consumer);
        this.buildSteelItems(consumer);
        this.buildTunnelBoreHead(consumer);
        this.buildMaul(consumer);
        this.buildOreSmelt(consumer);
        this.buildTurbineParts(consumer);
        this.buildChargeItems(consumer);
        this.buildSignalBox(consumer);
        this.buildSignals(consumer);
        this.buildCircuit(consumer);
        this.buildMiscItems(consumer);
        this.buildCartsVariant(consumer);
        this.buildSwitch(consumer);
        this.buildLoaders(consumer);
        this.buildCrowbars(consumer);
        this.buildFirestones(consumer);
        this.buildQuarriedStone(consumer);
        this.buildAbyssalStone(consumer);
        this.buildBattery(consumer);
        this.buildFrame(consumer);
    }

    private void conversion(Consumer<FinishedRecipe> finishedRecipe, ItemLike from, ItemLike to, int count, String optionalName) {
        ResourceLocation path = optionalName.isEmpty() ? RecipeBuilder.m_176493_((ItemLike)to) : new ResourceLocation("railcraft", optionalName);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)to, (int)count).m_126209_(from).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)from), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)from)).m_126140_(finishedRecipe, path);
    }

    private void buildRails(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.railsFromMaterials(consumer, (Item)RailcraftItems.ABANDONED_TRACK.get(), 32, (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        RailcraftRecipeProvider.railsFromMaterials(consumer, (Item)RailcraftItems.STRAP_IRON_TRACK.get(), 32, (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(consumer, Items.f_41964_, 32, (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(consumer, (Item)RailcraftItems.REINFORCED_TRACK.get(), 32, (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(consumer, (Item)RailcraftItems.ELECTRIC_TRACK.get(), 32, (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(consumer, (Item)RailcraftItems.HIGH_SPEED_TRACK.get(), 32, (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get(), 32, (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get());
        RailcraftRecipeProvider.railsFromMaterials(consumer, (Item)RailcraftItems.ELEVATOR_TRACK.get(), 8, (Item)RailcraftItems.ADVANCED_RAIL.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), Items.f_42451_);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WOODEN_RAIL.get()), (int)6).m_126209_((ItemLike)RailcraftItems.WOODEN_TIE.get()).m_206419_(Tags.Items.INGOTS_IRON).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get()))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STANDARD_RAIL.get())).m_126211_((ItemLike)Items.f_41964_, 8).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_41964_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_41964_)).m_126140_(consumer, new ResourceLocation("railcraft", "standard_rail_from_rail"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WOODEN_RAILBED.get())).m_126211_((ItemLike)RailcraftItems.WOODEN_TIE.get(), 4).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get()))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STONE_RAILBED.get())).m_126211_((ItemLike)RailcraftItems.STONE_TIE.get(), 4).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get()))).m_176498_(consumer);
    }

    private static void railsFromMaterials(Consumer<FinishedRecipe> finishedRecipe, Item result, int count, Item railType, Item railBedType) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).m_126130_("a a").m_126130_("aba").m_126130_("a a").m_126127_(Character.valueOf('a'), (ItemLike)railType).m_126127_(Character.valueOf('b'), (ItemLike)railBedType).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)railType), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)railType)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)railBedType), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)railBedType)).m_126140_(finishedRecipe, new ResourceLocation(result.equals(Items.f_41964_) ? "minecraft" : "railcraft", RecipeBuilder.m_176493_((ItemLike)result).m_135815_()));
    }

    private static void railsFromMaterials(Consumer<FinishedRecipe> finishedRecipe, Item result, int count, Item railType, Item railBedType, Item optionalItem) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).m_126130_("aca").m_126130_("aba").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)railType).m_126127_(Character.valueOf('b'), (ItemLike)railBedType).m_126127_(Character.valueOf('c'), (ItemLike)optionalItem).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)railType), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)railType)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)railBedType), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)railBedType)).m_176498_(finishedRecipe);
    }

    private void buildTracks(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ABANDONED_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.IRON_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), Items.f_41964_);
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.STRAP_IRON_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.REINFORCED_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.ELECTRIC_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_TRANSITION_TRACK.get(), (Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(consumer, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRANSITION_TRACK.get(), (Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.wyeTracks(consumer, (Item)RailcraftItems.STRAP_IRON_WYE_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.wyeTracks(consumer, (Item)RailcraftItems.ABANDONED_WYE_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        RailcraftRecipeProvider.wyeTracks(consumer, (Item)RailcraftItems.IRON_WYE_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.wyeTracks(consumer, (Item)RailcraftItems.REINFORCED_WYE_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.wyeTracks(consumer, (Item)RailcraftItems.ELECTRIC_WYE_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.wyeTracks(consumer, (Item)RailcraftItems.HIGH_SPEED_WYE_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(consumer, (Item)RailcraftItems.STRAP_IRON_TURNOUT_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(consumer, (Item)RailcraftItems.ABANDONED_TURNOUT_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        RailcraftRecipeProvider.turnoutTracks(consumer, (Item)RailcraftItems.IRON_TURNOUT_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(consumer, (Item)RailcraftItems.REINFORCED_TURNOUT_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(consumer, (Item)RailcraftItems.ELECTRIC_TURNOUT_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(consumer, (Item)RailcraftItems.HIGH_SPEED_TURNOUT_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(consumer, (Item)RailcraftItems.STRAP_IRON_JUNCTION_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(consumer, (Item)RailcraftItems.ABANDONED_JUNCTION_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        RailcraftRecipeProvider.junctionTracks(consumer, (Item)RailcraftItems.IRON_JUNCTION_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(consumer, (Item)RailcraftItems.REINFORCED_JUNCTION_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(consumer, (Item)RailcraftItems.ELECTRIC_JUNCTION_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(consumer, (Item)RailcraftItems.HIGH_SPEED_JUNCTION_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_WYE_TRACK.get()), (int)16).m_126130_("aba").m_126130_("aac").m_126130_("aba").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_TURNOUT_TRACK.get()), (int)16).m_126130_("aca").m_126130_("aba").m_126130_("aba").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_JUNCTION_TRACK.get()), (int)16).m_126130_("aba").m_126130_("aca").m_126130_("aba").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()))).m_176498_(consumer);
    }

    private static void tracks(Consumer<FinishedRecipe> finishedRecipe, Item result, Item kit, Item baseTrack) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126209_((ItemLike)kit).m_126209_((ItemLike)baseTrack).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)kit), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)kit)).m_176498_(finishedRecipe);
    }

    private static void wyeTracks(Consumer<FinishedRecipe> finishedRecipe, Item result, Item rail, Item railBed) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)16).m_126130_("aaa").m_126130_("aab").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)rail).m_126127_(Character.valueOf('b'), (ItemLike)railBed).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)rail), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)rail)).m_176498_(finishedRecipe);
    }

    private static void turnoutTracks(Consumer<FinishedRecipe> finishedRecipe, Item result, Item rail, Item railBed) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)16).m_126130_("aba").m_126130_("aaa").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)rail).m_126127_(Character.valueOf('b'), (ItemLike)railBed).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)rail), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)rail)).m_176498_(finishedRecipe);
    }

    private static void junctionTracks(Consumer<FinishedRecipe> finishedRecipe, Item result, Item rail, Item railBed) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)16).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)rail).m_126127_(Character.valueOf('b'), (ItemLike)railBed).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)rail), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)rail)).m_176498_(finishedRecipe);
    }

    private void buildSteelItems(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_ANVIL.get())).m_126130_("aaa").m_126130_(" b ").m_126130_("bbb").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).m_206416_(Character.valueOf('b'), RailcraftTags.Items.STEEL_INGOT).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_BLOCK.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_BLOCK)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_SHEARS.get())).m_126130_(" a").m_126130_("a ").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_SWORD.get())).m_126130_("a").m_126130_("a").m_126130_("b").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_SHOVEL.get())).m_126130_("a").m_126130_("b").m_126130_("b").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_PICKAXE.get())).m_126130_("aaa").m_126130_(" b ").m_126130_(" b ").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_AXE.get())).m_126130_("aa").m_126130_("ab").m_126130_(" b").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_HOE.get())).m_126130_("aa").m_126130_(" b").m_126130_(" b").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_BOOTS.get())).m_126130_("a a").m_126130_("a a").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_LEGGINGS.get())).m_126130_("aaa").m_126130_("a a").m_126130_("a a").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_CHESTPLATE.get())).m_126130_("a a").m_126130_("aaa").m_126130_("aaa").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_HELMET.get())).m_126130_("aaa").m_126130_("a a").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
    }

    private void buildTunnelBoreHead(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.tunnelBoreHead(consumer, (Item)RailcraftItems.BRONZE_TUNNEL_BORE_HEAD.get(), RailcraftTags.Items.BRONZE_BLOCK);
        RailcraftRecipeProvider.tunnelBoreHead(consumer, (Item)RailcraftItems.IRON_TUNNEL_BORE_HEAD.get(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
        RailcraftRecipeProvider.tunnelBoreHead(consumer, (Item)RailcraftItems.STEEL_TUNNEL_BORE_HEAD.get(), RailcraftTags.Items.STEEL_BLOCK);
        RailcraftRecipeProvider.tunnelBoreHead(consumer, (Item)RailcraftItems.DIAMOND_TUNNEL_BORE_HEAD.get(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
    }

    private static void tunnelBoreHead(Consumer<FinishedRecipe> consumer, Item result, TagKey<Item> center) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_206416_(Character.valueOf('b'), center).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_176498_(consumer);
    }

    private void buildMaul(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.IRON_SPIKE_MAUL.get())).m_126130_("aca").m_126130_(" b ").m_126130_(" b ").m_206416_(Character.valueOf('a'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_206416_(Character.valueOf('c'), Tags.Items.STORAGE_BLOCKS_IRON).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_41913_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.STORAGE_BLOCKS_IRON)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_SPIKE_MAUL.get())).m_126130_("aca").m_126130_(" b ").m_126130_(" b ").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_206416_(Character.valueOf('c'), RailcraftTags.Items.STEEL_BLOCK).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_BLOCK.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_BLOCK)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.DIAMOND_SPIKE_MAUL.get())).m_126130_("aca").m_126130_(" b ").m_126130_(" b ").m_206416_(Character.valueOf('a'), Tags.Items.GEMS_DIAMOND).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42398_).m_206416_(Character.valueOf('c'), Tags.Items.STORAGE_BLOCKS_DIAMOND).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_41959_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND)).m_176498_(consumer);
    }

    private void buildOreSmelt(Consumer<FinishedRecipe> consumer) {
        List<ItemLike> leadSmeltables = List.of((ItemLike)RailcraftItems.LEAD_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_LEAD_ORE.get(), (ItemLike)RailcraftItems.LEAD_RAW.get());
        RailcraftRecipeProvider.m_246272_(consumer, leadSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LEAD_INGOT.get()), (float)1.0f, (int)200, (String)"lead_ingot");
        RailcraftRecipeProvider.m_245412_(consumer, leadSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LEAD_INGOT.get()), (float)1.0f, (int)100, (String)"lead_ingot");
        List<ItemLike> nickelSmeltables = List.of((ItemLike)RailcraftItems.NICKEL_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_NICKEL_ORE.get(), (ItemLike)RailcraftItems.NICKEL_RAW.get());
        RailcraftRecipeProvider.m_246272_(consumer, nickelSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.NICKEL_INGOT.get()), (float)1.0f, (int)200, (String)"nickel_ingot");
        RailcraftRecipeProvider.m_245412_(consumer, nickelSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.NICKEL_INGOT.get()), (float)1.0f, (int)100, (String)"nickel_ingot");
        List<ItemLike> silverSmeltables = List.of((ItemLike)RailcraftItems.SILVER_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_SILVER_ORE.get(), (ItemLike)RailcraftItems.SILVER_RAW.get());
        RailcraftRecipeProvider.m_246272_(consumer, silverSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SILVER_INGOT.get()), (float)1.0f, (int)200, (String)"silver_ingot");
        RailcraftRecipeProvider.m_245412_(consumer, silverSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SILVER_INGOT.get()), (float)1.0f, (int)100, (String)"silver_ingot");
        List<ItemLike> tinSmeltables = List.of((ItemLike)RailcraftItems.TIN_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_TIN_ORE.get(), (ItemLike)RailcraftItems.TIN_RAW.get());
        RailcraftRecipeProvider.m_246272_(consumer, tinSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TIN_INGOT.get()), (float)1.0f, (int)200, (String)"tin_ingot");
        RailcraftRecipeProvider.m_245412_(consumer, tinSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TIN_INGOT.get()), (float)1.0f, (int)100, (String)"tin_ingot");
        List<ItemLike> zincSmeltables = List.of((ItemLike)RailcraftItems.ZINC_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_ZINC_ORE.get(), (ItemLike)RailcraftItems.ZINC_RAW.get());
        RailcraftRecipeProvider.m_246272_(consumer, zincSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ZINC_INGOT.get()), (float)1.0f, (int)200, (String)"zinc_ingot");
        RailcraftRecipeProvider.m_245412_(consumer, zincSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ZINC_INGOT.get()), (float)1.0f, (int)100, (String)"zinc_ingot");
    }

    private void buildTurbineParts(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TURBINE_DISK.get())).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.TURBINE_BLADE.get()).m_206416_(Character.valueOf('b'), RailcraftTags.Items.STEEL_INGOT).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.TURBINE_BLADE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.TURBINE_BLADE.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TURBINE_ROTOR.get())).m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.TURBINE_DISK.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.TURBINE_DISK.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.TURBINE_DISK.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEAM_TURBINE.get())).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).m_206416_(Character.valueOf('b'), RailcraftTags.Items.STEEL_PLATE).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get()))).m_176498_(consumer);
        RailcraftSpecialRecipeBuilder.special((RecipeSerializer<? extends CraftingRecipe>)((RecipeSerializer)RailcraftRecipeSerializers.ROTOR_REPAIR.get())).m_126359_(consumer, "rotor_repair");
    }

    private void buildSignalBox(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.signalBox(consumer, (Item)RailcraftItems.SIGNAL_CONTROLLER_BOX.get(), (Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.f_42451_);
        RailcraftRecipeProvider.signalBox(consumer, (Item)RailcraftItems.SIGNAL_RECEIVER_BOX.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get(), Items.f_42451_);
        RailcraftRecipeProvider.signalBox(consumer, (Item)RailcraftItems.ANALOG_SIGNAL_CONTROLLER_BOX.get(), (Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.f_42351_);
        RailcraftRecipeProvider.signalBox(consumer, (Item)RailcraftItems.SIGNAL_CAPACITOR_BOX.get(), Items.f_42350_, Items.f_42451_);
        RailcraftRecipeProvider.signalBox(consumer, (Item)RailcraftItems.SIGNAL_SEQUENCER_BOX.get(), Items.f_42351_, Items.f_42451_);
        Item circuit = (Item)RailcraftItems.CONTROLLER_CIRCUIT.get();
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_INTERLOCK_BOX.get())).m_126130_(" d ").m_126130_("aba").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('b'), (ItemLike)circuit).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('d'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)circuit), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)circuit)).m_176498_(consumer);
        circuit = (Item)RailcraftItems.SIGNAL_CIRCUIT.get();
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_BLOCK_RELAY_BOX.get())).m_126130_(" c ").m_126130_("aba").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('b'), (ItemLike)circuit).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42451_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)circuit), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)circuit)).m_176498_(consumer);
    }

    private static void signalBox(Consumer<FinishedRecipe> finishedRecipe, Item result, Item circuit, Item bottomItem) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_("aba").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('b'), (ItemLike)circuit).m_126127_(Character.valueOf('c'), (ItemLike)bottomItem).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)circuit), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)circuit)).m_176498_(finishedRecipe);
    }

    private void buildSignals(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.singleSignal(consumer, (Item)RailcraftItems.BLOCK_SIGNAL.get(), (Item)RailcraftItems.SIGNAL_CIRCUIT.get());
        RailcraftRecipeProvider.singleSignal(consumer, (Item)RailcraftItems.DISTANT_SIGNAL.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        RailcraftRecipeProvider.singleSignal(consumer, (Item)RailcraftItems.TOKEN_SIGNAL.get(), (Item)RailcraftItems.RADIO_CIRCUIT.get());
        RailcraftRecipeProvider.dualSignal(consumer, (Item)RailcraftItems.DUAL_BLOCK_SIGNAL.get(), (Item)RailcraftItems.SIGNAL_CIRCUIT.get());
        RailcraftRecipeProvider.dualSignal(consumer, (Item)RailcraftItems.DUAL_DISTANT_SIGNAL.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        RailcraftRecipeProvider.dualSignal(consumer, (Item)RailcraftItems.DUAL_TOKEN_SIGNAL.get(), (Item)RailcraftItems.RADIO_CIRCUIT.get());
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_LAMP.get())).m_126130_("ab ").m_126130_("ace").m_126130_("adf").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42027_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42540_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42539_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42497_).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42525_).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_42451_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42525_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42525_)).m_176498_(consumer);
    }

    private static void singleSignal(Consumer<FinishedRecipe> finishedRecipe, Item result, Item circuit) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_("abc").m_126130_(" dc").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.SIGNAL_LAMP.get()).m_126127_(Character.valueOf('b'), (ItemLike)circuit).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42532_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)circuit), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)circuit)).m_176498_(finishedRecipe);
    }

    private static void dualSignal(Consumer<FinishedRecipe> finishedRecipe, Item result, Item circuit) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_("abc").m_126130_(" dc").m_126130_("aec").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.SIGNAL_LAMP.get()).m_126127_(Character.valueOf('b'), (ItemLike)circuit).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42532_).m_126127_(Character.valueOf('e'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)circuit), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)circuit)).m_176498_(finishedRecipe);
    }

    private void buildCircuit(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.circuitFromMaterial(consumer, (Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.f_41937_);
        RailcraftRecipeProvider.circuitFromMaterial(consumer, (Item)RailcraftItems.RECEIVER_CIRCUIT.get(), Items.f_41936_);
        RailcraftRecipeProvider.circuitFromMaterial(consumer, (Item)RailcraftItems.SIGNAL_CIRCUIT.get(), Items.f_41874_);
        RailcraftRecipeProvider.circuitFromMaterial(consumer, (Item)RailcraftItems.RADIO_CIRCUIT.get(), Items.f_41934_);
    }

    private static void circuitFromMaterial(Consumer<FinishedRecipe> finishedRecipe, Item itemOut, Item woolItem) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemOut).m_126127_(Character.valueOf('W'), (ItemLike)woolItem).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42350_).m_206416_(Character.valueOf('S'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('L'), Tags.Items.GEMS_LAPIS).m_206416_(Character.valueOf('B'), Tags.Items.SLIMEBALLS).m_126130_(" RW").m_126130_("BGS").m_126130_("WSL").m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42451_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176498_(finishedRecipe);
    }

    private void buildSwitch(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.switchItem(consumer, (Item)RailcraftItems.SWITCH_TRACK_LEVER.get(), Items.f_41966_);
        RailcraftRecipeProvider.switchItem(consumer, (Item)RailcraftItems.SWITCH_TRACK_MOTOR.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SWITCH_TRACK_ROUTER.get())).m_126209_((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get()).m_126209_((ItemLike)Items.f_42351_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get()))).m_176498_(consumer);
    }

    private static void switchItem(Consumer<FinishedRecipe> finishedRecipe, Item result, Item circuit) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_("abc").m_126130_("def").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42497_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42532_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42499_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_41869_).m_126127_(Character.valueOf('e'), (ItemLike)circuit).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_42416_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)circuit), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)circuit)).m_176498_(finishedRecipe);
    }

    private void buildLoaders(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ITEM_LOADER.get())).m_126130_("aaa").m_126130_("aba").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42594_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42155_).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ADVANCED_ITEM_LOADER.get())).m_126130_("aba").m_126130_("bcb").m_126130_("ada").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.ITEM_LOADER.get()).m_126127_(Character.valueOf('d'), (ItemLike)RailcraftItems.STEEL_SHOVEL.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.ITEM_LOADER.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.ITEM_LOADER.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ITEM_UNLOADER.get())).m_126130_("aaa").m_126130_("aba").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42594_).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42155_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ADVANCED_ITEM_UNLOADER.get())).m_126130_("aba").m_126130_("bcb").m_126130_("ada").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.ITEM_UNLOADER.get()).m_126127_(Character.valueOf('d'), (ItemLike)RailcraftItems.STEEL_SHOVEL.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.ITEM_UNLOADER.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.ITEM_UNLOADER.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FLUID_LOADER.get())).m_126130_("aba").m_126130_("a a").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41904_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42155_).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FLUID_UNLOADER.get())).m_126130_("aba").m_126130_("a a").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41904_).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42155_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CART_DISPENSER.get())).m_126209_((ItemLike)Items.f_41855_).m_126209_((ItemLike)Items.f_42449_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_41855_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_41855_)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42449_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRAIN_DISPENSER.get())).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42451_).m_206416_(Character.valueOf('b'), RailcraftTags.Items.CROWBAR).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.CART_DISPENSER.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CART_DISPENSER.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CART_DISPENSER.get()))).m_176498_(consumer);
    }

    private void buildCrowbars(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.crowbar(consumer, (Item)RailcraftItems.IRON_CROWBAR.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        RailcraftRecipeProvider.crowbar(consumer, (Item)RailcraftItems.STEEL_CROWBAR.get(), RailcraftTags.Items.STEEL_INGOT);
        RailcraftRecipeProvider.crowbar(consumer, (Item)RailcraftItems.DIAMOND_CROWBAR.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
    }

    private static void crowbar(Consumer<FinishedRecipe> finishedRecipe, Item itemOut, TagKey<Item> materialTag) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemOut).m_126130_(" ba").m_126130_("bab").m_126130_("ab ").m_206416_(Character.valueOf('a'), materialTag).m_206416_(Character.valueOf('b'), Tags.Items.DYES_RED).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_41964_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_41964_)).m_176498_(finishedRecipe);
    }

    private void buildFirestones(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.REFINED_FIRESTONE.get())).m_126130_("LRL").m_126130_("RSR").m_126130_("LRL").m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42448_).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42153_).m_126127_(Character.valueOf('S'), (ItemLike)RailcraftItems.CUT_FIRESTONE.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CUT_FIRESTONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CUT_FIRESTONE.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "firestone_lava_refinement"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.REFINED_FIRESTONE.get())).m_126130_("LFL").m_126130_("RSR").m_126130_("LRL").m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42448_).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42153_).m_126127_(Character.valueOf('S'), (ItemLike)RailcraftItems.CRACKED_FIRESTONE.get()).m_126127_(Character.valueOf('F'), (ItemLike)RailcraftItems.RAW_FIRESTONE.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CRACKED_FIRESTONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CRACKED_FIRESTONE.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "firestone_cracked_fixing"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CUT_FIRESTONE.get())).m_126130_(" a ").m_126130_("aba").m_126130_(" a ").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42395_).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.RAW_FIRESTONE.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.RAW_FIRESTONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.RAW_FIRESTONE.get()))).m_176498_(consumer);
    }

    private void buildMiscItems(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FEED_STATION.get())).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_206416_(Character.valueOf('a'), ItemTags.f_13168_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42677_).m_206416_(Character.valueOf('c'), RailcraftTags.Items.STEEL_PLATE).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_PLATE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LOGBOOK.get())).m_126130_(" a ").m_126130_("bcb").m_126130_("ddd").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42614_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41937_).m_206416_(Character.valueOf('d'), ItemTags.f_13168_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42614_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42614_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get())).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_206416_(Character.valueOf('a'), RailcraftTags.Items.BRONZE_GEAR).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_41869_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41960_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_41869_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_41869_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POWERED_ROLLING_MACHINE.get())).m_126130_("aba").m_126130_("bcb").m_126130_("ada").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_GEAR).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_41869_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41960_).m_126127_(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42000_, (int)8).m_126130_("a").m_126130_("b").m_126130_("c").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.CREOSOTE_BOTTLE.get()).m_206416_(Character.valueOf('b'), ItemTags.f_13167_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42398_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CREOSOTE_BOTTLE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CREOSOTE_BOTTLE.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "torch_creosote"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.GOLDEN_TICKET.get())).m_126209_((ItemLike)Items.f_42516_).m_206419_(Tags.Items.NUGGETS_GOLD).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42516_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42516_)).m_176498_(consumer);
        RailcraftSpecialRecipeBuilder.special((RecipeSerializer<? extends CraftingRecipe>)((RecipeSerializer)RailcraftRecipeSerializers.TICKET_DUPLICATE.get())).m_126359_(consumer, RailcraftRecipeProvider.m_176632_((ItemLike)((ItemLike)RailcraftItems.TICKET.get())));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ROUTING_TABLE_BOOK.get())).m_126209_((ItemLike)Items.f_42614_).m_206419_(Tags.Items.DYES_BLUE).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42614_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42614_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.OVERALLS.get())).m_126130_("aaa").m_126130_("a a").m_126130_("a a").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41932_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_41932_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_41932_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WHISTLE_TUNER.get())).m_126130_("a a").m_126130_("aaa").m_126130_(" a ").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_NUGGET).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_NUGGET.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_NUGGET)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_LABEL.get())).m_126209_((ItemLike)Items.f_42516_).m_206419_(RailcraftTags.Items.STEEL_NUGGET).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_NUGGET.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.STEEL_NUGGET.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FORCE_TRACK_EMITTER.get())).m_126130_("aba").m_126130_("cdc").m_126130_("aba").m_206416_(Character.valueOf('a'), RailcraftTags.Items.TIN_PLATE).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.ENDER_DUST.get()).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_COIL.get()).m_206416_(Character.valueOf('d'), Tags.Items.STORAGE_BLOCKS_DIAMOND).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.ENDER_DUST.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.ENDER_DUST.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_BLOCK_SURVEYOR.get())).m_126130_(" a ").m_126130_("cbc").m_126130_(" d ").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42522_).m_206416_(Character.valueOf('b'), Tags.Items.GLASS_PANES).m_126127_(Character.valueOf('c'), (ItemLike)Blocks.f_50124_).m_206416_(Character.valueOf('d'), Tags.Items.DUSTS_REDSTONE).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42451_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_TUNER.get())).m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41978_).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).m_126127_(Character.valueOf('c'), (ItemLike)Blocks.f_50124_).m_126130_(" a ").m_126130_("cbc").m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42451_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.GOGGLES.get())).m_126130_("aba").m_126130_("c c").m_126130_("ddd").m_206416_(Character.valueOf('a'), Tags.Items.GLASS_PANES).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).m_206416_(Character.valueOf('c'), RailcraftTags.Items.STEEL_INGOT).m_206416_(Character.valueOf('d'), Tags.Items.LEATHER).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.STEEL_INGOT)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WATER_TANK_SIDING.get()), (int)6).m_126130_("aaa").m_126130_("bcb").m_126130_("aaa").m_206416_(Character.valueOf('a'), ItemTags.f_13168_).m_206416_(Character.valueOf('b'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42518_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42416_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42518_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42518_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42403_, (int)2).m_206419_(RailcraftTags.Items.SALTPETER_DUST).m_206419_(RailcraftTags.Items.SALTPETER_DUST).m_206419_(RailcraftTags.Items.SULFUR_DUST).m_206419_(RailcraftTags.Items.CHARCOAL_DUST).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.SALTPETER_DUST.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.SALTPETER_DUST)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.SULFUR_DUST.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.SULFUR_DUST)).m_176498_(consumer);
    }

    private void buildCartsVariant(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TANK_MINECART.get())).m_126130_("a").m_126130_("b").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STRENGTHENED_GLASS).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42449_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STRENGTHENED_GLASS.variantFor(DyeColor.WHITE).get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.STRENGTHENED_GLASS.variantFor(DyeColor.WHITE).get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TUNNEL_BORE.get())).m_126130_("aba").m_126130_("cbc").m_126130_(" d ").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42449_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41962_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42519_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42449_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEAM_LOCOMOTIVE.get())).m_126130_("aab").m_126130_("aab").m_126130_("cdd").m_206416_(Character.valueOf('a'), RailcraftTags.Items.IRON_TANK_WALL).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42025_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42449_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42449_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ELECTRIC_LOCOMOTIVE.get())).m_126130_("ab ").m_126130_("cdc").m_126130_("efe").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42105_).m_206416_(Character.valueOf('b'), RailcraftTags.Items.STEEL_PLATE).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).m_126124_(Character.valueOf('d'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.NICKEL_IRON_BATTERY.get(), (ItemLike)RailcraftItems.NICKEL_ZINC_BATTERY.get()})).m_206416_(Character.valueOf('e'), RailcraftTags.Items.STEEL_GEAR).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_42449_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42449_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42449_)).m_176498_(consumer);
        RailcraftSpecialRecipeBuilder.special((RecipeSerializer<? extends CraftingRecipe>)((RecipeSerializer)RailcraftRecipeSerializers.LOCOMOTIVE_PAINTING.get())).m_126359_(consumer, "locomotive_color_variant");
        RailcraftSpecialRecipeBuilder.special((RecipeSerializer<? extends CraftingRecipe>)((RecipeSerializer)RailcraftRecipeSerializers.CART_DISASSEMBLY.get())).m_126359_(consumer, "cart_disassembly");
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRACK_LAYER.get())).m_126130_("aba").m_126130_("cdc").m_126130_("efe").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42539_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42105_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42146_).m_206416_(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_41855_).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_42449_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42449_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRACK_RELAYER.get())).m_126130_("aba").m_126130_("cdc").m_126130_("efe").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42539_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42105_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42585_).m_206416_(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42390_).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_42449_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42449_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRACK_REMOVER.get())).m_126130_("aba").m_126130_("cdc").m_126130_("efe").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42539_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42105_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41862_).m_206416_(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).m_206416_(Character.valueOf('e'), RailcraftTags.Items.CROWBAR).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_42449_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42449_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRACK_UNDERCUTTER.get())).m_126130_("aba").m_126130_("cdc").m_126130_("efe").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42539_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42105_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41869_).m_206416_(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42389_).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_42449_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42449_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42449_)).m_176498_(consumer);
    }

    private void buildChargeItems(Consumer<FinishedRecipe> consumer) {
        this.conversion(consumer, (ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get(), (ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get(), 3, "charge_spool_small_from_medium");
        this.conversion(consumer, (ItemLike)RailcraftItems.CHARGE_SPOOL_LARGE.get(), (ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get(), 3, "charge_spool_medium_from_large");
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHARGE_TERMINAL.get())).m_126130_(" b ").m_126130_("aaa").m_206416_(Character.valueOf('a'), RailcraftTags.Items.BRASS_INGOT).m_206416_(Character.valueOf('b'), RailcraftTags.Items.BRASS_PLATE).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.BRASS_INGOT)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHARGE_COIL.get())).m_126130_("aaa").m_126130_("bbb").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()).m_206416_(Character.valueOf('b'), RailcraftTags.Items.IRON_PLATE).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get())).m_126130_(" a ").m_126130_("bcb").m_126130_(" d ").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).m_206416_(Character.valueOf('b'), RailcraftTags.Items.TIN_PLATE).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_COIL.get()).m_126127_(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_TERMINAL.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHARGE_METER.get())).m_126130_("a a").m_126130_("bcb").m_126130_(" d ").m_206416_(Character.valueOf('a'), Tags.Items.INGOTS_COPPER).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42083_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42027_).m_206416_(Character.valueOf('d'), RailcraftTags.Items.BRASS_INGOT).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get()))).m_176498_(consumer);
    }

    private void buildKits(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)2)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), 16, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ADVANCED_RAIL.get()}), (Object)2), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), 2, List.of(new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (Object)2)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), 16, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ADVANCED_RAIL.get()}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41967_}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41967_}), (Object)1), new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42655_}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42584_}), (Object)1), new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42655_}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.m_204132_(RailcraftTags.Items.STEEL_PLATE), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.GATED_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.FENCE_GATES), (Object)1), new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ADVANCED_RAIL.get()}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41967_}), (Object)1), new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41862_}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41967_}), (Object)1), new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41869_}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), 1, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41869_}), (Object)1), new Tuple((Object)Ingredient.m_204132_(RailcraftTags.Items.STEEL_BLOCK), (Object)2), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.SIGNAL_LAMP.get()}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ADVANCED_RAIL.get()}), (Object)2), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)2)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42655_}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.TICKET.get(), (ItemLike)RailcraftItems.GOLDEN_TICKET.get()}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DYES_YELLOW), (Object)1), new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42532_}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(consumer, (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DYES_YELLOW), (Object)1), new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42532_}), (Object)1), new Tuple((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41859_}), (Object)1), new Tuple((Object)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
    }

    private static void kits(Consumer<FinishedRecipe> finishedRecipe, Item result, int count, List<Tuple<Ingredient, Integer>> ingredients) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).m_206419_(ItemTags.f_13168_).m_126209_((ItemLike)RailcraftItems.TRACK_PARTS.get());
        for (Tuple<Ingredient, Integer> ingredient : ingredients) {
            builder = builder.m_126186_((Ingredient)ingredient.m_14418_(), ((Integer)ingredient.m_14419_()).intValue());
        }
        builder.m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.TRACK_PARTS.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.TRACK_PARTS.get()))).m_176498_(finishedRecipe);
    }

    private void buildGears(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.square2x2(consumer, RailcraftTags.Items.BRONZE_INGOT, (Item)RailcraftItems.BUSHING_GEAR.get(), 1, "_bronze");
        RailcraftRecipeProvider.square2x2(consumer, RailcraftTags.Items.BRASS_INGOT, (Item)RailcraftItems.BUSHING_GEAR.get(), 1, "_brass");
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.IRON_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.COPPER_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.GOLD_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.STEEL_GEAR.get(), RailcraftTags.Items.STEEL_INGOT);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.TIN_GEAR.get(), RailcraftTags.Items.TIN_INGOT);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.ZINC_GEAR.get(), RailcraftTags.Items.ZINC_INGOT);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.BRASS_GEAR.get(), RailcraftTags.Items.BRASS_INGOT);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.BRONZE_GEAR.get(), RailcraftTags.Items.BRONZE_INGOT);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.NICKEL_GEAR.get(), RailcraftTags.Items.NICKEL_INGOT);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.INVAR_GEAR.get(), RailcraftTags.Items.INVAR_INGOT);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.SILVER_GEAR.get(), RailcraftTags.Items.SILVER_INGOT);
        RailcraftRecipeProvider.gear(consumer, (Item)RailcraftItems.LEAD_GEAR.get(), RailcraftTags.Items.LEAD_INGOT);
    }

    private static void gear(Consumer<FinishedRecipe> finishedRecipe, Item itemOut, TagKey<Item> materialTag) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemOut).m_126130_(" a ").m_126130_("aba").m_126130_(" a ").m_206416_(Character.valueOf('a'), materialTag).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.BUSHING_GEAR.get()).m_126132_("has_material", (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(materialTag)).m_176498_(finishedRecipe);
    }

    private void buildMultiblockBlocks(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FLUID_FUELED_FIREBOX.get())).m_126130_("aca").m_126130_("bdb").m_126130_("aea").m_206416_(Character.valueOf('a'), RailcraftTags.Items.INVAR_PLATE).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42025_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42613_).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_41962_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.INVAR_PLATE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.INVAR_PLATE.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SOLID_FUELED_FIREBOX.get())).m_126130_("aaa").m_126130_("aba").m_126130_("aca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42691_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42613_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41962_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42613_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42613_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.COKE_OVEN_BRICKS.get()), (int)2).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41830_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42460_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41983_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42460_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42460_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()), (int)4).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42049_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42691_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42542_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42542_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42542_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CRUSHER.get()), (int)4).m_126130_("aba").m_126130_("bcb").m_126130_("ada").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_41869_).m_206416_(Character.valueOf('c'), RailcraftTags.Items.STEEL_BLOCK).m_126127_(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.HIGH_PRESSURE_STEAM_BOILER_TANK.get()), (int)2).m_126130_("a").m_126130_("b").m_126130_("a").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_PLATE).m_206416_(Character.valueOf('b'), RailcraftTags.Items.INVAR_PLATE).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LOW_PRESSURE_STEAM_BOILER_TANK.get()), (int)2).m_126130_("a").m_126130_("b").m_126130_("a").m_206416_(Character.valueOf('a'), RailcraftTags.Items.IRON_PLATE).m_206416_(Character.valueOf('b'), RailcraftTags.Items.INVAR_PLATE).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.IRON_PLATE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.IRON_PLATE.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEAM_OVEN.get()), (int)4).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_206416_(Character.valueOf('a'), RailcraftTags.Items.STEEL_PLATE).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_41962_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get()))).m_176498_(consumer);
    }

    private void buildBlockStorageRecipes(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.STEEL_NUGGET.get(), (ItemLike)RailcraftItems.STEEL_INGOT.get(), "steel_ingot_from_steel_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.TIN_NUGGET.get(), (ItemLike)RailcraftItems.TIN_INGOT.get(), "tin_ingot_from_tin_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.ZINC_NUGGET.get(), (ItemLike)RailcraftItems.ZINC_INGOT.get(), "zinc_ingot_from_zinc_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.BRASS_NUGGET.get(), (ItemLike)RailcraftItems.BRASS_INGOT.get(), "brass_ingot_from_brass_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.BRONZE_NUGGET.get(), (ItemLike)RailcraftItems.BRONZE_INGOT.get(), "bronze_ingot_from_bronze_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.NICKEL_NUGGET.get(), (ItemLike)RailcraftItems.NICKEL_INGOT.get(), "nickel_ingot_from_nickel_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.INVAR_NUGGET.get(), (ItemLike)RailcraftItems.INVAR_INGOT.get(), "invar_ingot_from_invar_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.SILVER_NUGGET.get(), (ItemLike)RailcraftItems.SILVER_INGOT.get(), "silver_ingot_from_silver_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.LEAD_NUGGET.get(), (ItemLike)RailcraftItems.LEAD_INGOT.get(), "lead_ingot_from_lead_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.STEEL_INGOT.get(), (ItemLike)RailcraftItems.STEEL_BLOCK.get(), "steel_block_from_steel_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.TIN_INGOT.get(), (ItemLike)RailcraftItems.TIN_BLOCK.get(), "tin_block_from_tin_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.ZINC_INGOT.get(), (ItemLike)RailcraftItems.ZINC_BLOCK.get(), "zinc_block_from_zinc_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.BRASS_INGOT.get(), (ItemLike)RailcraftItems.BRASS_BLOCK.get(), "brass_block_from_brass_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.BRONZE_INGOT.get(), (ItemLike)RailcraftItems.BRONZE_BLOCK.get(), "bronze_block_from_bronze_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.NICKEL_INGOT.get(), (ItemLike)RailcraftItems.NICKEL_BLOCK.get(), "nickel_block_from_nickel_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.INVAR_INGOT.get(), (ItemLike)RailcraftItems.INVAR_BLOCK.get(), "invar_block_from_invar_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.SILVER_INGOT.get(), (ItemLike)RailcraftItems.SILVER_BLOCK.get(), "silver_block_from_silver_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.LEAD_INGOT.get(), (ItemLike)RailcraftItems.LEAD_BLOCK.get(), "lead_block_from_lead_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(consumer, (ItemLike)RailcraftItems.COAL_COKE.get(), (ItemLike)RailcraftItems.COKE_BLOCK.get(), "coke_block_from_coal_coke");
    }

    private static void nineBlockStorageRecipes(Consumer<FinishedRecipe> consumer, ItemLike unpacked, ItemLike packed, String packingRecipeName) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)unpacked, (int)9).m_126209_(packed).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)packed), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)packed)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)packed).m_126130_("aaa").m_126130_("aaa").m_126130_("aaa").m_126127_(Character.valueOf('a'), unpacked).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)unpacked), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)unpacked)).m_126140_(consumer, new ResourceLocation("railcraft", packingRecipeName));
    }

    private void buildIngotsRecipes(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BRONZE_INGOT.get()), (int)4).m_126130_("ab").m_126130_("bb").m_206416_(Character.valueOf('a'), RailcraftTags.Items.TIN_INGOT).m_206416_(Character.valueOf('b'), Tags.Items.INGOTS_COPPER).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.TIN_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.TIN_INGOT)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_151052_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_COPPER)).m_126140_(consumer, new ResourceLocation("railcraft", "bronze_ingot_crafted_with_ingots"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get()), (int)4).m_126130_("ab").m_126130_("bb").m_206416_(Character.valueOf('a'), RailcraftTags.Items.ZINC_INGOT).m_206416_(Character.valueOf('b'), Tags.Items.INGOTS_COPPER).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.ZINC_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.ZINC_INGOT)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_151052_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_COPPER)).m_126140_(consumer, new ResourceLocation("railcraft", "brass_ingot_crafted_with_ingots"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.INVAR_INGOT.get()), (int)3).m_126130_("ab").m_126130_("b ").m_206416_(Character.valueOf('a'), RailcraftTags.Items.NICKEL_INGOT).m_206416_(Character.valueOf('b'), Tags.Items.INGOTS_IRON).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.NICKEL_INGOT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(RailcraftTags.Items.NICKEL_INGOT)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42416_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(consumer, new ResourceLocation("railcraft", "invar_ingot_crafted_with_ingots"));
    }

    private void buildStrengthenedGlass(Consumer<FinishedRecipe> consumer) {
        Map<String, TagKey> ingredients = Map.of("tin", RailcraftTags.Items.TIN_INGOT, "nickel", RailcraftTags.Items.NICKEL_INGOT, "invar", RailcraftTags.Items.INVAR_INGOT, "brass", RailcraftTags.Items.BRASS_INGOT, "iron", Tags.Items.INGOTS_IRON);
        VariantRegistrar<DyeColor, BlockItem> colorItems = RailcraftItems.STRENGTHENED_GLASS;
        TagKey<Item> tagItem = RailcraftTags.Items.STRENGTHENED_GLASS;
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.m_176493_((ItemLike)result).m_135815_();
        for (Map.Entry<String, TagKey> ingredient : ingredients.entrySet()) {
            String recipeName = name.substring(name.indexOf(95) + 1) + "_" + ingredient.getKey();
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)6).m_126130_("aba").m_126130_("aca").m_126130_("ada").m_206416_(Character.valueOf('a'), Tags.Items.GLASS).m_206416_(Character.valueOf('b'), ingredient.getValue()).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.SALTPETER_DUST.get()).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42447_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.SALTPETER_DUST.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.SALTPETER_DUST.get()))).m_126140_(consumer, new ResourceLocation("railcraft", recipeName));
        }
        RailcraftRecipeProvider.coloredBlockVariant(consumer, colorItems, tagItem);
    }

    private void buildTie(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get()), (int)3).m_126130_(" a ").m_126130_("bbb").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.CREOSOTE_BUCKET.get()).m_206416_(Character.valueOf('b'), ItemTags.f_13175_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CREOSOTE_BUCKET.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CREOSOTE_BUCKET.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())).m_126130_(" a ").m_126130_("bbb").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.CREOSOTE_BOTTLE.get()).m_206416_(Character.valueOf('b'), ItemTags.f_13175_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.CREOSOTE_BOTTLE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.CREOSOTE_BOTTLE.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "wooden_tie_bottle"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STONE_TIE.get())).m_126130_(" a ").m_126130_("bcb").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42447_).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.BAG_OF_CEMENT.get()).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.REBAR.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.BAG_OF_CEMENT.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.BAG_OF_CEMENT.get()))).m_176498_(consumer);
    }

    private void buildCement(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BAG_OF_CEMENT.get()), (int)2).m_126130_("ab").m_126130_("ba").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41832_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42692_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)Items.f_42692_), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BAG_OF_CEMENT.get()), (int)2).m_126130_("ab").m_126130_("ca").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41832_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42692_).m_126127_(Character.valueOf('c'), (ItemLike)RailcraftItems.SLAG.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.SLAG.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.SLAG.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "bag_of_cement_slag"));
    }

    private static void tankWall(Consumer<FinishedRecipe> consumer, TagKey<Item> ingredientTag, VariantRegistrar<DyeColor, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.m_176493_((ItemLike)result).m_135815_();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)8).m_126130_("aa").m_126130_("aa").m_206416_(Character.valueOf('a'), ingredientTag).m_126132_(ingredient, (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(ingredientTag)).m_176500_(consumer, "railcraft:" + name.substring(name.indexOf(95) + 1));
        RailcraftRecipeProvider.coloredBlockVariant(consumer, colorItems, tagItem);
    }

    private static void tankValve(Consumer<FinishedRecipe> consumer, TagKey<Item> ingredientTag, VariantRegistrar<DyeColor, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.m_176493_((ItemLike)result).m_135815_();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)8).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42025_).m_206416_(Character.valueOf('b'), ingredientTag).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41966_).m_126132_(ingredient, (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(ingredientTag)).m_126140_(consumer, new ResourceLocation("railcraft", name.substring(name.indexOf(95) + 1)));
        RailcraftRecipeProvider.coloredBlockVariant(consumer, colorItems, tagItem);
    }

    private static void tankGauge(Consumer<FinishedRecipe> consumer, TagKey<Item> ingredientTag, VariantRegistrar<DyeColor, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.m_176493_((ItemLike)result).m_135815_();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)8).m_126130_("aba").m_126130_("bab").m_126130_("aba").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42027_).m_206416_(Character.valueOf('b'), ingredientTag).m_126132_(ingredient, (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(ingredientTag)).m_126140_(consumer, new ResourceLocation("railcraft", name.substring(name.indexOf(95) + 1)));
        RailcraftRecipeProvider.coloredBlockVariant(consumer, colorItems, tagItem);
    }

    private void buildTankBlocks(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.tankWall(consumer, RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_WALL, RailcraftTags.Items.IRON_TANK_WALL);
        RailcraftRecipeProvider.tankWall(consumer, RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_WALL, RailcraftTags.Items.STEEL_TANK_WALL);
        RailcraftRecipeProvider.tankValve(consumer, RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_VALVE, RailcraftTags.Items.IRON_TANK_VALVE);
        RailcraftRecipeProvider.tankValve(consumer, RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_VALVE, RailcraftTags.Items.STEEL_TANK_VALVE);
        RailcraftRecipeProvider.tankGauge(consumer, RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_GAUGE, RailcraftTags.Items.IRON_TANK_GAUGE);
        RailcraftRecipeProvider.tankGauge(consumer, RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_GAUGE, RailcraftTags.Items.STEEL_TANK_GAUGE);
    }

    private void buildPost(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.coloredBlockVariant(consumer, RailcraftItems.POST, RailcraftTags.Items.POST, DyeColor.BLACK);
    }

    private void buildQuarriedStone(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.square2x2(consumer, (Item)RailcraftItems.QUARRIED_STONE.get(), (Item)RailcraftItems.POLISHED_QUARRIED_STONE.get(), 4, "_from_quarried_stone");
        RailcraftRecipeProvider.square2x2(consumer, (Item)RailcraftItems.QUARRIED_COBBLESTONE.get(), (Item)RailcraftItems.POLISHED_QUARRIED_STONE.get(), 4, "_from_quarried_cobblestone");
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RailcraftItems.QUARRIED_STONE.get())}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POLISHED_QUARRIED_STONE.get())).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_STONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_STONE.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "polished_quarried_stone_from_quarried_stone_in_stonecutter"));
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RailcraftItems.QUARRIED_COBBLESTONE.get())}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POLISHED_QUARRIED_STONE.get())).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_COBBLESTONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_COBBLESTONE.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "polished_quarried_stone_from_quarried_cobblestone_in_stonecutter"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHISELED_QUARRIED_STONE.get()), (int)8).m_126130_("aaa").m_126130_("a a").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.POLISHED_QUARRIED_STONE.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.POLISHED_QUARRIED_STONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.POLISHED_QUARRIED_STONE.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ETCHED_QUARRIED_STONE.get()), (int)8).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.POLISHED_QUARRIED_STONE.get()).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42403_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.POLISHED_QUARRIED_STONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.POLISHED_QUARRIED_STONE.get()))).m_176498_(consumer);
        RailcraftRecipeProvider.square2x2(consumer, (Item)RailcraftItems.POLISHED_QUARRIED_STONE.get(), (Item)RailcraftItems.QUARRIED_BRICKS.get(), 4, "");
        RailcraftRecipeProvider.square2x2(consumer, (Item)RailcraftItems.QUARRIED_BRICKS.get(), (Item)RailcraftItems.QUARRIED_PAVER.get(), 4, "");
        RailcraftRecipeProvider.m_176710_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_BRICK_STAIRS.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.QUARRIED_BRICKS.get()})).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_BRICKS.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_BRICKS.get()))).m_176498_(consumer);
        RailcraftRecipeProvider.m_176710_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_PAVER_STAIRS.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.QUARRIED_PAVER.get()})).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_PAVER.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.QUARRIED_PAVER.get()))).m_176498_(consumer);
        RailcraftRecipeProvider.m_246658_(consumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.QUARRIED_BRICK_SLAB.get()), (ItemLike)((ItemLike)RailcraftItems.QUARRIED_BRICKS.get()));
        RailcraftRecipeProvider.m_246658_(consumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.QUARRIED_PAVER_SLAB.get()), (ItemLike)((ItemLike)RailcraftItems.QUARRIED_PAVER.get()));
    }

    private void buildAbyssalStone(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.square2x2(consumer, (Item)RailcraftItems.ABYSSAL_STONE.get(), (Item)RailcraftItems.POLISHED_ABYSSAL_STONE.get(), 4, "_from_abyssal_stone");
        RailcraftRecipeProvider.square2x2(consumer, (Item)RailcraftItems.ABYSSAL_COBBLESTONE.get(), (Item)RailcraftItems.POLISHED_ABYSSAL_STONE.get(), 4, "_from_abyssal_cobblestone");
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RailcraftItems.ABYSSAL_STONE.get())}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POLISHED_ABYSSAL_STONE.get())).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_STONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_STONE.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "polished_abyssal_stone_from_abyssal_stone_in_stonecutter"));
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RailcraftItems.ABYSSAL_COBBLESTONE.get())}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POLISHED_ABYSSAL_STONE.get())).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_COBBLESTONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_COBBLESTONE.get()))).m_126140_(consumer, new ResourceLocation("railcraft", "polished_abyssal_stone_from_abyssal_cobblestone_in_stonecutter"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHISELED_ABYSSAL_STONE.get()), (int)8).m_126130_("aaa").m_126130_("a a").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.POLISHED_ABYSSAL_STONE.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.POLISHED_ABYSSAL_STONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.POLISHED_ABYSSAL_STONE.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ETCHED_ABYSSAL_STONE.get()), (int)8).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.POLISHED_ABYSSAL_STONE.get()).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42403_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.POLISHED_ABYSSAL_STONE.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.POLISHED_ABYSSAL_STONE.get()))).m_176498_(consumer);
        RailcraftRecipeProvider.square2x2(consumer, (Item)RailcraftItems.POLISHED_ABYSSAL_STONE.get(), (Item)RailcraftItems.ABYSSAL_BRICKS.get(), 4, "");
        RailcraftRecipeProvider.square2x2(consumer, (Item)RailcraftItems.ABYSSAL_BRICKS.get(), (Item)RailcraftItems.ABYSSAL_PAVER.get(), 4, "");
        RailcraftRecipeProvider.m_176710_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_BRICK_STAIRS.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ABYSSAL_BRICKS.get()})).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_BRICKS.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_BRICKS.get()))).m_176498_(consumer);
        RailcraftRecipeProvider.m_176710_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_PAVER_STAIRS.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ABYSSAL_PAVER.get()})).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_PAVER.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.ABYSSAL_PAVER.get()))).m_176498_(consumer);
        RailcraftRecipeProvider.m_246658_(consumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ABYSSAL_BRICK_SLAB.get()), (ItemLike)((ItemLike)RailcraftItems.ABYSSAL_BRICKS.get()));
        RailcraftRecipeProvider.m_246658_(consumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ABYSSAL_PAVER_SLAB.get()), (ItemLike)((ItemLike)RailcraftItems.ABYSSAL_PAVER.get()));
    }

    private void buildBattery(Consumer<FinishedRecipe> consumer) {
        RailcraftRecipeProvider.battery(consumer, (Item)RailcraftItems.NICKEL_ZINC_BATTERY.get(), (Item)RailcraftItems.NICKEL_ELECTRODE.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get());
        RailcraftRecipeProvider.battery(consumer, (Item)RailcraftItems.NICKEL_IRON_BATTERY.get(), (Item)RailcraftItems.NICKEL_ELECTRODE.get(), (Item)RailcraftItems.IRON_ELECTRODE.get());
        RailcraftRecipeProvider.battery(consumer, (Item)RailcraftItems.ZINC_SILVER_BATTERY.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get(), (Item)RailcraftItems.SILVER_ELECTRODE.get());
        RailcraftRecipeProvider.battery(consumer, (Item)RailcraftItems.ZINC_CARBON_BATTERY.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get(), (Item)RailcraftItems.CARBON_ELECTRODE.get());
    }

    private static void battery(Consumer<FinishedRecipe> consumer, Item result, Item left, Item right) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126130_("aba").m_126130_("cde").m_126130_("cfe").m_126127_(Character.valueOf('a'), (ItemLike)RailcraftItems.CHARGE_TERMINAL.get()).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get()).m_126127_(Character.valueOf('c'), (ItemLike)left).m_206416_(Character.valueOf('d'), RailcraftTags.Items.SALTPETER_DUST).m_126127_(Character.valueOf('e'), (ItemLike)right).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_42447_).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)left), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)left)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)right), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)right)).m_176498_(consumer);
    }

    private void buildFrame(Consumer<FinishedRecipe> consumer) {
        this.frame(6, RailcraftTags.Items.IRON_PLATE, "_iron_plate", consumer);
        this.frame(6, RailcraftTags.Items.BRONZE_PLATE, "_bronze_plate", consumer);
        this.frame(6, RailcraftTags.Items.BRASS_PLATE, "_brass_plate", consumer);
        this.frame(10, RailcraftTags.Items.STEEL_PLATE, "_steel_plate", consumer);
    }

    private void frame(int count, TagKey<Item> tag, String suffix, Consumer<FinishedRecipe> consumer) {
        String name = RecipeBuilder.m_176493_((ItemLike)((ItemLike)RailcraftItems.FRAME_BLOCK.get())).m_135815_();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FRAME_BLOCK.get()), (int)count).m_126130_("aaa").m_126130_("b b").m_126130_("bbb").m_206416_(Character.valueOf('a'), tag).m_126127_(Character.valueOf('b'), (ItemLike)RailcraftItems.REBAR.get()).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)((ItemLike)RailcraftItems.REBAR.get())), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)((ItemLike)RailcraftItems.REBAR.get()))).m_126140_(consumer, new ResourceLocation("railcraft", name + suffix));
    }

    private static void square2x2(Consumer<FinishedRecipe> finishedRecipe, TagKey<Item> ingredient, Item result, int quantity, String suffix) {
        String name = RecipeBuilder.m_176493_((ItemLike)result).m_135815_();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)quantity).m_126130_("aa").m_126130_("aa").m_206416_(Character.valueOf('a'), ingredient).m_126132_("has_material", (CriterionTriggerInstance)RailcraftRecipeProvider.m_206406_(ingredient)).m_126140_(finishedRecipe, new ResourceLocation("railcraft", name + suffix));
    }

    private static void square2x2(Consumer<FinishedRecipe> finishedRecipe, Item ingredient, Item result, int quantity, String suffix) {
        String name = RecipeBuilder.m_176493_((ItemLike)result).m_135815_();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)quantity).m_126130_("aa").m_126130_("aa").m_126127_(Character.valueOf('a'), (ItemLike)ingredient).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)ingredient)).m_126140_(finishedRecipe, new ResourceLocation("railcraft", name + suffix));
    }

    private static void coloredBlockVariant(Consumer<FinishedRecipe> consumer, VariantRegistrar<DyeColor, BlockItem> colorItems, TagKey<Item> tagItem) {
        RailcraftRecipeProvider.coloredBlockVariant(consumer, colorItems, tagItem, DyeColor.WHITE);
    }

    private static void coloredBlockVariant(Consumer<FinishedRecipe> consumer, VariantRegistrar<DyeColor, BlockItem> colorItems, TagKey<Item> tagItem, DyeColor baseColor) {
        BlockItem base = (BlockItem)colorItems.variantFor(baseColor).get();
        for (DyeColor dyeColor : DyeColor.values()) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)colorItems.variantFor(dyeColor).get()), (int)8).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_206416_(Character.valueOf('a'), tagItem).m_126127_(Character.valueOf('b'), (ItemLike)DyeItem.m_41082_((DyeColor)dyeColor)).m_126132_(RailcraftRecipeProvider.m_176602_((ItemLike)base), (CriterionTriggerInstance)RailcraftRecipeProvider.m_125977_((ItemLike)base)).m_176498_(consumer);
        }
    }
}

