/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.models;

import java.util.function.Function;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.AbstractStrengthenedGlassBlock;
import mods.railcraft.world.level.block.CrusherMultiblockBlock;
import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.FurnaceMultiblockBlock;
import mods.railcraft.world.level.block.LogBookBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.SteamOvenBlock;
import mods.railcraft.world.level.block.SteamTurbineBlock;
import mods.railcraft.world.level.block.charge.BatteryBlock;
import mods.railcraft.world.level.block.charge.DisposableBatteryBlock;
import mods.railcraft.world.level.block.charge.EmptyBatteryBlock;
import mods.railcraft.world.level.block.charge.FrameBlock;
import mods.railcraft.world.level.block.entity.track.CouplerTrackBlockEntity;
import mods.railcraft.world.level.block.manipulator.AdvancedItemLoaderBlock;
import mods.railcraft.world.level.block.manipulator.FluidManipulatorBlock;
import mods.railcraft.world.level.block.manipulator.ManipulatorBlock;
import mods.railcraft.world.level.block.post.Column;
import mods.railcraft.world.level.block.post.Connection;
import mods.railcraft.world.level.block.post.PostBlock;
import mods.railcraft.world.level.block.signal.DualSignalBlock;
import mods.railcraft.world.level.block.signal.SignalBoxBlock;
import mods.railcraft.world.level.block.signal.SingleSignalBlock;
import mods.railcraft.world.level.block.steamboiler.FireboxBlock;
import mods.railcraft.world.level.block.steamboiler.SteamBoilerTankBlock;
import mods.railcraft.world.level.block.tank.BaseTankBlock;
import mods.railcraft.world.level.block.tank.IronTankGaugeBlock;
import mods.railcraft.world.level.block.tank.TankValveBlock;
import mods.railcraft.world.level.block.track.AbandonedTrackBlock;
import mods.railcraft.world.level.block.track.ElevatorTrackBlock;
import mods.railcraft.world.level.block.track.ForceTrackBlock;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.outfitted.ActivatorTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.BoosterTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.BufferStopTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.ControlTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.CouplerTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.DetectorTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.DisembarkingTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.DumpingTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.EmbarkingTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.GatedTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.JunctionTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.LauncherTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.LockingMode;
import mods.railcraft.world.level.block.track.outfitted.LockingTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.LocomotiveTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.OneWayTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.OutfittedTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.ReversibleOutfittedTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.RoutingTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.ThrottleTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.TransitionTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.TurnoutTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.WhistleTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.WyeTrackBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class RailcraftBlockModelProvider
extends BlockStateProvider {
    private static final String CUTOUT = "cutout";
    private static final ResourceLocation FLAT_TEMPLATE = new ResourceLocation("rail_flat");
    private static final ResourceLocation CORNER_TEMPLATE = new ResourceLocation("rail_curved");
    private static final ResourceLocation RAISED_NE_TEMPLATE = new ResourceLocation("template_rail_raised_ne");
    private static final ResourceLocation RAISED_SW_TEMPLATE = new ResourceLocation("template_rail_raised_sw");
    private StraightTrackModelSet activatorTrackModels;
    private StraightTrackModelSet activeActivatorTrackModels;
    private StraightTrackModelSet boosterTrackModels;
    private StraightTrackModelSet activeBoosterTrackModels;
    private StraightTrackModelSet embarkingTrack;
    private StraightTrackModelSet activeEmbarkingTrack;
    private StraightTrackModelSet dumpingTrack;
    private StraightTrackModelSet activeDumpingTrack;
    private StraightTrackModelSet launcherTrackModels;
    private StraightTrackModelSet activeLauncherTrackModels;
    private StraightTrackModelSet oneWayTrackModels;
    private StraightTrackModelSet activeOneWayTrackModels;
    private StraightTrackModelSet routingTrackModels;
    private StraightTrackModelSet activeRoutingTrackModels;
    private StraightTrackModelSet whistleTrackModels;
    private StraightTrackModelSet activeWhistleTrackModels;
    private StraightTrackModelSet transitionTrackModels;
    private StraightTrackModelSet activeTransitionTrackModels;
    private StraightTrackModelSet detectorTrackModels;
    private StraightTrackModelSet activeDetectorTrackModels;
    private StraightTrackModelSet travelDetectorTrackModels;
    private StraightTrackModelSet activeTravelDetectorTrackModels;
    private StraightTrackModelSet locomotiveTrackShutdownModel;
    private StraightTrackModelSet locomotiveTrackIdleModel;
    private StraightTrackModelSet locomotiveTrackRunningModel;
    private StraightTrackModelSet activeLocomotiveTrackShutdownModel;
    private StraightTrackModelSet activeLocomotiveTrackIdleModel;
    private StraightTrackModelSet activeLocomotiveTrackRunningModel;
    private StraightTrackModelSet controlTrackModels;
    private StraightTrackModelSet couplerTrackCoupler;
    private StraightTrackModelSet activeCouplerTrackCoupler;
    private StraightTrackModelSet couplerTrackDecoupler;
    private StraightTrackModelSet activeCouplerTrackDecoupler;
    private StraightTrackModelSet couplerTrackAutoCoupler;
    private StraightTrackModelSet activeCouplerTrackAutoCoupler;
    private StraightTrackModelSet disembarkingTrackLeft;
    private StraightTrackModelSet activeDisembarkingTrackLeft;
    private StraightTrackModelSet disembarkingTrackRight;
    private StraightTrackModelSet activeDisembarkingTrackRight;

    public RailcraftBlockModelProvider(PackOutput packOutput, ExistingFileHelper fileHelper) {
        super(packOutput, "railcraft", fileHelper);
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private String name(Block block, String suffix) {
        return this.name(block) + suffix;
    }

    public void simpleBlock(Block block) {
        super.simpleBlock(block);
        this.simpleBlockItem(block, this.cubeAll(block));
    }

    public void simpleStairsBlock(StairBlock stairBlock, Block textureBlock) {
        ResourceLocation texture = TextureMapping.m_125740_((Block)textureBlock);
        this.stairsBlock(stairBlock, texture);
        this.itemModels().stairs(this.name((Block)stairBlock), texture, texture, texture);
    }

    public void simpleSlabBlock(SlabBlock slabBlock, Block textureBlock) {
        ResourceLocation texture = TextureMapping.m_125740_((Block)textureBlock);
        this.slabBlock(slabBlock, texture, texture);
        this.itemModels().slab(this.name((Block)slabBlock), texture, texture, texture);
    }

    public void horizontalBlockPropertyIgnore(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build(), ignored);
    }

    private BlockModelBuilder cube(String name, ResourceLocation parent, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west, ResourceLocation particle) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture("down", down)).texture("up", up)).texture("north", north)).texture("south", south)).texture("east", east)).texture("west", west)).texture("particle", particle);
    }

    private BlockModelBuilder sideEnd(String name, ResourceLocation parent, ResourceLocation side, ResourceLocation end) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture("side", side)).texture("end", end);
    }

    private void basicItem(Block block) {
        this.basicItem(block, "");
    }

    private void basicItem(Block block, String suffix) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.name(block), "item/generated")).texture("layer0", this.modLoc("block/" + this.name(block) + suffix));
    }

    protected void registerStatesAndModels() {
        for (DyeColor dyeColor : DyeColor.values()) {
            this.createStrengthenedGlass((Block)RailcraftBlocks.STRENGTHENED_GLASS.variantFor(dyeColor).get());
            this.createStrengthenedGlass((Block)RailcraftBlocks.IRON_TANK_GAUGE.variantFor(dyeColor).get());
            this.createStrengthenedGlass((Block)RailcraftBlocks.STEEL_TANK_GAUGE.variantFor(dyeColor).get());
            this.createTankValve((TankValveBlock)((Object)RailcraftBlocks.IRON_TANK_VALVE.variantFor(dyeColor).get()), (BaseTankBlock)((Object)RailcraftBlocks.IRON_TANK_WALL.variantFor(dyeColor).get()));
            this.createTankValve((TankValveBlock)((Object)RailcraftBlocks.STEEL_TANK_VALVE.variantFor(dyeColor).get()), (BaseTankBlock)((Object)RailcraftBlocks.STEEL_TANK_WALL.variantFor(dyeColor).get()));
            this.createCubeColumnBlock((Block)RailcraftBlocks.IRON_TANK_WALL.variantFor(dyeColor).get());
            this.createCubeColumnBlock((Block)RailcraftBlocks.STEEL_TANK_WALL.variantFor(dyeColor).get());
            this.createPost((PostBlock)((Object)RailcraftBlocks.POST.variantFor(dyeColor).get()));
        }
        this.simpleBlock((Block)RailcraftBlocks.STEEL_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.BRASS_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.BRONZE_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.INVAR_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.LEAD_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.NICKEL_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.SILVER_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.TIN_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.ZINC_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.COKE_BLOCK.get());
        this.simpleBlock((Block)RailcraftBlocks.CRUSHED_OBSIDIAN.get());
        this.simpleBlock((Block)RailcraftBlocks.LEAD_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.NICKEL_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.SILVER_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.SULFUR_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.TIN_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.ZINC_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.DEEPSLATE_LEAD_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.DEEPSLATE_NICKEL_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.DEEPSLATE_SILVER_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.DEEPSLATE_SULFUR_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.DEEPSLATE_TIN_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.DEEPSLATE_ZINC_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.SALTPETER_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.FIRESTONE_ORE.get());
        this.simpleBlock((Block)RailcraftBlocks.QUARRIED_STONE.get());
        this.simpleBlock((Block)RailcraftBlocks.QUARRIED_COBBLESTONE.get());
        this.simpleBlock((Block)RailcraftBlocks.POLISHED_QUARRIED_STONE.get());
        this.simpleBlock((Block)RailcraftBlocks.CHISELED_QUARRIED_STONE.get());
        this.simpleBlock((Block)RailcraftBlocks.ETCHED_QUARRIED_STONE.get());
        this.simpleBlock((Block)RailcraftBlocks.QUARRIED_BRICKS.get());
        this.simpleBlock((Block)RailcraftBlocks.QUARRIED_PAVER.get());
        this.simpleStairsBlock((StairBlock)RailcraftBlocks.QUARRIED_BRICK_STAIRS.get(), (Block)RailcraftBlocks.QUARRIED_BRICKS.get());
        this.simpleStairsBlock((StairBlock)RailcraftBlocks.QUARRIED_PAVER_STAIRS.get(), (Block)RailcraftBlocks.QUARRIED_PAVER.get());
        this.simpleSlabBlock((SlabBlock)RailcraftBlocks.QUARRIED_BRICK_SLAB.get(), (Block)RailcraftBlocks.QUARRIED_BRICKS.get());
        this.simpleSlabBlock((SlabBlock)RailcraftBlocks.QUARRIED_PAVER_SLAB.get(), (Block)RailcraftBlocks.QUARRIED_PAVER.get());
        this.simpleBlock((Block)RailcraftBlocks.ABYSSAL_STONE.get());
        this.simpleBlock((Block)RailcraftBlocks.ABYSSAL_COBBLESTONE.get());
        this.simpleBlock((Block)RailcraftBlocks.POLISHED_ABYSSAL_STONE.get());
        this.simpleBlock((Block)RailcraftBlocks.CHISELED_ABYSSAL_STONE.get());
        this.simpleBlock((Block)RailcraftBlocks.ETCHED_ABYSSAL_STONE.get());
        this.simpleBlock((Block)RailcraftBlocks.ABYSSAL_BRICKS.get());
        this.simpleBlock((Block)RailcraftBlocks.ABYSSAL_PAVER.get());
        this.simpleStairsBlock((StairBlock)RailcraftBlocks.ABYSSAL_BRICK_STAIRS.get(), (Block)RailcraftBlocks.ABYSSAL_BRICKS.get());
        this.simpleStairsBlock((StairBlock)RailcraftBlocks.ABYSSAL_PAVER_STAIRS.get(), (Block)RailcraftBlocks.ABYSSAL_PAVER.get());
        this.simpleSlabBlock((SlabBlock)RailcraftBlocks.ABYSSAL_BRICK_SLAB.get(), (Block)RailcraftBlocks.ABYSSAL_BRICKS.get());
        this.simpleSlabBlock((SlabBlock)RailcraftBlocks.ABYSSAL_PAVER_SLAB.get(), (Block)RailcraftBlocks.ABYSSAL_PAVER.get());
        this.fluidBlock((LiquidBlock)RailcraftBlocks.CREOSOTE.get());
        this.createSteelAnvil((AnvilBlock)RailcraftBlocks.STEEL_ANVIL.get());
        this.createSteelAnvil((AnvilBlock)RailcraftBlocks.CHIPPED_STEEL_ANVIL.get());
        this.createSteelAnvil((AnvilBlock)RailcraftBlocks.DAMAGED_STEEL_ANVIL.get());
        this.createCubeColumnBlock((Block)RailcraftBlocks.FEED_STATION.get());
        this.createCubeColumnBlock((Block)RailcraftBlocks.WATER_TANK_SIDING.get());
        this.createCubeTopBottomBlock((Block)RailcraftBlocks.MANUAL_ROLLING_MACHINE.get());
        this.createCubeTopBottomBlock((Block)RailcraftBlocks.POWERED_ROLLING_MACHINE.get());
        this.createSteamOven((SteamOvenBlock)((Object)RailcraftBlocks.STEAM_OVEN.get()));
        this.createFrameBlock((FrameBlock)RailcraftBlocks.FRAME.get());
        this.createLogBookBlock((LogBookBlock)RailcraftBlocks.LOGBOOK.get());
        this.createFluidManipulator((FluidManipulatorBlock)((Object)RailcraftBlocks.FLUID_LOADER.get()));
        this.createFluidManipulator((FluidManipulatorBlock)((Object)RailcraftBlocks.FLUID_UNLOADER.get()));
        this.createManipulator((ManipulatorBlock)((Object)RailcraftBlocks.ITEM_LOADER.get()));
        this.createManipulator((ManipulatorBlock)((Object)RailcraftBlocks.ITEM_UNLOADER.get()));
        this.createDirectionalManipulator((ManipulatorBlock)((Object)RailcraftBlocks.ADVANCED_ITEM_LOADER.get()));
        this.createDirectionalManipulator((ManipulatorBlock)((Object)RailcraftBlocks.ADVANCED_ITEM_UNLOADER.get()));
        this.createDirectionalManipulator((ManipulatorBlock)((Object)RailcraftBlocks.CART_DISPENSER.get()));
        this.createDirectionalManipulator((ManipulatorBlock)((Object)RailcraftBlocks.TRAIN_DISPENSER.get()));
        this.createFirebox((FireboxBlock)((Object)RailcraftBlocks.SOLID_FUELED_FIREBOX.get()));
        this.createFirebox((FireboxBlock)((Object)RailcraftBlocks.FLUID_FUELED_FIREBOX.get()));
        this.createFurnaceMultiblockBricks((FurnaceMultiblockBlock)((Object)RailcraftBlocks.COKE_OVEN_BRICKS.get()));
        this.createFurnaceMultiblockBricks((FurnaceMultiblockBlock)((Object)RailcraftBlocks.BLAST_FURNACE_BRICKS.get()));
        this.createCrusherMultiblockBricks((CrusherMultiblockBlock)RailcraftBlocks.CRUSHER.get());
        this.createSteamBoilerTank((SteamBoilerTankBlock)((Object)RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK.get()));
        this.createSteamBoilerTank((SteamBoilerTankBlock)((Object)RailcraftBlocks.HIGH_PRESSURE_STEAM_BOILER_TANK.get()));
        this.createSteamTurbine((Block)RailcraftBlocks.STEAM_TURBINE.get());
        this.createElevatorTrack((ElevatorTrackBlock)((Object)RailcraftBlocks.ELEVATOR_TRACK.get()));
        this.createForceTrack((ForceTrackBlock)RailcraftBlocks.FORCE_TRACK.get());
        this.createForceTrackEmitter((ForceTrackEmitterBlock)RailcraftBlocks.FORCE_TRACK_EMITTER.get());
        this.createRechargeableBattery((BatteryBlock)RailcraftBlocks.NICKEL_ZINC_BATTERY.get());
        this.createRechargeableBattery((BatteryBlock)RailcraftBlocks.NICKEL_IRON_BATTERY.get());
        this.createDisposableBattery((DisposableBatteryBlock)RailcraftBlocks.ZINC_CARBON_BATTERY.get(), (EmptyBatteryBlock)RailcraftBlocks.ZINC_CARBON_BATTERY_EMPTY.get());
        this.createDisposableBattery((DisposableBatteryBlock)RailcraftBlocks.ZINC_SILVER_BATTERY.get(), (EmptyBatteryBlock)RailcraftBlocks.ZINC_SILVER_BATTERY_EMPTY.get());
        this.createSignalBoxBlock((SignalBoxBlock)((Object)RailcraftBlocks.ANALOG_SIGNAL_CONTROLLER_BOX.get()));
        this.createSignalBoxBlock((SignalBoxBlock)((Object)RailcraftBlocks.SIGNAL_INTERLOCK_BOX.get()));
        this.createSignalBoxBlock((SignalBoxBlock)((Object)RailcraftBlocks.SIGNAL_BLOCK_RELAY_BOX.get()));
        this.createSignalBoxBlock((SignalBoxBlock)((Object)RailcraftBlocks.SIGNAL_CAPACITOR_BOX.get()));
        this.createSignalBoxBlock((SignalBoxBlock)((Object)RailcraftBlocks.SIGNAL_CONTROLLER_BOX.get()));
        this.createSignalBoxBlock((SignalBoxBlock)((Object)RailcraftBlocks.SIGNAL_RECEIVER_BOX.get()));
        this.createSignalBoxBlock((SignalBoxBlock)((Object)RailcraftBlocks.SIGNAL_SEQUENCER_BOX.get()));
        this.createSingleSignalBlock((SingleSignalBlock)((Object)RailcraftBlocks.BLOCK_SIGNAL.get()));
        this.createSingleSignalBlock((SingleSignalBlock)((Object)RailcraftBlocks.DISTANT_SIGNAL.get()));
        this.createSingleSignalBlock((SingleSignalBlock)((Object)RailcraftBlocks.TOKEN_SIGNAL.get()));
        this.createDualSignalBlock((DualSignalBlock)((Object)RailcraftBlocks.DUAL_BLOCK_SIGNAL.get()));
        this.createDualSignalBlock((DualSignalBlock)((Object)RailcraftBlocks.DUAL_DISTANT_SIGNAL.get()));
        this.createDualSignalBlock((DualSignalBlock)((Object)RailcraftBlocks.DUAL_TOKEN_SIGNAL.get()));
        this.activatorTrackModels = this.createTrackModelSet("activator_track");
        this.activeActivatorTrackModels = this.createActiveTrackModelSet("activator_track");
        this.boosterTrackModels = this.createTrackModelSet("booster_track");
        this.activeBoosterTrackModels = this.createActiveTrackModelSet("booster_track");
        this.embarkingTrack = this.createTrackModelSet("embarking_track");
        this.activeEmbarkingTrack = this.createActiveTrackModelSet("embarking_track");
        this.dumpingTrack = this.createTrackModelSet("dumping_track");
        this.activeDumpingTrack = this.createActiveTrackModelSet("dumping_track");
        this.launcherTrackModels = this.createTrackModelSet("launcher_track");
        this.activeLauncherTrackModels = this.createActiveTrackModelSet("launcher_track");
        this.oneWayTrackModels = this.createTrackModelSet("one_way_track");
        this.activeOneWayTrackModels = this.createActiveTrackModelSet("one_way_track");
        this.routingTrackModels = this.createTrackModelSet("routing_track");
        this.activeRoutingTrackModels = this.createActiveTrackModelSet("routing_track");
        this.whistleTrackModels = this.createTrackModelSet("whistle_track");
        this.activeWhistleTrackModels = this.createActiveTrackModelSet("whistle_track");
        this.transitionTrackModels = this.createTrackModelSet("transition_track");
        this.activeTransitionTrackModels = this.createActiveTrackModelSet("transition_track");
        this.detectorTrackModels = this.createTrackModelSet("detector_track");
        this.activeDetectorTrackModels = this.createActiveTrackModelSet("detector_track");
        this.travelDetectorTrackModels = this.createTrackModelSet("detector_track_travel");
        this.activeTravelDetectorTrackModels = this.createActiveTrackModelSet("detector_track_travel");
        this.locomotiveTrackShutdownModel = this.createTrackModelSet("locomotive_track_shutdown");
        this.locomotiveTrackIdleModel = this.createTrackModelSet("locomotive_track_idle");
        this.locomotiveTrackRunningModel = this.createTrackModelSet("locomotive_track_running");
        this.activeLocomotiveTrackShutdownModel = this.createActiveTrackModelSet("locomotive_track_shutdown");
        this.activeLocomotiveTrackIdleModel = this.createActiveTrackModelSet("locomotive_track_idle");
        this.activeLocomotiveTrackRunningModel = this.createActiveTrackModelSet("locomotive_track_running");
        this.controlTrackModels = this.createTrackModelSet("control_track");
        this.couplerTrackCoupler = this.createTrackModelSet("coupler_track_coupler");
        this.activeCouplerTrackCoupler = this.createActiveTrackModelSet("coupler_track_coupler");
        this.couplerTrackDecoupler = this.createTrackModelSet("coupler_track_decoupler");
        this.activeCouplerTrackDecoupler = this.createActiveTrackModelSet("coupler_track_decoupler");
        this.couplerTrackAutoCoupler = this.createTrackModelSet("coupler_track_auto_coupler");
        this.activeCouplerTrackAutoCoupler = this.createActiveTrackModelSet("coupler_track_auto_coupler");
        this.disembarkingTrackLeft = this.createTrackModelSet("disembarking_track_left");
        this.activeDisembarkingTrackLeft = this.createActiveTrackModelSet("disembarking_track_left");
        this.disembarkingTrackRight = this.createTrackModelSet("disembarking_track_right");
        this.activeDisembarkingTrackRight = this.createActiveTrackModelSet("disembarking_track_right");
        this.createAbandonedTracks((TrackBlock)RailcraftBlocks.ABANDONED_TRACK.get(), (LockingTrackBlock)RailcraftBlocks.ABANDONED_LOCKING_TRACK.get(), (BufferStopTrackBlock)RailcraftBlocks.ABANDONED_BUFFER_STOP_TRACK.get(), (ActivatorTrackBlock)RailcraftBlocks.ABANDONED_ACTIVATOR_TRACK.get(), (BoosterTrackBlock)RailcraftBlocks.ABANDONED_BOOSTER_TRACK.get(), (ControlTrackBlock)RailcraftBlocks.ABANDONED_CONTROL_TRACK.get(), (GatedTrackBlock)RailcraftBlocks.ABANDONED_GATED_TRACK.get(), (DetectorTrackBlock)RailcraftBlocks.ABANDONED_DETECTOR_TRACK.get(), (CouplerTrackBlock)RailcraftBlocks.ABANDONED_COUPLER_TRACK.get(), (EmbarkingTrackBlock)RailcraftBlocks.ABANDONED_EMBARKING_TRACK.get(), (DisembarkingTrackBlock)RailcraftBlocks.ABANDONED_DISEMBARKING_TRACK.get(), (DumpingTrackBlock)RailcraftBlocks.ABANDONED_DUMPING_TRACK.get(), (TurnoutTrackBlock)RailcraftBlocks.ABANDONED_TURNOUT_TRACK.get(), (WyeTrackBlock)RailcraftBlocks.ABANDONED_WYE_TRACK.get(), (JunctionTrackBlock)RailcraftBlocks.ABANDONED_JUNCTION_TRACK.get(), (LauncherTrackBlock)RailcraftBlocks.ABANDONED_LAUNCHER_TRACK.get(), (OneWayTrackBlock)RailcraftBlocks.ABANDONED_ONE_WAY_TRACK.get(), (WhistleTrackBlock)RailcraftBlocks.ABANDONED_WHISTLE_TRACK.get(), (LocomotiveTrackBlock)RailcraftBlocks.ABANDONED_LOCOMOTIVE_TRACK.get(), (ThrottleTrackBlock)RailcraftBlocks.ABANDONED_THROTTLE_TRACK.get(), (RoutingTrackBlock)RailcraftBlocks.ABANDONED_ROUTING_TRACK.get());
        this.createOutfittedTracks(Blocks.f_50156_, (LockingTrackBlock)RailcraftBlocks.IRON_LOCKING_TRACK.get(), (BufferStopTrackBlock)RailcraftBlocks.IRON_BUFFER_STOP_TRACK.get(), (ActivatorTrackBlock)RailcraftBlocks.IRON_ACTIVATOR_TRACK.get(), (BoosterTrackBlock)RailcraftBlocks.IRON_BOOSTER_TRACK.get(), (ControlTrackBlock)RailcraftBlocks.IRON_CONTROL_TRACK.get(), (GatedTrackBlock)RailcraftBlocks.IRON_GATED_TRACK.get(), (DetectorTrackBlock)RailcraftBlocks.IRON_DETECTOR_TRACK.get(), (CouplerTrackBlock)RailcraftBlocks.IRON_COUPLER_TRACK.get(), (EmbarkingTrackBlock)RailcraftBlocks.IRON_EMBARKING_TRACK.get(), (DisembarkingTrackBlock)RailcraftBlocks.IRON_DISEMBARKING_TRACK.get(), (DumpingTrackBlock)RailcraftBlocks.IRON_DUMPING_TRACK.get(), (TurnoutTrackBlock)RailcraftBlocks.IRON_TURNOUT_TRACK.get(), (WyeTrackBlock)RailcraftBlocks.IRON_WYE_TRACK.get(), (JunctionTrackBlock)RailcraftBlocks.IRON_JUNCTION_TRACK.get(), (LauncherTrackBlock)RailcraftBlocks.IRON_LAUNCHER_TRACK.get(), (OneWayTrackBlock)RailcraftBlocks.IRON_ONE_WAY_TRACK.get(), (WhistleTrackBlock)RailcraftBlocks.IRON_WHISTLE_TRACK.get(), (LocomotiveTrackBlock)RailcraftBlocks.IRON_LOCOMOTIVE_TRACK.get(), (ThrottleTrackBlock)RailcraftBlocks.IRON_THROTTLE_TRACK.get(), (RoutingTrackBlock)RailcraftBlocks.IRON_ROUTING_TRACK.get());
        this.createTracks((TrackBlock)RailcraftBlocks.STRAP_IRON_TRACK.get(), (LockingTrackBlock)RailcraftBlocks.STRAP_IRON_LOCKING_TRACK.get(), (BufferStopTrackBlock)RailcraftBlocks.STRAP_IRON_BUFFER_STOP_TRACK.get(), (ActivatorTrackBlock)RailcraftBlocks.STRAP_IRON_ACTIVATOR_TRACK.get(), (BoosterTrackBlock)RailcraftBlocks.STRAP_IRON_BOOSTER_TRACK.get(), (ControlTrackBlock)RailcraftBlocks.STRAP_IRON_CONTROL_TRACK.get(), (GatedTrackBlock)RailcraftBlocks.STRAP_IRON_GATED_TRACK.get(), (DetectorTrackBlock)RailcraftBlocks.STRAP_IRON_DETECTOR_TRACK.get(), (CouplerTrackBlock)RailcraftBlocks.STRAP_IRON_COUPLER_TRACK.get(), (EmbarkingTrackBlock)RailcraftBlocks.STRAP_IRON_EMBARKING_TRACK.get(), (DisembarkingTrackBlock)RailcraftBlocks.STRAP_IRON_DISEMBARKING_TRACK.get(), (DumpingTrackBlock)RailcraftBlocks.STRAP_IRON_DUMPING_TRACK.get(), (TurnoutTrackBlock)RailcraftBlocks.STRAP_IRON_TURNOUT_TRACK.get(), (WyeTrackBlock)RailcraftBlocks.STRAP_IRON_WYE_TRACK.get(), (JunctionTrackBlock)RailcraftBlocks.STRAP_IRON_JUNCTION_TRACK.get(), (LauncherTrackBlock)RailcraftBlocks.STRAP_IRON_LAUNCHER_TRACK.get(), (OneWayTrackBlock)RailcraftBlocks.STRAP_IRON_ONE_WAY_TRACK.get(), (WhistleTrackBlock)RailcraftBlocks.STRAP_IRON_WHISTLE_TRACK.get(), (LocomotiveTrackBlock)RailcraftBlocks.STRAP_IRON_LOCOMOTIVE_TRACK.get(), (ThrottleTrackBlock)RailcraftBlocks.STRAP_IRON_THROTTLE_TRACK.get(), (RoutingTrackBlock)RailcraftBlocks.STRAP_IRON_ROUTING_TRACK.get());
        this.createTracks((TrackBlock)RailcraftBlocks.REINFORCED_TRACK.get(), (LockingTrackBlock)RailcraftBlocks.REINFORCED_LOCKING_TRACK.get(), (BufferStopTrackBlock)RailcraftBlocks.REINFORCED_BUFFER_STOP_TRACK.get(), (ActivatorTrackBlock)RailcraftBlocks.REINFORCED_ACTIVATOR_TRACK.get(), (BoosterTrackBlock)RailcraftBlocks.REINFORCED_BOOSTER_TRACK.get(), (ControlTrackBlock)RailcraftBlocks.REINFORCED_CONTROL_TRACK.get(), (GatedTrackBlock)RailcraftBlocks.REINFORCED_GATED_TRACK.get(), (DetectorTrackBlock)RailcraftBlocks.REINFORCED_DETECTOR_TRACK.get(), (CouplerTrackBlock)RailcraftBlocks.REINFORCED_COUPLER_TRACK.get(), (EmbarkingTrackBlock)RailcraftBlocks.REINFORCED_EMBARKING_TRACK.get(), (DisembarkingTrackBlock)RailcraftBlocks.REINFORCED_DISEMBARKING_TRACK.get(), (DumpingTrackBlock)RailcraftBlocks.REINFORCED_DUMPING_TRACK.get(), (TurnoutTrackBlock)RailcraftBlocks.REINFORCED_TURNOUT_TRACK.get(), (WyeTrackBlock)RailcraftBlocks.REINFORCED_WYE_TRACK.get(), (JunctionTrackBlock)RailcraftBlocks.REINFORCED_JUNCTION_TRACK.get(), (LauncherTrackBlock)RailcraftBlocks.REINFORCED_LAUNCHER_TRACK.get(), (OneWayTrackBlock)RailcraftBlocks.REINFORCED_ONE_WAY_TRACK.get(), (WhistleTrackBlock)RailcraftBlocks.REINFORCED_WHISTLE_TRACK.get(), (LocomotiveTrackBlock)RailcraftBlocks.REINFORCED_LOCOMOTIVE_TRACK.get(), (ThrottleTrackBlock)RailcraftBlocks.REINFORCED_THROTTLE_TRACK.get(), (RoutingTrackBlock)RailcraftBlocks.REINFORCED_ROUTING_TRACK.get());
        this.createTracks((TrackBlock)RailcraftBlocks.ELECTRIC_TRACK.get(), (LockingTrackBlock)RailcraftBlocks.ELECTRIC_LOCKING_TRACK.get(), (BufferStopTrackBlock)RailcraftBlocks.ELECTRIC_BUFFER_STOP_TRACK.get(), (ActivatorTrackBlock)RailcraftBlocks.ELECTRIC_ACTIVATOR_TRACK.get(), (BoosterTrackBlock)RailcraftBlocks.ELECTRIC_BOOSTER_TRACK.get(), (ControlTrackBlock)RailcraftBlocks.ELECTRIC_CONTROL_TRACK.get(), (GatedTrackBlock)RailcraftBlocks.ELECTRIC_GATED_TRACK.get(), (DetectorTrackBlock)RailcraftBlocks.ELECTRIC_DETECTOR_TRACK.get(), (CouplerTrackBlock)RailcraftBlocks.ELECTRIC_COUPLER_TRACK.get(), (EmbarkingTrackBlock)RailcraftBlocks.ELECTRIC_EMBARKING_TRACK.get(), (DisembarkingTrackBlock)RailcraftBlocks.ELECTRIC_DISEMBARKING_TRACK.get(), (DumpingTrackBlock)RailcraftBlocks.ELECTRIC_DUMPING_TRACK.get(), (TurnoutTrackBlock)RailcraftBlocks.ELECTRIC_TURNOUT_TRACK.get(), (WyeTrackBlock)RailcraftBlocks.ELECTRIC_WYE_TRACK.get(), (JunctionTrackBlock)RailcraftBlocks.ELECTRIC_JUNCTION_TRACK.get(), (LauncherTrackBlock)RailcraftBlocks.ELECTRIC_LAUNCHER_TRACK.get(), (OneWayTrackBlock)RailcraftBlocks.ELECTRIC_ONE_WAY_TRACK.get(), (WhistleTrackBlock)RailcraftBlocks.ELECTRIC_WHISTLE_TRACK.get(), (LocomotiveTrackBlock)RailcraftBlocks.ELECTRIC_LOCOMOTIVE_TRACK.get(), (ThrottleTrackBlock)RailcraftBlocks.ELECTRIC_THROTTLE_TRACK.get(), (RoutingTrackBlock)RailcraftBlocks.ELECTRIC_ROUTING_TRACK.get());
        this.createHighSpeedTracks((TrackBlock)RailcraftBlocks.HIGH_SPEED_TRACK.get(), (TransitionTrackBlock)RailcraftBlocks.HIGH_SPEED_TRANSITION_TRACK.get(), (LockingTrackBlock)RailcraftBlocks.HIGH_SPEED_LOCKING_TRACK.get(), (ActivatorTrackBlock)RailcraftBlocks.HIGH_SPEED_ACTIVATOR_TRACK.get(), (BoosterTrackBlock)RailcraftBlocks.HIGH_SPEED_BOOSTER_TRACK.get(), (DetectorTrackBlock)RailcraftBlocks.HIGH_SPEED_DETECTOR_TRACK.get(), (TurnoutTrackBlock)RailcraftBlocks.HIGH_SPEED_TURNOUT_TRACK.get(), (WyeTrackBlock)RailcraftBlocks.HIGH_SPEED_WYE_TRACK.get(), (JunctionTrackBlock)RailcraftBlocks.HIGH_SPEED_JUNCTION_TRACK.get(), (WhistleTrackBlock)RailcraftBlocks.HIGH_SPEED_WHISTLE_TRACK.get(), (LocomotiveTrackBlock)RailcraftBlocks.HIGH_SPEED_LOCOMOTIVE_TRACK.get(), (ThrottleTrackBlock)RailcraftBlocks.HIGH_SPEED_THROTTLE_TRACK.get());
        this.createHighSpeedTracks((TrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_TRACK.get(), (TransitionTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_TRANSITION_TRACK.get(), (LockingTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_LOCKING_TRACK.get(), (ActivatorTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_ACTIVATOR_TRACK.get(), (BoosterTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_BOOSTER_TRACK.get(), (DetectorTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_DETECTOR_TRACK.get(), (TurnoutTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_TURNOUT_TRACK.get(), (WyeTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_WYE_TRACK.get(), (JunctionTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_JUNCTION_TRACK.get(), (WhistleTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_WHISTLE_TRACK.get(), (LocomotiveTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_LOCOMOTIVE_TRACK.get(), (ThrottleTrackBlock)RailcraftBlocks.HIGH_SPEED_ELECTRIC_THROTTLE_TRACK.get());
    }

    private void createStrengthenedGlass(Block block) {
        ResourceLocation endTexture = TextureMapping.m_125753_((Block)block, (String)"_top");
        BlockModelBuilder singleModel = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeAll(this.name(block, "_single"), endTexture)).renderType(CUTOUT);
        BlockModelBuilder topModel = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeColumn(this.name(block, "_top"), TextureMapping.m_125753_((Block)block, (String)"_side_top"), endTexture)).renderType(CUTOUT);
        BlockModelBuilder centerModel = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeColumn(this.name(block, "_center"), TextureMapping.m_125753_((Block)block, (String)"_side_center"), endTexture)).renderType(CUTOUT);
        BlockModelBuilder bottomModel = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeColumn(this.name(block, "_bottom"), TextureMapping.m_125753_((Block)block, (String)"_side_bottom"), endTexture)).renderType(CUTOUT);
        this.getVariantBuilder(block).forAllStatesExcept(blockState -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            return builder.modelFile((ModelFile)(switch ((AbstractStrengthenedGlassBlock.Type)((Object)((Object)blockState.m_61143_(AbstractStrengthenedGlassBlock.TYPE)))) {
                default -> throw new IncompatibleClassChangeError();
                case AbstractStrengthenedGlassBlock.Type.SINGLE -> singleModel;
                case AbstractStrengthenedGlassBlock.Type.TOP -> topModel;
                case AbstractStrengthenedGlassBlock.Type.CENTER -> centerModel;
                case AbstractStrengthenedGlassBlock.Type.BOTTOM -> bottomModel;
            })).build();
        }, new Property[]{IronTankGaugeBlock.LEVEL});
        this.itemModels().withExistingParent(this.name(block), this.modLoc("block/" + this.name(block, "_single")));
    }

    private void createFluidManipulator(FluidManipulatorBlock<?> block) {
        TextureMapping texture = TextureMapping.m_125826_(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block), texture.m_125756_(TextureSlot.f_125875_), texture.m_125756_(TextureSlot.f_125871_), texture.m_125756_(TextureSlot.f_125872_))).renderType(CUTOUT);
        this.simpleBlock((Block)block, (ModelFile)model);
        ResourceLocation side = new ResourceLocation("railcraft", "block/fluid_manipulator_side_inventory");
        ResourceLocation bottom = TextureMapping.m_125753_(block, (String)"_bottom");
        ResourceLocation top = TextureMapping.m_125753_(block, (String)"_top");
        this.models().cubeBottomTop(this.name((Block)block, "_inventory"), side, bottom, top);
        this.itemModels().withExistingParent(this.name((Block)block), this.modLoc("block/" + this.name((Block)block, "_inventory")));
    }

    private void createManipulator(ManipulatorBlock<?> block) {
        TextureMapping texture = TextureMapping.m_125826_(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block), texture.m_125756_(TextureSlot.f_125875_), texture.m_125756_(TextureSlot.f_125871_), texture.m_125756_(TextureSlot.f_125872_));
        this.simpleBlock((Block)block, (ModelFile)model);
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void createDirectionalManipulator(ManipulatorBlock<?> block) {
        TextureMapping horizontalTexture = TextureMapping.m_125848_(block);
        BlockModelBuilder horizontalModel = (BlockModelBuilder)this.models().orientable(this.name((Block)block), horizontalTexture.m_125756_(TextureSlot.f_125875_), horizontalTexture.m_125756_(TextureSlot.f_125873_), horizontalTexture.m_125756_(TextureSlot.f_125872_));
        ResourceLocation side = TextureMapping.m_125753_(block, (String)"_side");
        ResourceLocation front = TextureMapping.m_125753_(block, (String)"_front");
        ResourceLocation top = TextureMapping.m_125753_(block, (String)"_top");
        BlockModelBuilder upModel = (BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block, "_up"), side, top, front);
        BlockModelBuilder downModel = (BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block, "_down"), side, front, top);
        this.getVariantBuilder((Block)block).forAllStatesExcept(blockState -> {
            Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
            int yRot = 0;
            switch (facing) {
                case SOUTH: {
                    yRot = 180;
                    break;
                }
                case EAST: {
                    yRot = 90;
                    break;
                }
                case WEST: {
                    yRot = 270;
                    break;
                }
                case UP: {
                    return ConfiguredModel.builder().modelFile((ModelFile)upModel).build();
                }
                case DOWN: {
                    return ConfiguredModel.builder().modelFile((ModelFile)downModel).build();
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)horizontalModel).rotationX(0).rotationY(yRot).build();
        }, new Property[]{AdvancedItemLoaderBlock.POWERED});
        this.simpleBlockItem((Block)block, (ModelFile)horizontalModel);
    }

    private void createSteamOven(SteamOvenBlock block) {
        ResourceLocation sideTexture = TextureMapping.m_125753_((Block)block, (String)"_side");
        ResourceLocation frontTexture = TextureMapping.m_125753_((Block)block, (String)"_front");
        ResourceLocation topTexture = TextureMapping.m_125753_((Block)block, (String)"_top");
        ResourceLocation bottomLeftTexture = TextureMapping.m_125753_((Block)block, (String)"_bottom_left");
        ResourceLocation bottomRightTexture = TextureMapping.m_125753_((Block)block, (String)"_bottom_right");
        ResourceLocation topLeftTexture = TextureMapping.m_125753_((Block)block, (String)"_top_left");
        ResourceLocation topRightTexture = TextureMapping.m_125753_((Block)block, (String)"_top_right");
        BlockModelBuilder defaultModel = (BlockModelBuilder)this.models().orientable(this.name((Block)block), sideTexture, frontTexture, topTexture);
        BlockModelBuilder bottomLeftModel = (BlockModelBuilder)this.models().orientable(this.name((Block)block, "_bottom_left"), sideTexture, bottomLeftTexture, topTexture);
        BlockModelBuilder bottomRightModel = (BlockModelBuilder)this.models().orientable(this.name((Block)block, "_bottom_right"), sideTexture, bottomRightTexture, topTexture);
        BlockModelBuilder topLeftModel = (BlockModelBuilder)this.models().orientable(this.name((Block)block, "_top_left"), sideTexture, topLeftTexture, topTexture);
        BlockModelBuilder topRightModel = (BlockModelBuilder)this.models().orientable(this.name((Block)block, "_top_right"), sideTexture, topRightTexture, topTexture);
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            SteamOvenBlock.Type type = (SteamOvenBlock.Type)((Object)((Object)blockState.m_61143_(SteamOvenBlock.TYPE)));
            Direction facing = (Direction)blockState.m_61143_((Property)SteamOvenBlock.FACING);
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            return builder.modelFile((ModelFile)(switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case SteamOvenBlock.Type.DEFAULT -> defaultModel;
                case SteamOvenBlock.Type.DOOR_TOP_LEFT -> topLeftModel;
                case SteamOvenBlock.Type.DOOR_TOP_RIGHT -> topRightModel;
                case SteamOvenBlock.Type.DOOR_BOTTOM_LEFT -> bottomLeftModel;
                case SteamOvenBlock.Type.DOOR_BOTTOM_RIGHT -> bottomRightModel;
            })).rotationY(((int)facing.m_122435_() + 180) % 360).build();
        });
        this.simpleBlockItem((Block)block, (ModelFile)defaultModel);
    }

    private void createFirebox(FireboxBlock block) {
        ResourceLocation endTexture = TextureMapping.m_125753_((Block)block, (String)"_end");
        ResourceLocation sideTexture = TextureMapping.m_125753_((Block)block, (String)"_side");
        ResourceLocation sideLitTexture = TextureMapping.m_125753_((Block)block, (String)"_side_lit");
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeColumn(this.name((Block)block), sideTexture, endTexture);
        BlockModelBuilder litModel = (BlockModelBuilder)this.models().cubeColumn(this.name((Block)block, "_lit"), sideLitTexture, endTexture);
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            Boolean lit = (Boolean)blockState.m_61143_(FireboxBlock.LIT);
            return ConfiguredModel.builder().modelFile((ModelFile)(lit != false ? litModel : model)).build();
        });
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void createFurnaceMultiblockBricks(FurnaceMultiblockBlock block) {
        ResourceLocation blockTexture = TextureMapping.m_125740_((Block)block);
        ResourceLocation sideTexture = TextureMapping.m_125753_((Block)block, (String)"_window");
        ResourceLocation sideLitTexture = TextureMapping.m_125753_((Block)block, (String)"_window_lit");
        ModelFile bricksModel = this.cubeAll((Block)block);
        BlockModelBuilder windowModel = (BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block, "_window"), sideTexture, blockTexture, blockTexture);
        BlockModelBuilder litWindowModel = (BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block, "_window_lit"), sideLitTexture, blockTexture, blockTexture);
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            Boolean lit = (Boolean)blockState.m_61143_((Property)FurnaceMultiblockBlock.LIT);
            Boolean window = (Boolean)blockState.m_61143_((Property)FurnaceMultiblockBlock.WINDOW);
            Object model = window == false ? bricksModel : (lit != false ? litWindowModel : windowModel);
            return ConfiguredModel.builder().modelFile(model).build();
        });
        this.simpleBlockItem((Block)block, bricksModel);
    }

    private void createCrusherMultiblockBricks(CrusherMultiblockBlock block) {
        ResourceLocation topTexture = TextureMapping.m_125753_((Block)block, (String)"_top");
        ResourceLocation sideTexture = TextureMapping.m_125753_((Block)block, (String)"_side_exporter");
        ResourceLocation bottomTexture = TextureMapping.m_125753_((Block)block, (String)"_side");
        BlockModelBuilder baseModel = (BlockModelBuilder)this.models().cubeTop(this.name((Block)block), bottomTexture, topTexture);
        BlockModelBuilder outputModel = (BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block, "_exporter"), sideTexture, bottomTexture, topTexture);
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            CrusherMultiblockBlock.Type type = (CrusherMultiblockBlock.Type)((Object)((Object)blockState.m_61143_(CrusherMultiblockBlock.TYPE)));
            Boolean rotated = (Boolean)blockState.m_61143_(CrusherMultiblockBlock.ROTATED);
            Boolean output = (Boolean)blockState.m_61143_(CrusherMultiblockBlock.OUTPUT);
            if (output.booleanValue()) {
                return ConfiguredModel.builder().modelFile((ModelFile)outputModel).build();
            }
            if (type.equals((Object)CrusherMultiblockBlock.Type.NONE)) {
                return ConfiguredModel.builder().modelFile((ModelFile)baseModel).build();
            }
            String suffix = "_top_" + type.m_7912_();
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeTop(this.name((Block)block, suffix), bottomTexture, TextureMapping.m_125753_((Block)block, (String)suffix));
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(rotated != false ? 90 : 0).build();
        });
        this.simpleBlockItem((Block)block, (ModelFile)baseModel);
    }

    private void createSteamTurbine(Block block) {
        ResourceLocation sideTexture = TextureMapping.m_125753_((Block)block, (String)"_side");
        this.createSteamTurbineModel(block, sideTexture, "_inventory", false);
        this.itemModels().withExistingParent(this.name(block), this.modLoc("block/" + this.name(block, "_inventory")));
        BlockModelBuilder noneVariant = (BlockModelBuilder)this.models().cubeAll(this.name(block, "_side"), sideTexture);
        this.getVariantBuilder(block).forAllStates(blockState -> {
            SteamTurbineBlock.Type type = (SteamTurbineBlock.Type)((Object)((Object)blockState.m_61143_(SteamTurbineBlock.TYPE)));
            Boolean rotated = (Boolean)blockState.m_61143_(SteamTurbineBlock.ROTATED);
            if (type == SteamTurbineBlock.Type.NONE) {
                return ConfiguredModel.builder().modelFile((ModelFile)noneVariant).build();
            }
            BlockModelBuilder model = this.createSteamTurbineModel(block, sideTexture, "_" + type.m_7912_(), type != SteamTurbineBlock.Type.WINDOW);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(rotated != false ? 90 : 0).build();
        });
    }

    private BlockModelBuilder createSteamTurbineModel(Block block, ResourceLocation sideTexture, String suffix, boolean rotated) {
        ResourceLocation frontTexture = TextureMapping.m_125753_((Block)block, (String)suffix);
        ResourceLocation parent = this.modLoc("block/template_mirrored_cube");
        return this.cube(this.name(block, suffix), parent, sideTexture, sideTexture, rotated ? sideTexture : frontTexture, rotated ? sideTexture : frontTexture, rotated ? frontTexture : sideTexture, rotated ? frontTexture : sideTexture, sideTexture);
    }

    private void createTankValve(TankValveBlock block, BaseTankBlock wallBlock) {
        BlockModelBuilder verticalModel = this.cube(this.name((Block)block), this.mcLoc("cube"), TextureMapping.m_125753_((Block)block, (String)"_top"), TextureMapping.m_125753_((Block)block, (String)"_top"), TextureMapping.m_125753_((Block)wallBlock, (String)"_side"), TextureMapping.m_125753_((Block)wallBlock, (String)"_side"), TextureMapping.m_125753_((Block)wallBlock, (String)"_side"), TextureMapping.m_125753_((Block)wallBlock, (String)"_side"), TextureMapping.m_125753_((Block)wallBlock, (String)"_top"));
        BlockModelBuilder horizontalModel = this.cube(this.name((Block)block, "_horizontal"), this.mcLoc("cube"), TextureMapping.m_125753_((Block)wallBlock, (String)"_top"), TextureMapping.m_125753_((Block)wallBlock, (String)"_top"), TextureMapping.m_125753_((Block)block, (String)"_front"), TextureMapping.m_125753_((Block)block, (String)"_front"), TextureMapping.m_125753_((Block)wallBlock, (String)"_side"), TextureMapping.m_125753_((Block)wallBlock, (String)"_side"), TextureMapping.m_125753_((Block)wallBlock, (String)"_top"));
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            Direction.Axis axis = (Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61365_);
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.Y -> ConfiguredModel.builder().modelFile((ModelFile)verticalModel).build();
                case Direction.Axis.Z -> ConfiguredModel.builder().modelFile((ModelFile)horizontalModel).build();
                case Direction.Axis.X -> ConfiguredModel.builder().modelFile((ModelFile)horizontalModel).rotationY(90).build();
            };
        });
        this.simpleBlockItem((Block)block, (ModelFile)verticalModel);
    }

    private void createCubeColumnBlock(Block block) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeColumn(this.name(block), TextureMapping.m_125753_((Block)block, (String)"_side"), TextureMapping.m_125753_((Block)block, (String)"_top"));
        this.simpleBlock(block, (ModelFile)model);
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void createCubeTopBottomBlock(Block block) {
        ResourceLocation sideTexture = TextureMapping.m_125753_((Block)block, (String)"_side");
        ResourceLocation bottomTexture = TextureMapping.m_125753_((Block)block, (String)"_bottom");
        ResourceLocation topTexture = TextureMapping.m_125753_((Block)block, (String)"_top");
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(this.name(block), sideTexture, bottomTexture, topTexture);
        this.simpleBlock(block, (ModelFile)model);
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void createFrameBlock(FrameBlock block) {
        ResourceLocation sideTexture = TextureMapping.m_125753_((Block)block, (String)"_side");
        ResourceLocation topTexture = TextureMapping.m_125753_((Block)block, (String)"_top");
        ResourceLocation topPoweredTexture = TextureMapping.m_125753_((Block)block, (String)"_top_powered");
        ResourceLocation frameTemplate = this.modLoc("frame_template");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), frameTemplate)).texture("side", sideTexture)).texture("top", topTexture)).renderType(CUTOUT);
        BlockModelBuilder modelPowered = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block, "_powered"), frameTemplate)).texture("side", sideTexture)).texture("top", topPoweredTexture)).renderType(CUTOUT);
        this.getVariantBuilder(block).forAllStates(blockState -> {
            Boolean powered = (Boolean)blockState.m_61143_((Property)FrameBlock.POWERED);
            return ConfiguredModel.builder().modelFile((ModelFile)(powered != false ? modelPowered : model)).build();
        });
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void createLogBookBlock(LogBookBlock block) {
        ResourceLocation sideTexture = TextureMapping.m_125753_((Block)block, (String)"_side");
        ResourceLocation topTexture = TextureMapping.m_125753_((Block)block, (String)"_top");
        ResourceLocation bottomTexture = TextureMapping.m_125753_((Block)block, (String)"_bottom");
        ResourceLocation coverTexture = TextureMapping.m_125753_((Block)block, (String)"_cover");
        ResourceLocation paperTexture = TextureMapping.m_125753_((Block)block, (String)"_paper");
        ResourceLocation logbookTemplate = this.modLoc("logbook_template");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), logbookTemplate)).texture("paper", paperTexture)).texture("cover", coverTexture)).texture("side", sideTexture)).texture("top", topTexture)).texture("bottom", bottomTexture);
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            Direction facing = (Direction)blockState.m_61143_((Property)LogBookBlock.f_54117_);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(((int)facing.m_122435_() + 180) % 360).build();
        });
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void createPost(PostBlock block) {
        ResourceLocation texture = TextureMapping.m_125768_((Block)block).m_125756_(TextureSlot.f_125868_);
        ResourceLocation postFullColumnTemplate = this.modLoc("template_post_full_column");
        ResourceLocation postDoubleConnectionTemplate = this.modLoc("template_post_double_connection");
        ResourceLocation postTopColumnTemplate = this.modLoc("template_post_top_column");
        ResourceLocation postSmallColumnTemplate = this.modLoc("template_post_small_column");
        ResourceLocation postPlatformTemplate = this.modLoc("template_post_platform");
        ResourceLocation postSingleConnectionTemplate = this.modLoc("template_post_single_connection");
        ResourceLocation postInventoryTemplate = this.modLoc("post_inventory");
        BlockModelBuilder fullColumnModel = (BlockModelBuilder)this.models().singleTexture(this.name(block, "_full_column"), postFullColumnTemplate, texture);
        BlockModelBuilder doubleConnectionModel = (BlockModelBuilder)this.models().singleTexture(this.name(block, "_double_connection"), postDoubleConnectionTemplate, texture);
        BlockModelBuilder topColumnModel = (BlockModelBuilder)this.models().singleTexture(this.name(block, "_top_column"), postTopColumnTemplate, texture);
        BlockModelBuilder smallColumnModel = (BlockModelBuilder)this.models().singleTexture(this.name(block, "_small_column"), postSmallColumnTemplate, texture);
        BlockModelBuilder platformModel = (BlockModelBuilder)this.models().singleTexture(this.name(block, "_platform"), postPlatformTemplate, texture);
        BlockModelBuilder singleConnectionModel = (BlockModelBuilder)this.models().singleTexture(this.name(block, "_single_connection"), postSingleConnectionTemplate, texture);
        BlockModelBuilder inventoryModel = (BlockModelBuilder)this.models().singleTexture(this.name(block, "_inventory"), postInventoryTemplate, texture);
        this.itemModels().withExistingParent(this.name(block), inventoryModel.getLocation());
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)platformModel).addModel()).condition(PostBlock.COLUMN, (Comparable[])new Column[]{Column.PLATFORM}).end().part().modelFile((ModelFile)topColumnModel).addModel()).condition(PostBlock.COLUMN, (Comparable[])new Column[]{Column.TOP}).end().part().modelFile((ModelFile)smallColumnModel).addModel()).condition(PostBlock.COLUMN, (Comparable[])new Column[]{Column.SMALL}).end().part().modelFile((ModelFile)fullColumnModel).addModel()).condition(PostBlock.COLUMN, (Comparable[])new Column[]{Column.FULL}).end().part().modelFile((ModelFile)singleConnectionModel).uvLock(true).addModel()).condition(PostBlock.NORTH, (Comparable[])new Connection[]{Connection.SINGLE}).end().part().modelFile((ModelFile)doubleConnectionModel).uvLock(true).addModel()).condition(PostBlock.NORTH, (Comparable[])new Connection[]{Connection.DOUBLE}).end().part().modelFile((ModelFile)singleConnectionModel).uvLock(true).rotationY(180).addModel()).condition(PostBlock.SOUTH, (Comparable[])new Connection[]{Connection.SINGLE}).end().part().modelFile((ModelFile)doubleConnectionModel).uvLock(true).rotationY(180).addModel()).condition(PostBlock.SOUTH, (Comparable[])new Connection[]{Connection.DOUBLE}).end().part().modelFile((ModelFile)singleConnectionModel).uvLock(true).rotationY(90).addModel()).condition(PostBlock.EAST, (Comparable[])new Connection[]{Connection.SINGLE}).end().part().modelFile((ModelFile)doubleConnectionModel).uvLock(true).rotationY(90).addModel()).condition(PostBlock.EAST, (Comparable[])new Connection[]{Connection.DOUBLE}).end().part().modelFile((ModelFile)singleConnectionModel).uvLock(true).rotationY(270).addModel()).condition(PostBlock.WEST, (Comparable[])new Connection[]{Connection.SINGLE}).end().part().modelFile((ModelFile)doubleConnectionModel).uvLock(true).rotationY(270).addModel()).condition(PostBlock.WEST, (Comparable[])new Connection[]{Connection.DOUBLE}).end();
    }

    private void createSteamBoilerTank(SteamBoilerTankBlock block) {
        ResourceLocation end = TextureMapping.m_125753_((Block)block, (String)"_end");
        ResourceLocation side = TextureMapping.m_125753_((Block)block, (String)"_side");
        ResourceLocation steamBoilerTemplate = this.modLoc("template_steam_boiler_tank");
        ResourceLocation steamBoilerNETemplate = this.modLoc("template_steam_boiler_tank_ne");
        ResourceLocation steamBoilerNEWTemplate = this.modLoc("template_steam_boiler_tank_new");
        ResourceLocation steamBoilerNSETemplate = this.modLoc("template_steam_boiler_tank_nse");
        ResourceLocation steamBoilerNSWTemplate = this.modLoc("template_steam_boiler_tank_nsw");
        ResourceLocation steamBoilerNWTemplate = this.modLoc("template_steam_boiler_tank_nw");
        ResourceLocation steamBoilerSETemplate = this.modLoc("template_steam_boiler_tank_se");
        ResourceLocation steamBoilerSEWTemplate = this.modLoc("template_steam_boiler_tank_sew");
        ResourceLocation steamBoilerSWTemplate = this.modLoc("template_steam_boiler_tank_sw");
        BlockModelBuilder model = this.sideEnd(this.name((Block)block), steamBoilerTemplate, side, end);
        BlockModelBuilder allModel = (BlockModelBuilder)this.models().cubeColumn(this.name((Block)block, "_all"), side, end);
        BlockModelBuilder northEastModel = this.sideEnd(this.name((Block)block, "_ne"), steamBoilerNETemplate, side, end);
        BlockModelBuilder northEastWestModel = this.sideEnd(this.name((Block)block, "_new"), steamBoilerNEWTemplate, side, end);
        BlockModelBuilder northSouthEastModel = this.sideEnd(this.name((Block)block, "_nse"), steamBoilerNSETemplate, side, end);
        BlockModelBuilder northSouthWestModel = this.sideEnd(this.name((Block)block, "_nsw"), steamBoilerNSWTemplate, side, end);
        BlockModelBuilder northWestModel = this.sideEnd(this.name((Block)block, "_nw"), steamBoilerNWTemplate, side, end);
        BlockModelBuilder southEastModel = this.sideEnd(this.name((Block)block, "_se"), steamBoilerSETemplate, side, end);
        BlockModelBuilder southEastWestModel = this.sideEnd(this.name((Block)block, "_sew"), steamBoilerSEWTemplate, side, end);
        BlockModelBuilder southWestModel = this.sideEnd(this.name((Block)block, "_sw"), steamBoilerSWTemplate, side, end);
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            SteamBoilerTankBlock.ConnectionType type = (SteamBoilerTankBlock.ConnectionType)((Object)((Object)blockState.m_61143_(SteamBoilerTankBlock.CONNECTION_TYPE)));
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            return builder.modelFile((ModelFile)(switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case SteamBoilerTankBlock.ConnectionType.ALL -> allModel;
                case SteamBoilerTankBlock.ConnectionType.NONE -> model;
                case SteamBoilerTankBlock.ConnectionType.NORTH_EAST -> northEastModel;
                case SteamBoilerTankBlock.ConnectionType.SOUTH_EAST -> southEastModel;
                case SteamBoilerTankBlock.ConnectionType.SOUTH_WEST -> southWestModel;
                case SteamBoilerTankBlock.ConnectionType.NORTH_WEST -> northWestModel;
                case SteamBoilerTankBlock.ConnectionType.NORTH_SOUTH_EAST -> northSouthEastModel;
                case SteamBoilerTankBlock.ConnectionType.SOUTH_EAST_WEST -> southEastWestModel;
                case SteamBoilerTankBlock.ConnectionType.NORTH_EAST_WEST -> northEastWestModel;
                case SteamBoilerTankBlock.ConnectionType.NORTH_SOUTH_WEST -> northSouthWestModel;
            })).build();
        });
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void createSteelAnvil(AnvilBlock block) {
        ResourceLocation base = TextureMapping.m_125740_((Block)((Block)RailcraftBlocks.STEEL_ANVIL.get()));
        ResourceLocation top = TextureMapping.m_125753_((Block)block, (String)"_top");
        ResourceLocation template = this.mcLoc("template_anvil");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), template)).texture("top", top)).texture("body", base)).texture("particle", base);
        this.horizontalBlock((Block)block, (ModelFile)model, 0);
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void createRechargeableBattery(BatteryBlock battery) {
        ResourceLocation top = TextureMapping.m_125753_((Block)battery, (String)"_top");
        ResourceLocation bottom = TextureMapping.m_125753_((Block)battery, (String)"_bottom");
        ResourceLocation sideA = TextureMapping.m_125753_((Block)battery, (String)"_side_a");
        ResourceLocation sideB = TextureMapping.m_125753_((Block)battery, (String)"_side_b");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(battery), this.modLoc("battery"))).texture("bottom", bottom)).texture("top", top)).texture("side_a", sideA)).texture("side_b", sideB);
        this.simpleBlockWithItem(battery, (ModelFile)model);
    }

    private void createDisposableBattery(DisposableBatteryBlock battery, EmptyBatteryBlock emptyBattery) {
        this.createRechargeableBattery(battery);
        ResourceLocation top = TextureMapping.m_125753_((Block)battery, (String)"_top_burned");
        ResourceLocation bottom = TextureMapping.m_125753_((Block)battery, (String)"_bottom");
        ResourceLocation sideA = TextureMapping.m_125753_((Block)battery, (String)"_side_a_burned");
        ResourceLocation sideB = TextureMapping.m_125753_((Block)battery, (String)"_side_b_burned");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(emptyBattery), this.modLoc("battery"))).texture("bottom", bottom)).texture("top", top)).texture("side_a", sideA)).texture("side_b", sideB);
        this.simpleBlockWithItem(emptyBattery, (ModelFile)model);
    }

    private void createSignalBoxBlock(SignalBoxBlock signalBlock) {
        ResourceLocation up = this.modLoc("entity/signal_box/" + this.name((Block)signalBlock));
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)signalBlock), this.modLoc("signal_box"))).texture("up", up);
        this.itemModels().withExistingParent(this.name((Block)signalBlock), model.getLocation());
        ModelFile.ExistingModelFile signalBoxCapModel = this.models().getExistingFile(this.modLoc("block/signal_box_cap"));
        ModelFile.ExistingModelFile signalBoxConnectorModel = this.models().getExistingFile(this.modLoc("block/signal_box_connector"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)signalBlock).part().modelFile((ModelFile)signalBoxCapModel).addModel()).condition((Property)SignalBoxBlock.CAP, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalBoxConnectorModel).addModel()).condition((Property)SignalBoxBlock.f_52309_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalBoxConnectorModel).rotationY(90).addModel()).condition((Property)SignalBoxBlock.f_52310_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalBoxConnectorModel).rotationY(180).addModel()).condition((Property)SignalBoxBlock.f_52311_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalBoxConnectorModel).rotationY(270).addModel()).condition((Property)SignalBoxBlock.f_52312_, (Comparable[])new Boolean[]{true}).end();
    }

    private void createSingleSignalBlock(SingleSignalBlock signalBlock) {
        ModelFile.ExistingModelFile signalPostModel = this.models().getExistingFile(this.modLoc("block/signal_post"));
        ModelFile.ExistingModelFile signalModel = this.models().getExistingFile(this.modLoc("block/signal"));
        ModelFile.ExistingModelFile signalConnectorModel = this.models().getExistingFile(this.modLoc("block/signal_connector"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)signalBlock).part().modelFile((ModelFile)signalPostModel).addModel()).condition((Property)SingleSignalBlock.DOWN, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalModel).addModel()).condition((Property)SingleSignalBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)signalModel).rotationY(90).addModel()).condition((Property)SingleSignalBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)signalModel).rotationY(180).addModel()).condition((Property)SingleSignalBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)signalModel).rotationY(270).addModel()).condition((Property)SingleSignalBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).end().part().modelFile((ModelFile)signalConnectorModel).rotationY(270).addModel()).condition((Property)SingleSignalBlock.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalConnectorModel).addModel()).condition((Property)SingleSignalBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalConnectorModel).rotationY(90).addModel()).condition((Property)SingleSignalBlock.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalConnectorModel).rotationY(180).addModel()).condition((Property)SingleSignalBlock.WEST, (Comparable[])new Boolean[]{true}).end();
    }

    private void createDualSignalBlock(DualSignalBlock signalBlock) {
        ResourceLocation bottomLamp;
        ResourceLocation topLamp;
        if (signalBlock == RailcraftBlocks.DUAL_DISTANT_SIGNAL.get()) {
            topLamp = this.modLoc("entity/signal_aspect/red");
            bottomLamp = this.modLoc("entity/signal_aspect/green");
        } else if (signalBlock == RailcraftBlocks.DUAL_TOKEN_SIGNAL.get()) {
            topLamp = this.modLoc("entity/signal_aspect/green");
            bottomLamp = this.modLoc("entity/signal_aspect/yellow");
        } else if (signalBlock == RailcraftBlocks.DUAL_BLOCK_SIGNAL.get()) {
            topLamp = this.modLoc("entity/signal_aspect/green");
            bottomLamp = this.modLoc("entity/signal_aspect/red");
        } else {
            throw new NotImplementedException();
        }
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)signalBlock, "_inventory"), this.modLoc("dual_signal_inventory"))).texture("top_lamp", topLamp)).texture("bottom_lamp", bottomLamp);
        this.itemModels().withExistingParent(this.name((Block)signalBlock), model.getLocation());
        ModelFile.ExistingModelFile signalModel = this.models().getExistingFile(this.modLoc("block/dual_signal"));
        ModelFile.ExistingModelFile signalConnectorModel = this.models().getExistingFile(this.modLoc("block/signal_connector"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)signalBlock).part().modelFile((ModelFile)signalModel).addModel()).condition((Property)DualSignalBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)signalModel).rotationY(90).addModel()).condition((Property)DualSignalBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)signalModel).rotationY(180).addModel()).condition((Property)DualSignalBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)signalModel).rotationY(270).addModel()).condition((Property)DualSignalBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).end().part().modelFile((ModelFile)signalConnectorModel).rotationY(270).addModel()).condition((Property)DualSignalBlock.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalConnectorModel).addModel()).condition((Property)DualSignalBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalConnectorModel).rotationY(90).addModel()).condition((Property)DualSignalBlock.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)signalConnectorModel).rotationY(180).addModel()).condition((Property)DualSignalBlock.WEST, (Comparable[])new Boolean[]{true}).end();
    }

    public void fluidBlock(LiquidBlock block) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), this.mcLoc("water"));
        this.simpleBlock((Block)block, (ModelFile)model);
    }

    private void createElevatorTrack(ElevatorTrackBlock block) {
        ResourceLocation texture = TextureMapping.m_125768_((Block)block).m_125756_(TextureSlot.f_125868_);
        ResourceLocation textureOn = TextureMapping.m_125753_((Block)block, (String)"_on");
        ResourceLocation template = this.modLoc("template_elevator_track");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name(block), template, texture)).renderType(CUTOUT);
        BlockModelBuilder activeModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name(block, "_on"), template, textureOn)).renderType(CUTOUT);
        this.getVariantBuilder(block).forAllStates(blockState -> {
            Boolean powered = (Boolean)blockState.m_61143_((Property)ElevatorTrackBlock.POWERED);
            Direction facing = (Direction)blockState.m_61143_((Property)ElevatorTrackBlock.FACING);
            int yRot = switch (facing) {
                case Direction.SOUTH -> 180;
                case Direction.EAST -> 90;
                case Direction.WEST -> 270;
                default -> 0;
            };
            return ConfiguredModel.builder().modelFile((ModelFile)(powered != false ? activeModel : model)).rotationY(yRot).build();
        });
        this.basicItem(block);
    }

    private void createForceTrack(ForceTrackBlock block) {
        ResourceLocation texture = TextureMapping.m_125740_((Block)block);
        ResourceLocation template = this.modLoc("template_force_track");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block), template, "rail", texture)).renderType(CUTOUT);
        this.getVariantBuilder((Block)block).partialState().with(ForceTrackBlock.SHAPE, (Comparable)RailShape.NORTH_SOUTH).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).build()).partialState().with(ForceTrackBlock.SHAPE, (Comparable)RailShape.EAST_WEST).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(90).build());
    }

    private void createForceTrackEmitter(ForceTrackEmitterBlock block) {
        ResourceLocation front = TextureMapping.m_125753_((Block)block, (String)"_facing");
        ResourceLocation side = TextureMapping.m_125753_((Block)block, (String)"_side");
        ResourceLocation frontColored = TextureMapping.m_125753_((Block)block, (String)"_facing_colored");
        ResourceLocation sideColored = TextureMapping.m_125753_((Block)block, (String)"_side_colored");
        ResourceLocation frontUnpowered = TextureMapping.m_125753_((Block)block, (String)"_facing_unpowered");
        ResourceLocation sideUnpowered = TextureMapping.m_125753_((Block)block, (String)"_side_unpowered");
        ResourceLocation frontColoredUnpowered = TextureMapping.m_125753_((Block)block, (String)"_facing_unpowered_colored");
        ResourceLocation sideColoredUnpowered = TextureMapping.m_125753_((Block)block, (String)"_side_unpowered_colored");
        ResourceLocation template = this.modLoc("force_track_emitter");
        BlockModelBuilder modelUnpowered = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block, "_unpowered"), template)).texture("front", frontUnpowered)).texture("side", sideUnpowered)).texture("colored_front", frontColoredUnpowered)).texture("colored_side", sideColoredUnpowered)).texture("particle", sideUnpowered)).renderType(CUTOUT);
        BlockModelBuilder modelPowered = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block, "_powered"), template)).texture("front", front)).texture("side", side)).texture("colored_front", frontColored)).texture("colored_side", sideColored)).texture("particle", side)).renderType(CUTOUT);
        this.horizontalBlockPropertyIgnore((Block)block, blockState -> {
            Boolean powered = (Boolean)blockState.m_61143_((Property)ForceTrackEmitterBlock.POWERED);
            return powered != false ? modelPowered : modelUnpowered;
        }, new Property[]{ForceTrackEmitterBlock.COLOR});
    }

    private void createTurnoutTrack(TurnoutTrackBlock block) {
        ResourceLocation northTexture = TextureMapping.m_125753_((Block)block, (String)"_north");
        ResourceLocation northSwitchedTexture = TextureMapping.m_125753_((Block)block, (String)"_north_switched");
        ResourceLocation southTexture = TextureMapping.m_125753_((Block)block, (String)"_south");
        ResourceLocation southSwitchedTexture = TextureMapping.m_125753_((Block)block, (String)"_south_switched");
        BlockModelBuilder northModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_north"), FLAT_TEMPLATE, "rail", northTexture)).renderType(CUTOUT);
        BlockModelBuilder northSwitchedModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_north_switched"), FLAT_TEMPLATE, "rail", northSwitchedTexture)).renderType(CUTOUT);
        BlockModelBuilder southModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_south"), FLAT_TEMPLATE, "rail", southTexture)).renderType(CUTOUT);
        BlockModelBuilder southSwitchedModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_south_switched"), FLAT_TEMPLATE, "rail", southSwitchedTexture)).renderType(CUTOUT);
        this.getVariantBuilder((Block)block).forAllStatesExcept(blockState -> {
            RailShape shape = (RailShape)blockState.m_61143_(SwitchTrackBlock.SHAPE);
            Boolean reversed = (Boolean)blockState.m_61143_((Property)ReversibleOutfittedTrackBlock.REVERSED);
            Boolean mirrored = (Boolean)blockState.m_61143_((Property)TurnoutTrackBlock.MIRRORED);
            Boolean switched = (Boolean)blockState.m_61143_((Property)SwitchTrackBlock.SWITCHED);
            if (shape == RailShape.NORTH_SOUTH) {
                if (!(reversed.booleanValue() || mirrored.booleanValue() || switched.booleanValue())) {
                    return ConfiguredModel.builder().modelFile((ModelFile)northModel).build();
                }
                if (!reversed.booleanValue() && !mirrored.booleanValue() && switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)northSwitchedModel).build();
                }
                if (reversed.booleanValue() && !mirrored.booleanValue() && !switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)northModel).rotationY(180).build();
                }
                if (reversed.booleanValue() && !mirrored.booleanValue() && switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)northSwitchedModel).rotationY(180).build();
                }
                if (!reversed.booleanValue() && mirrored.booleanValue() && !switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)southModel).rotationY(180).build();
                }
                if (!reversed.booleanValue() && mirrored.booleanValue() && switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)southSwitchedModel).rotationY(180).build();
                }
                if (reversed.booleanValue() && mirrored.booleanValue() && !switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)southModel).build();
                }
                return ConfiguredModel.builder().modelFile((ModelFile)southSwitchedModel).build();
            }
            if (shape == RailShape.EAST_WEST) {
                if (!(reversed.booleanValue() || mirrored.booleanValue() || switched.booleanValue())) {
                    return ConfiguredModel.builder().modelFile((ModelFile)northModel).rotationY(90).build();
                }
                if (!reversed.booleanValue() && !mirrored.booleanValue() && switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)northSwitchedModel).rotationY(90).build();
                }
                if (reversed.booleanValue() && !mirrored.booleanValue() && !switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)northModel).rotationY(270).build();
                }
                if (reversed.booleanValue() && !mirrored.booleanValue() && switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)northSwitchedModel).rotationY(270).build();
                }
                if (!reversed.booleanValue() && mirrored.booleanValue() && !switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)southModel).rotationY(270).build();
                }
                if (!reversed.booleanValue() && mirrored.booleanValue() && switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)southSwitchedModel).rotationY(270).build();
                }
                if (reversed.booleanValue() && mirrored.booleanValue() && !switched.booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)southModel).rotationY(90).build();
                }
                return ConfiguredModel.builder().modelFile((ModelFile)southSwitchedModel).rotationY(90).build();
            }
            return ConfiguredModel.builder().build();
        }, new Property[]{TurnoutTrackBlock.f_152149_});
        this.basicItem((Block)block, "_north");
    }

    private void createWyeTrack(WyeTrackBlock block) {
        ResourceLocation eastTexture = TextureMapping.m_125753_((Block)block, (String)"_east");
        ResourceLocation eastSwitchedTexture = TextureMapping.m_125753_((Block)block, (String)"_east_switched");
        ResourceLocation westTexture = TextureMapping.m_125753_((Block)block, (String)"_west");
        ResourceLocation westSwitchedTexture = TextureMapping.m_125753_((Block)block, (String)"_west_switched");
        BlockModelBuilder eastModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_east"), FLAT_TEMPLATE, "rail", eastTexture)).renderType(CUTOUT);
        BlockModelBuilder eastSwitchedModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_east_switched"), FLAT_TEMPLATE, "rail", eastSwitchedTexture)).renderType(CUTOUT);
        BlockModelBuilder westModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_west"), FLAT_TEMPLATE, "rail", westTexture)).renderType(CUTOUT);
        BlockModelBuilder westSwitchedModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_west_switched"), FLAT_TEMPLATE, "rail", westSwitchedTexture)).renderType(CUTOUT);
        this.getVariantBuilder((Block)block).forAllStatesExcept(blockState -> {
            RailShape railShape = (RailShape)blockState.m_61143_(SwitchTrackBlock.SHAPE);
            Boolean reversed = (Boolean)blockState.m_61143_((Property)ReversibleOutfittedTrackBlock.REVERSED);
            Boolean switched = (Boolean)blockState.m_61143_((Property)SwitchTrackBlock.SWITCHED);
            Direction facing = ReversibleOutfittedTrackBlock.getDirection(railShape, reversed);
            return switch (facing) {
                case Direction.NORTH -> ConfiguredModel.builder().modelFile((ModelFile)(switched != false ? eastSwitchedModel : eastModel)).rotationY(90).build();
                case Direction.SOUTH -> ConfiguredModel.builder().modelFile((ModelFile)(switched != false ? westSwitchedModel : westModel)).rotationY(90).build();
                case Direction.EAST -> ConfiguredModel.builder().modelFile((ModelFile)(switched != false ? westSwitchedModel : westModel)).build();
                case Direction.WEST -> ConfiguredModel.builder().modelFile((ModelFile)(switched != false ? eastSwitchedModel : eastModel)).build();
                default -> throw new UnsupportedOperationException();
            };
        }, new Property[]{WyeTrackBlock.f_152149_});
        this.basicItem((Block)block, "_east");
    }

    private void createJunctionTrack(JunctionTrackBlock block) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), FLAT_TEMPLATE)).texture("rail", TextureMapping.m_125740_((Block)block))).renderType(CUTOUT);
        this.simpleBlock((Block)block, (ModelFile)model);
        this.basicItem((Block)block);
    }

    private void createFlexTrack(TrackBlock block) {
        ResourceLocation blockTexture = TextureMapping.m_125740_((Block)block);
        ResourceLocation cornerTexture = TextureMapping.m_125753_((Block)block, (String)"_corner");
        BlockModelBuilder flatModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block), FLAT_TEMPLATE, "rail", blockTexture)).renderType(CUTOUT);
        BlockModelBuilder cornerModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_corner"), CORNER_TEMPLATE, "rail", cornerTexture)).renderType(CUTOUT);
        BlockModelBuilder raisedNorthEastModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_raised_ne"), RAISED_NE_TEMPLATE, "rail", blockTexture)).renderType(CUTOUT);
        BlockModelBuilder raisedSouthWestModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_raised_sw"), RAISED_SW_TEMPLATE, "rail", blockTexture)).renderType(CUTOUT);
        this.getVariantBuilder((Block)block).forAllStatesExcept(blockState -> {
            RailShape shape = (RailShape)blockState.m_61143_((Property)BlockStateProperties.f_61403_);
            int rotY = 0;
            BlockModelBuilder model = null;
            switch (shape) {
                case NORTH_SOUTH: {
                    model = flatModel;
                    break;
                }
                case EAST_WEST: {
                    model = flatModel;
                    rotY = 90;
                    break;
                }
                case ASCENDING_EAST: {
                    model = raisedNorthEastModel;
                    rotY = 90;
                    break;
                }
                case ASCENDING_WEST: {
                    model = raisedSouthWestModel;
                    rotY = 90;
                    break;
                }
                case ASCENDING_NORTH: {
                    model = raisedNorthEastModel;
                    break;
                }
                case ASCENDING_SOUTH: {
                    model = raisedSouthWestModel;
                    break;
                }
                case SOUTH_EAST: {
                    model = cornerModel;
                    break;
                }
                case SOUTH_WEST: {
                    model = cornerModel;
                    rotY = 90;
                    break;
                }
                case NORTH_WEST: {
                    model = cornerModel;
                    rotY = 180;
                    break;
                }
                case NORTH_EAST: {
                    model = cornerModel;
                    rotY = 270;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(rotY).build();
        }, new Property[]{BlockStateProperties.f_61362_});
        this.basicItem((Block)block);
    }

    private void createAbandonedFlexTrack(TrackBlock block) {
        ResourceLocation texture0 = TextureMapping.m_125753_((Block)block, (String)"_0");
        ResourceLocation texture1 = TextureMapping.m_125753_((Block)block, (String)"_1");
        ResourceLocation cornerTexture = TextureMapping.m_125753_((Block)block, (String)"_corner");
        BlockModelBuilder flatModel0 = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_0"), FLAT_TEMPLATE, "rail", texture0)).renderType(CUTOUT);
        BlockModelBuilder flatModel1 = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_1"), FLAT_TEMPLATE, "rail", texture1)).renderType(CUTOUT);
        BlockModelBuilder cornerModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_corner"), CORNER_TEMPLATE, "rail", cornerTexture)).renderType(CUTOUT);
        BlockModelBuilder raisedNorthEastModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_raised_ne"), RAISED_NE_TEMPLATE, "rail", texture0)).renderType(CUTOUT);
        BlockModelBuilder raisedSouthWestModel = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name((Block)block, "_raised_sw"), RAISED_SW_TEMPLATE, "rail", texture0)).renderType(CUTOUT);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/grass"))).addModel()).condition((Property)AbandonedTrackBlock.GRASS, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)flatModel0).nextModel().modelFile((ModelFile)flatModel1).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile((ModelFile)flatModel0).rotationY(90).nextModel().modelFile((ModelFile)flatModel1).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end().part().modelFile((ModelFile)raisedNorthEastModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.ASCENDING_EAST}).end().part().modelFile((ModelFile)raisedSouthWestModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.ASCENDING_WEST}).end().part().modelFile((ModelFile)raisedNorthEastModel).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.ASCENDING_NORTH}).end().part().modelFile((ModelFile)raisedSouthWestModel).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.ASCENDING_SOUTH}).end().part().modelFile((ModelFile)cornerModel).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.SOUTH_EAST}).end().part().modelFile((ModelFile)cornerModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.SOUTH_WEST}).end().part().modelFile((ModelFile)cornerModel).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.NORTH_WEST}).end().part().modelFile((ModelFile)cornerModel).rotationY(270).addModel()).condition((Property)BlockStateProperties.f_61403_, (Comparable[])new RailShape[]{RailShape.NORTH_EAST}).end();
        this.basicItem((Block)block, "_0");
    }

    private void createAbandonedTracks(TrackBlock block, LockingTrackBlock lockingTrackBlock, BufferStopTrackBlock bufferStopTrackBlock, ActivatorTrackBlock activatorTrackBlock, BoosterTrackBlock boosterTrackBlock, ControlTrackBlock controlTrackBlock, GatedTrackBlock gatedTrackBlock, DetectorTrackBlock detectorTrackBlock, CouplerTrackBlock couplerTrackBlock, EmbarkingTrackBlock embarkingTrackBlock, DisembarkingTrackBlock disembarkingTrackBlock, DumpingTrackBlock dumpingTrackBlock, TurnoutTrackBlock turnoutTrackBlock, WyeTrackBlock wyeTrackBlock, JunctionTrackBlock junctionTrackBlock, LauncherTrackBlock launcherTrackBlock, OneWayTrackBlock oneWayTrackBlock, WhistleTrackBlock whistleTrackBlock, LocomotiveTrackBlock locomotiveTrackBlock, ThrottleTrackBlock throttleTrackBlock, RoutingTrackBlock routingTrackBlock) {
        this.createAbandonedFlexTrack(block);
        this.createOutfittedTracks((Block)block, lockingTrackBlock, bufferStopTrackBlock, activatorTrackBlock, boosterTrackBlock, controlTrackBlock, gatedTrackBlock, detectorTrackBlock, couplerTrackBlock, embarkingTrackBlock, disembarkingTrackBlock, dumpingTrackBlock, turnoutTrackBlock, wyeTrackBlock, junctionTrackBlock, launcherTrackBlock, oneWayTrackBlock, whistleTrackBlock, locomotiveTrackBlock, throttleTrackBlock, routingTrackBlock);
    }

    private void createTracks(TrackBlock block, LockingTrackBlock lockingTrackBlock, BufferStopTrackBlock bufferStopTrackBlock, ActivatorTrackBlock activatorTrackBlock, BoosterTrackBlock boosterTrackBlock, ControlTrackBlock controlTrackBlock, GatedTrackBlock gatedTrackBlock, DetectorTrackBlock detectorTrackBlock, CouplerTrackBlock couplerTrackBlock, EmbarkingTrackBlock embarkingTrackBlock, DisembarkingTrackBlock disembarkingTrackBlock, DumpingTrackBlock dumpingTrackBlock, TurnoutTrackBlock turnoutTrackBlock, WyeTrackBlock wyeTrackBlock, JunctionTrackBlock junctionTrackBlock, LauncherTrackBlock launcherTrackBlock, OneWayTrackBlock oneWayTrackBlock, WhistleTrackBlock whistleTrackBlock, LocomotiveTrackBlock locomotiveTrackBlock, ThrottleTrackBlock throttleTrackBlock, RoutingTrackBlock routingTrackBlock) {
        this.createFlexTrack(block);
        this.createOutfittedTracks((Block)block, lockingTrackBlock, bufferStopTrackBlock, activatorTrackBlock, boosterTrackBlock, controlTrackBlock, gatedTrackBlock, detectorTrackBlock, couplerTrackBlock, embarkingTrackBlock, disembarkingTrackBlock, dumpingTrackBlock, turnoutTrackBlock, wyeTrackBlock, junctionTrackBlock, launcherTrackBlock, oneWayTrackBlock, whistleTrackBlock, locomotiveTrackBlock, throttleTrackBlock, routingTrackBlock);
    }

    private void createOutfittedTracks(Block block, LockingTrackBlock lockingTrackBlock, BufferStopTrackBlock bufferStopTrackBlock, ActivatorTrackBlock activatorTrackBlock, BoosterTrackBlock boosterTrackBlock, ControlTrackBlock controlTrackBlock, GatedTrackBlock gatedTrackBlock, DetectorTrackBlock detectorTrackBlock, CouplerTrackBlock couplerTrackBlock, EmbarkingTrackBlock embarkingTrackBlock, DisembarkingTrackBlock disembarkingTrackBlock, DumpingTrackBlock dumpingTrackBlock, TurnoutTrackBlock turnoutTrackBlock, WyeTrackBlock wyeTrackBlock, JunctionTrackBlock junctionTrackBlock, LauncherTrackBlock launcherTrackBlock, OneWayTrackBlock oneWayTrackBlock, WhistleTrackBlock whistleTrackBlock, LocomotiveTrackBlock locomotiveTrackBlock, ThrottleTrackBlock throttleTrackBlock, RoutingTrackBlock routingTrackBlock) {
        StraightTrackModelSet outfittedTrackModels = this.createOutfittedTrackModelSet(block);
        this.createActiveOutfittedTrack((Block)activatorTrackBlock, true, false, outfittedTrackModels, this.activatorTrackModels, this.activeActivatorTrackModels);
        this.createActiveOutfittedTrack((Block)boosterTrackBlock, true, false, outfittedTrackModels, this.boosterTrackModels, this.activeBoosterTrackModels);
        this.createActiveOutfittedTrack((Block)embarkingTrackBlock, true, false, outfittedTrackModels, this.embarkingTrack, this.activeEmbarkingTrack);
        this.createActiveOutfittedTrack((Block)dumpingTrackBlock, true, false, outfittedTrackModels, this.dumpingTrack, this.activeDumpingTrack);
        this.createActiveOutfittedTrack((Block)launcherTrackBlock, false, false, outfittedTrackModels, this.launcherTrackModels, this.activeLauncherTrackModels);
        this.createActiveOutfittedTrack((Block)oneWayTrackBlock, false, true, outfittedTrackModels, this.oneWayTrackModels, this.activeOneWayTrackModels);
        this.createActiveOutfittedTrack((Block)routingTrackBlock, true, false, outfittedTrackModels, this.routingTrackModels, this.activeRoutingTrackModels);
        this.createActiveOutfittedTrack((Block)whistleTrackBlock, true, false, outfittedTrackModels, this.whistleTrackModels, this.activeWhistleTrackModels);
        this.createDetectorTrack(detectorTrackBlock, outfittedTrackModels, this.detectorTrackModels, this.activeDetectorTrackModels, this.travelDetectorTrackModels, this.activeTravelDetectorTrackModels);
        this.createLocomotiveTrack(locomotiveTrackBlock, outfittedTrackModels, this.locomotiveTrackShutdownModel, this.activeLocomotiveTrackShutdownModel, this.locomotiveTrackIdleModel, this.activeLocomotiveTrackIdleModel, this.locomotiveTrackRunningModel, this.activeLocomotiveTrackRunningModel);
        this.createControlTrack(controlTrackBlock, outfittedTrackModels, this.controlTrackModels);
        this.createGatedTrack(gatedTrackBlock, outfittedTrackModels, this.controlTrackModels);
        this.createCouplerTrack(couplerTrackBlock, outfittedTrackModels, this.couplerTrackCoupler, this.activeCouplerTrackCoupler, this.couplerTrackDecoupler, this.activeCouplerTrackDecoupler, this.couplerTrackAutoCoupler, this.activeCouplerTrackAutoCoupler);
        this.createDisembarkingTrack(disembarkingTrackBlock, outfittedTrackModels, this.disembarkingTrackLeft, this.activeDisembarkingTrackLeft, this.disembarkingTrackRight, this.activeDisembarkingTrackRight);
        this.createLockingTrack(lockingTrackBlock, outfittedTrackModels.flatModel());
        this.createThrottleTrack(throttleTrackBlock, outfittedTrackModels.flatModel());
        this.createBufferStopTrack(bufferStopTrackBlock, outfittedTrackModels.flatModel());
        this.createTurnoutTrack(turnoutTrackBlock);
        this.createWyeTrack(wyeTrackBlock);
        this.createJunctionTrack(junctionTrackBlock);
    }

    private void createHighSpeedTracks(TrackBlock block, TransitionTrackBlock transitionTrackBlock, LockingTrackBlock lockingTrackBlock, ActivatorTrackBlock activatorTrackBlock, BoosterTrackBlock boosterTrackBlock, DetectorTrackBlock detectorTrackBlock, TurnoutTrackBlock turnoutTrackBlock, WyeTrackBlock wyeTrackBlock, JunctionTrackBlock junctionTrackBlock, WhistleTrackBlock whistleTrackBlock, LocomotiveTrackBlock locomotiveTrackBlock, ThrottleTrackBlock throttleTrackBlock) {
        this.createFlexTrack(block);
        StraightTrackModelSet outfittedTrackModels = this.createOutfittedTrackModelSet((Block)block);
        this.createActiveOutfittedTrack((Block)activatorTrackBlock, true, false, outfittedTrackModels, this.activatorTrackModels, this.activeActivatorTrackModels);
        this.createActiveOutfittedTrack((Block)boosterTrackBlock, true, false, outfittedTrackModels, this.boosterTrackModels, this.activeBoosterTrackModels);
        this.createActiveOutfittedTrack((Block)transitionTrackBlock, true, true, outfittedTrackModels, this.transitionTrackModels, this.activeTransitionTrackModels);
        this.createActiveOutfittedTrack((Block)whistleTrackBlock, true, false, outfittedTrackModels, this.whistleTrackModels, this.activeWhistleTrackModels);
        this.createDetectorTrack(detectorTrackBlock, outfittedTrackModels, this.detectorTrackModels, this.activeDetectorTrackModels, this.travelDetectorTrackModels, this.activeTravelDetectorTrackModels);
        this.createLocomotiveTrack(locomotiveTrackBlock, outfittedTrackModels, this.locomotiveTrackShutdownModel, this.activeLocomotiveTrackShutdownModel, this.locomotiveTrackIdleModel, this.activeLocomotiveTrackIdleModel, this.locomotiveTrackRunningModel, this.activeLocomotiveTrackRunningModel);
        this.createLockingTrack(lockingTrackBlock, outfittedTrackModels.flatModel());
        this.createThrottleTrack(throttleTrackBlock, outfittedTrackModels.flatModel());
        this.createTurnoutTrack(turnoutTrackBlock);
        this.createWyeTrack(wyeTrackBlock);
        this.createJunctionTrack(junctionTrackBlock);
    }

    private void createLockingTrack(LockingTrackBlock block, ModelFile trackModel) {
        BlockModelBuilder lockdownModel = this.createPassiveRail("locking_track_lockdown");
        BlockModelBuilder trainLockdownModel = this.createPassiveRail("locking_track_train_lockdown");
        BlockModelBuilder holdingModel = this.createPassiveRail("locking_track_holding");
        BlockModelBuilder trainHoldingModel = this.createPassiveRail("locking_track_train_holding");
        BlockModelBuilder boardingModel = this.createPassiveRail("locking_track_boarding");
        BlockModelBuilder boardingReversedModel = this.createPassiveRail("locking_track_boarding_reversed");
        BlockModelBuilder trainBoardingModel = this.createPassiveRail("locking_track_train_boarding");
        BlockModelBuilder trainBoardingReversedModel = this.createPassiveRail("locking_track_train_boarding_reversed");
        BlockModelBuilder activeLockdownModel = this.createActiveRail("locking_track_lockdown");
        BlockModelBuilder activeTrainLockdownModel = this.createActiveRail("locking_track_train_lockdown");
        BlockModelBuilder activeHoldingModel = this.createActiveRail("locking_track_holding");
        BlockModelBuilder activeTrainHoldingModel = this.createActiveRail("locking_track_train_holding");
        BlockModelBuilder activeBoardingModel = this.createActiveRail("locking_track_boarding");
        BlockModelBuilder activeBoardingReversedModel = this.createActiveRail("locking_track_boarding_reversed");
        BlockModelBuilder activeTrainBoardingModel = this.createActiveRail("locking_track_train_boarding");
        BlockModelBuilder activeTrainBoardingReversedModel = this.createActiveRail("locking_track_train_boarding_reversed");
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(trackModel).addModel()).condition((Property)LockingTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile(trackModel).rotationY(90).addModel()).condition((Property)LockingTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end();
        this.addLockingMode(LockingMode.LOCKDOWN, lockdownModel, activeLockdownModel, builder);
        this.addLockingMode(LockingMode.TRAIN_LOCKDOWN, trainLockdownModel, activeTrainLockdownModel, builder);
        this.addLockingMode(LockingMode.HOLDING, holdingModel, activeHoldingModel, builder);
        this.addLockingMode(LockingMode.TRAIN_HOLDING, trainHoldingModel, activeTrainHoldingModel, builder);
        this.addLockingMode(LockingMode.BOARDING, boardingModel, activeBoardingModel, builder);
        this.addLockingMode(LockingMode.BOARDING_REVERSED, boardingReversedModel, activeBoardingReversedModel, builder);
        this.addLockingMode(LockingMode.TRAIN_BOARDING, trainBoardingModel, activeTrainBoardingModel, builder);
        this.addLockingMode(LockingMode.TRAIN_BOARDING_REVERSED, trainBoardingReversedModel, activeTrainBoardingReversedModel, builder);
        this.itemModels().basicItem(block.m_5456_());
    }

    private void addLockingMode(LockingMode lockingMode, BlockModelBuilder model, BlockModelBuilder poweredModel, MultiPartBlockStateBuilder builder) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).addModel()).condition(LockingTrackBlock.LOCKING_MODE, (Comparable[])new LockingMode[]{lockingMode}).condition((Property)LockingTrackBlock.POWERED, (Comparable[])new Boolean[]{false}).condition((Property)LockingTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile((ModelFile)poweredModel).addModel()).condition(LockingTrackBlock.LOCKING_MODE, (Comparable[])new LockingMode[]{lockingMode}).condition((Property)LockingTrackBlock.POWERED, (Comparable[])new Boolean[]{true}).condition((Property)LockingTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile((ModelFile)model).rotationY(90).addModel()).condition(LockingTrackBlock.LOCKING_MODE, (Comparable[])new LockingMode[]{lockingMode}).condition((Property)LockingTrackBlock.POWERED, (Comparable[])new Boolean[]{false}).condition((Property)LockingTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end().part().modelFile((ModelFile)poweredModel).rotationY(90).addModel()).condition(LockingTrackBlock.LOCKING_MODE, (Comparable[])new LockingMode[]{lockingMode}).condition((Property)LockingTrackBlock.POWERED, (Comparable[])new Boolean[]{true}).condition((Property)LockingTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end();
    }

    private void createThrottleTrack(ThrottleTrackBlock block, ModelFile trackModel) {
        BlockModelBuilder speed1 = this.createPassiveRail("throttle_track_1");
        BlockModelBuilder speed2 = this.createPassiveRail("throttle_track_2");
        BlockModelBuilder speed3 = this.createPassiveRail("throttle_track_3");
        BlockModelBuilder speed4 = this.createPassiveRail("throttle_track_4");
        BlockModelBuilder speed1Reverse = this.createPassiveRail("throttle_track_1_reverse");
        BlockModelBuilder speed2Reverse = this.createPassiveRail("throttle_track_2_reverse");
        BlockModelBuilder speed3Reverse = this.createPassiveRail("throttle_track_3_reverse");
        BlockModelBuilder speed4Reverse = this.createPassiveRail("throttle_track_4_reverse");
        BlockModelBuilder activeSpeed1 = this.createActiveRail("throttle_track_1");
        BlockModelBuilder activeSpeed2 = this.createActiveRail("throttle_track_2");
        BlockModelBuilder activeSpeed3 = this.createActiveRail("throttle_track_3");
        BlockModelBuilder activeSpeed4 = this.createActiveRail("throttle_track_4");
        BlockModelBuilder activeSpeed1Reverse = this.createActiveRail("throttle_track_1_reverse");
        BlockModelBuilder activeSpeed2Reverse = this.createActiveRail("throttle_track_2_reverse");
        BlockModelBuilder activeSpeed3Reverse = this.createActiveRail("throttle_track_3_reverse");
        BlockModelBuilder activeSpeed4Reverse = this.createActiveRail("throttle_track_4_reverse");
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(trackModel).addModel()).condition((Property)LockingTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile(trackModel).rotationY(90).addModel()).condition((Property)LockingTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end();
        this.addSpeedMode(Locomotive.Speed.SLOWEST, speed1, activeSpeed1, false, builder);
        this.addSpeedMode(Locomotive.Speed.SLOWER, speed2, activeSpeed2, false, builder);
        this.addSpeedMode(Locomotive.Speed.NORMAL, speed3, activeSpeed3, false, builder);
        this.addSpeedMode(Locomotive.Speed.MAX, speed4, activeSpeed4, false, builder);
        this.addSpeedMode(Locomotive.Speed.SLOWEST, speed1Reverse, activeSpeed1Reverse, true, builder);
        this.addSpeedMode(Locomotive.Speed.SLOWER, speed2Reverse, activeSpeed2Reverse, true, builder);
        this.addSpeedMode(Locomotive.Speed.NORMAL, speed3Reverse, activeSpeed3Reverse, true, builder);
        this.addSpeedMode(Locomotive.Speed.MAX, speed4Reverse, activeSpeed4Reverse, true, builder);
        this.itemModels().basicItem(block.m_5456_());
    }

    private void addSpeedMode(Locomotive.Speed speed, BlockModelBuilder model, BlockModelBuilder poweredModel, boolean reverse, MultiPartBlockStateBuilder builder) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).addModel()).condition(ThrottleTrackBlock.LOCOMOTIVE_SPEED, (Comparable[])new Locomotive.Speed[]{speed}).condition((Property)ThrottleTrackBlock.REVERSE, (Comparable[])new Boolean[]{reverse}).condition((Property)ThrottleTrackBlock.POWERED, (Comparable[])new Boolean[]{false}).condition((Property)ThrottleTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile((ModelFile)poweredModel).addModel()).condition(ThrottleTrackBlock.LOCOMOTIVE_SPEED, (Comparable[])new Locomotive.Speed[]{speed}).condition((Property)ThrottleTrackBlock.REVERSE, (Comparable[])new Boolean[]{reverse}).condition((Property)ThrottleTrackBlock.POWERED, (Comparable[])new Boolean[]{true}).condition((Property)ThrottleTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile((ModelFile)model).rotationY(90).addModel()).condition(ThrottleTrackBlock.LOCOMOTIVE_SPEED, (Comparable[])new Locomotive.Speed[]{speed}).condition((Property)ThrottleTrackBlock.REVERSE, (Comparable[])new Boolean[]{reverse}).condition((Property)ThrottleTrackBlock.POWERED, (Comparable[])new Boolean[]{false}).condition((Property)ThrottleTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end().part().modelFile((ModelFile)poweredModel).rotationY(90).addModel()).condition(ThrottleTrackBlock.LOCOMOTIVE_SPEED, (Comparable[])new Locomotive.Speed[]{speed}).condition((Property)ThrottleTrackBlock.REVERSE, (Comparable[])new Boolean[]{reverse}).condition((Property)ThrottleTrackBlock.POWERED, (Comparable[])new Boolean[]{true}).condition((Property)ThrottleTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end();
    }

    private void createBufferStopTrack(BufferStopTrackBlock block, ModelFile trackModel) {
        ModelFile.UncheckedModelFile bufferStop = new ModelFile.UncheckedModelFile(this.modLoc("block/buffer_stop"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile((ModelFile)bufferStop).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)bufferStop).rotationY(180).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)bufferStop).rotationY(90).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)bufferStop).rotationY(270).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{true}).end().part().modelFile(trackModel).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile(trackModel).rotationY(90).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end();
        this.itemModels().basicItem(block.m_5456_());
    }

    private void createActiveOutfittedTrack(Block block, boolean allowedOnSlopes, boolean reversible, StraightTrackModelSet trackModels, StraightTrackModelSet trackKitModels, StraightTrackModelSet activeTrackKitModels) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        trackModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, allowedOnSlopes, false);
        if (reversible) {
            trackKitModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, allowedOnSlopes, false, (Condition)Condition.m_125135_().m_125176_((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable)Boolean.valueOf(false)).m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            activeTrackKitModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, allowedOnSlopes, false, (Condition)Condition.m_125135_().m_125176_((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable)Boolean.valueOf(false)).m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            trackKitModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, allowedOnSlopes, true, (Condition)Condition.m_125135_().m_125176_((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable)Boolean.valueOf(true)).m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            activeTrackKitModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, allowedOnSlopes, true, (Condition)Condition.m_125135_().m_125176_((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable)Boolean.valueOf(true)).m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        } else {
            trackKitModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, allowedOnSlopes, false, (Condition)Condition.m_125135_().m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            activeTrackKitModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, allowedOnSlopes, false, (Condition)Condition.m_125135_().m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        }
        this.itemModels().basicItem(block.m_5456_());
    }

    private void createDetectorTrack(DetectorTrackBlock block, StraightTrackModelSet trackModels, StraightTrackModelSet detectorTrackModels, StraightTrackModelSet activeDetectorTrackModels, StraightTrackModelSet travelDetectorTrackModels, StraightTrackModelSet activeTravelDetectorTrackModels) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        trackModels.apply(builder, (Property<RailShape>)DetectorTrackBlock.SHAPE, true, false);
        detectorTrackModels.apply(builder, (Property<RailShape>)DetectorTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(DetectorTrackBlock.MODE, (Comparable)((Object)DetectorTrackBlock.Mode.BI_DIRECTIONAL)).m_125176_((Property)DetectorTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        activeDetectorTrackModels.apply(builder, (Property<RailShape>)DetectorTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(DetectorTrackBlock.MODE, (Comparable)((Object)DetectorTrackBlock.Mode.BI_DIRECTIONAL)).m_125176_((Property)DetectorTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        travelDetectorTrackModels.apply(builder, (Property<RailShape>)DetectorTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(DetectorTrackBlock.MODE, (Comparable)((Object)DetectorTrackBlock.Mode.TRAVEL)).m_125176_((Property)DetectorTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        activeTravelDetectorTrackModels.apply(builder, (Property<RailShape>)DetectorTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(DetectorTrackBlock.MODE, (Comparable)((Object)DetectorTrackBlock.Mode.TRAVEL)).m_125176_((Property)DetectorTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        travelDetectorTrackModels.apply(builder, (Property<RailShape>)DetectorTrackBlock.SHAPE, true, true, (Condition)Condition.m_125135_().m_125176_(DetectorTrackBlock.MODE, (Comparable)((Object)DetectorTrackBlock.Mode.TRAVEL_REVERSED)).m_125176_((Property)DetectorTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        activeTravelDetectorTrackModels.apply(builder, (Property<RailShape>)DetectorTrackBlock.SHAPE, true, true, (Condition)Condition.m_125135_().m_125176_(DetectorTrackBlock.MODE, (Comparable)((Object)DetectorTrackBlock.Mode.TRAVEL_REVERSED)).m_125176_((Property)DetectorTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.itemModels().basicItem(block.m_5456_());
    }

    private void createLocomotiveTrack(LocomotiveTrackBlock block, StraightTrackModelSet trackModel, StraightTrackModelSet locomotiveTrackShutdownModel, StraightTrackModelSet activeLocomotiveTrackShutdownModel, StraightTrackModelSet locomotiveTrackIdleModel, StraightTrackModelSet activeLocomotiveTrackIdleModel, StraightTrackModelSet locomotiveTrackRunningModel, StraightTrackModelSet activeLocomotiveTrackRunningModel) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        trackModel.apply(builder, (Property<RailShape>)LocomotiveTrackBlock.SHAPE, true, false);
        this.addLocomotiveMode(builder, Locomotive.Mode.SHUTDOWN, locomotiveTrackShutdownModel, activeLocomotiveTrackShutdownModel);
        this.addLocomotiveMode(builder, Locomotive.Mode.IDLE, locomotiveTrackIdleModel, activeLocomotiveTrackIdleModel);
        this.addLocomotiveMode(builder, Locomotive.Mode.RUNNING, locomotiveTrackRunningModel, activeLocomotiveTrackRunningModel);
        this.itemModels().basicItem(block.m_5456_());
    }

    private void addLocomotiveMode(MultiPartBlockStateBuilder builder, Locomotive.Mode locomotiveMode, StraightTrackModelSet model, StraightTrackModelSet poweredModel) {
        model.apply(builder, (Property<RailShape>)LocomotiveTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(LocomotiveTrackBlock.LOCOMOTIVE_MODE, (Comparable)((Object)locomotiveMode)).m_125176_((Property)LocomotiveTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        poweredModel.apply(builder, (Property<RailShape>)LocomotiveTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(LocomotiveTrackBlock.LOCOMOTIVE_MODE, (Comparable)((Object)locomotiveMode)).m_125176_((Property)LocomotiveTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
    }

    private void createControlTrack(ControlTrackBlock block, StraightTrackModelSet trackModels, StraightTrackModelSet controlTrackModels) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        trackModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, true, false);
        controlTrackModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)).m_125176_((Property)ControlTrackBlock.REVERSED, (Comparable)Boolean.valueOf(false)));
        controlTrackModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)).m_125176_((Property)ControlTrackBlock.REVERSED, (Comparable)Boolean.valueOf(true)));
        controlTrackModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, true, true, (Condition)Condition.m_125135_().m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)).m_125176_((Property)ControlTrackBlock.REVERSED, (Comparable)Boolean.valueOf(false)));
        controlTrackModels.apply(builder, (Property<RailShape>)OutfittedTrackBlock.SHAPE, true, true, (Condition)Condition.m_125135_().m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)).m_125176_((Property)ControlTrackBlock.REVERSED, (Comparable)Boolean.valueOf(true)));
        this.itemModels().basicItem(block.m_5456_());
    }

    private void createGatedTrack(GatedTrackBlock block, StraightTrackModelSet trackModels, StraightTrackModelSet controlTrackModels) {
        ModelFile.UncheckedModelFile closedGateModel = new ModelFile.UncheckedModelFile(ModelLocationUtils.m_125576_((Block)Blocks.f_50192_));
        ModelFile.UncheckedModelFile openGateModel = new ModelFile.UncheckedModelFile(ModelLocationUtils.m_125578_((Block)Blocks.f_50192_, (String)"_open"));
        ModelFile.UncheckedModelFile closedWallGateModel = new ModelFile.UncheckedModelFile(ModelLocationUtils.m_125578_((Block)Blocks.f_50192_, (String)"_wall"));
        ModelFile.UncheckedModelFile openWallGateModel = new ModelFile.UncheckedModelFile(ModelLocationUtils.m_125578_((Block)Blocks.f_50192_, (String)"_wall_open"));
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(trackModels.flatModel()).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).end().part().modelFile(trackModels.flatModel()).rotationY(90).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).end().part().modelFile(controlTrackModels.flatModel()).addModel()).condition((Property)GatedTrackBlock.ONE_WAY, (Comparable[])new Boolean[]{true}).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{false}).end().part().modelFile(controlTrackModels.flatModel()).rotationY(180).addModel()).condition((Property)GatedTrackBlock.ONE_WAY, (Comparable[])new Boolean[]{true}).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{true}).end().part().modelFile(controlTrackModels.flatModel()).rotationY(90).addModel()).condition((Property)GatedTrackBlock.ONE_WAY, (Comparable[])new Boolean[]{true}).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{false}).end().part().modelFile(controlTrackModels.flatModel()).rotationY(270).addModel()).condition((Property)GatedTrackBlock.ONE_WAY, (Comparable[])new Boolean[]{true}).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{true}).end();
        this.addGateVariants(builder, false, false, (ModelFile)closedGateModel);
        this.addGateVariants(builder, true, false, (ModelFile)openGateModel);
        this.addGateVariants(builder, false, true, (ModelFile)closedWallGateModel);
        this.addGateVariants(builder, true, true, (ModelFile)openWallGateModel);
        this.itemModels().basicItem(block.m_5456_());
    }

    private void addGateVariants(MultiPartBlockStateBuilder builder, boolean open, boolean inWall, ModelFile model) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model).rotationY(180).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{false}).condition((Property)GatedTrackBlock.OPEN, (Comparable[])new Boolean[]{open}).condition((Property)GatedTrackBlock.IN_WALL, (Comparable[])new Boolean[]{inWall}).end().part().modelFile(model).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{true}).condition((Property)GatedTrackBlock.OPEN, (Comparable[])new Boolean[]{open}).condition((Property)GatedTrackBlock.IN_WALL, (Comparable[])new Boolean[]{inWall}).end().part().modelFile(model).rotationY(270).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{false}).condition((Property)GatedTrackBlock.OPEN, (Comparable[])new Boolean[]{open}).condition((Property)GatedTrackBlock.IN_WALL, (Comparable[])new Boolean[]{inWall}).end().part().modelFile(model).rotationY(90).addModel()).condition(OutfittedTrackBlock.SHAPE, (Comparable[])new RailShape[]{RailShape.EAST_WEST}).condition((Property)ReversibleOutfittedTrackBlock.REVERSED, (Comparable[])new Boolean[]{true}).condition((Property)GatedTrackBlock.OPEN, (Comparable[])new Boolean[]{open}).condition((Property)GatedTrackBlock.IN_WALL, (Comparable[])new Boolean[]{inWall}).end();
    }

    private void createCouplerTrack(CouplerTrackBlock block, StraightTrackModelSet trackModels, StraightTrackModelSet couplerTrackCoupler, StraightTrackModelSet activeCouplerTrackCoupler, StraightTrackModelSet couplerTrackDecoupler, StraightTrackModelSet activeCouplerTrackDecoupler, StraightTrackModelSet couplerTrackAutoCoupler, StraightTrackModelSet activeCouplerTrackAutoCoupler) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        trackModels.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false);
        couplerTrackCoupler.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(CouplerTrackBlock.MODE, (Comparable)((Object)CouplerTrackBlockEntity.Mode.COUPLER)).m_125176_((Property)CouplerTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        activeCouplerTrackCoupler.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(CouplerTrackBlock.MODE, (Comparable)((Object)CouplerTrackBlockEntity.Mode.COUPLER)).m_125176_((Property)CouplerTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        couplerTrackDecoupler.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(CouplerTrackBlock.MODE, (Comparable)((Object)CouplerTrackBlockEntity.Mode.DECOUPLER)).m_125176_((Property)CouplerTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        activeCouplerTrackDecoupler.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(CouplerTrackBlock.MODE, (Comparable)((Object)CouplerTrackBlockEntity.Mode.DECOUPLER)).m_125176_((Property)CouplerTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        couplerTrackAutoCoupler.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(CouplerTrackBlock.MODE, (Comparable)((Object)CouplerTrackBlockEntity.Mode.AUTO_COUPLER)).m_125176_((Property)CouplerTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        activeCouplerTrackAutoCoupler.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_(CouplerTrackBlock.MODE, (Comparable)((Object)CouplerTrackBlockEntity.Mode.AUTO_COUPLER)).m_125176_((Property)CouplerTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.itemModels().basicItem(block.m_5456_());
    }

    private void createDisembarkingTrack(DisembarkingTrackBlock block, StraightTrackModelSet trackModels, StraightTrackModelSet disembarkingTrackLeft, StraightTrackModelSet activeDisembarkingTrackLeft, StraightTrackModelSet disembarkingTrackRight, StraightTrackModelSet activeDisembarkingTrackRight) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        trackModels.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false);
        disembarkingTrackLeft.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_((Property)DisembarkingTrackBlock.MIRRORED, (Comparable)Boolean.valueOf(false)).m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        activeDisembarkingTrackLeft.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_((Property)DisembarkingTrackBlock.MIRRORED, (Comparable)Boolean.valueOf(false)).m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        disembarkingTrackRight.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_((Property)DisembarkingTrackBlock.MIRRORED, (Comparable)Boolean.valueOf(true)).m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        activeDisembarkingTrackRight.apply(builder, (Property<RailShape>)CouplerTrackBlock.SHAPE, true, false, (Condition)Condition.m_125135_().m_125176_((Property)DisembarkingTrackBlock.MIRRORED, (Comparable)Boolean.valueOf(true)).m_125176_((Property)PoweredOutfittedTrackBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.itemModels().basicItem(block.m_5456_());
    }

    private BlockModelBuilder createVariant(String name, ModelTemplate model) {
        ResourceLocation texture = this.modLoc("block/" + name);
        String modelName = name + model.f_125587_.orElse("");
        ResourceLocation parent = (ResourceLocation)model.f_125585_.orElseThrow();
        return (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(modelName, parent, "rail", texture)).renderType(CUTOUT);
    }

    private BlockModelBuilder createPassiveRail(String name) {
        return this.createVariant(name, ModelTemplates.f_125643_);
    }

    private BlockModelBuilder createActiveRail(String name) {
        return this.createVariant(name + "_on", ModelTemplates.f_125643_);
    }

    private StraightTrackModelSet createOutfittedTrackModelSet(Block block) {
        return this.createTrackModelSet(this.name(block, "_outfitted"));
    }

    private StraightTrackModelSet createTrackModelSet(String name) {
        return new StraightTrackModelSet((ModelFile)this.createPassiveRail(name), (ModelFile)this.createVariant(name, ModelTemplates.f_125645_), (ModelFile)this.createVariant(name, ModelTemplates.f_125646_));
    }

    private StraightTrackModelSet createActiveTrackModelSet(String name) {
        return new StraightTrackModelSet((ModelFile)this.createActiveRail(name), (ModelFile)this.createVariant(name + "_on", ModelTemplates.f_125645_), (ModelFile)this.createVariant(name + "_on", ModelTemplates.f_125646_));
    }

    private record StraightTrackModelSet(ModelFile flatModel, ModelFile raisedNorthEastModel, ModelFile raisedSouthWestModel) {
        private static MultiPartBlockStateBuilder.PartBuilder conditions(MultiPartBlockStateBuilder.PartBuilder.ConditionGroup partialBuilder, @Nullable Condition conditions) {
            if (conditions instanceof Condition.CompositeCondition) {
                Condition.CompositeCondition compositeCondition = (Condition.CompositeCondition)conditions;
                for (Condition sub : compositeCondition.f_125140_) {
                    StraightTrackModelSet.conditions(partialBuilder, sub);
                }
                return partialBuilder.end();
            }
            if (conditions instanceof Condition.TerminalCondition) {
                Condition.TerminalCondition terminalCondition = (Condition.TerminalCondition)conditions;
                terminalCondition.f_125169_.forEach((key, value) -> key.m_6215_(value).ifPresent(v -> partialBuilder.conditions.put(key, v)));
            }
            return partialBuilder.end();
        }

        private void apply(MultiPartBlockStateBuilder builder, Property<RailShape> shapeProperty, boolean includeRaised, boolean reversed) {
            this.apply(builder, shapeProperty, includeRaised, reversed, null);
        }

        private void apply(MultiPartBlockStateBuilder builder, Property<RailShape> shapeProperty, boolean includeRaised, boolean reversed, @Nullable Condition conditions) {
            MultiPartBlockStateBuilder.PartBuilder.ConditionGroup partialBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.flatModel).rotationY(reversed ? 180 : 0).addModel()).nestedGroup().condition(shapeProperty, (Comparable[])new RailShape[]{RailShape.NORTH_SOUTH});
            partialBuilder = ((MultiPartBlockStateBuilder.PartBuilder)StraightTrackModelSet.conditions(partialBuilder, conditions).end().part().modelFile(this.flatModel).rotationY(reversed ? 270 : 90).addModel()).nestedGroup().condition(shapeProperty, (Comparable[])new RailShape[]{RailShape.EAST_WEST});
            builder = StraightTrackModelSet.conditions(partialBuilder, conditions).end();
            if (includeRaised) {
                partialBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(reversed ? this.raisedSouthWestModel : this.raisedNorthEastModel).rotationY(reversed ? 180 : 0).addModel()).nestedGroup().condition(shapeProperty, (Comparable[])new RailShape[]{RailShape.ASCENDING_NORTH});
                partialBuilder = ((MultiPartBlockStateBuilder.PartBuilder)StraightTrackModelSet.conditions(partialBuilder, conditions).end().part().modelFile(reversed ? this.raisedNorthEastModel : this.raisedSouthWestModel).rotationY(reversed ? 180 : 0).addModel()).nestedGroup().condition(shapeProperty, (Comparable[])new RailShape[]{RailShape.ASCENDING_SOUTH});
                partialBuilder = ((MultiPartBlockStateBuilder.PartBuilder)StraightTrackModelSet.conditions(partialBuilder, conditions).end().part().modelFile(reversed ? this.raisedSouthWestModel : this.raisedNorthEastModel).rotationY(reversed ? 270 : 90).addModel()).nestedGroup().condition(shapeProperty, (Comparable[])new RailShape[]{RailShape.ASCENDING_EAST});
                partialBuilder = ((MultiPartBlockStateBuilder.PartBuilder)StraightTrackModelSet.conditions(partialBuilder, conditions).end().part().modelFile(reversed ? this.raisedNorthEastModel : this.raisedSouthWestModel).rotationY(reversed ? 270 : 90).addModel()).nestedGroup().condition(shapeProperty, (Comparable[])new RailShape[]{RailShape.ASCENDING_WEST});
                builder = StraightTrackModelSet.conditions(partialBuilder, conditions).end();
            }
        }
    }
}

