/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class RenderUtil {
    public static final int FULL_LIGHT = 0xF000F0;
    public static final float PIXEL = 0.0625f;
    public static final float SCALED_PIXEL = 0.00390625f;
    private static final Minecraft minecraft = Minecraft.m_91087_();

    public static int getColorARGB(FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        int color = RenderUtil.getColorARGB(fluidStack);
        if (fluidStack.getFluid().getFluidType().isLighterThanAir()) {
            return RenderUtil.getColorARGB(RenderUtil.getRed(color), RenderUtil.getGreen(color), RenderUtil.getBlue(color), Math.min(1.0f, fluidScale + 0.2f));
        }
        return color;
    }

    public static int getColorARGB(FluidStack fluidStack) {
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static int getColorARGB(float red, float green, float blue, float alpha) {
        return RenderUtil.getColorARGB((int)(255.0f * red), (int)(255.0f * green), (int)(255.0f * blue), alpha);
    }

    public static int getColorARGB(int red, int green, int blue, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        int argb = (int)(255.0f * alpha) << 24;
        argb |= red << 16;
        argb |= green << 8;
        return argb |= blue;
    }

    public static int calculateGlowLight(int combinedLight, FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : RenderUtil.calculateGlowLight(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void renderBlockHoverText(BlockPos blockPos, Component text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (RenderUtil.minecraft.f_91077_ != null && RenderUtil.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)RenderUtil.minecraft.f_91077_).m_82425_().equals((Object)blockPos)) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.5, 0.5);
            RenderUtil.renderWorldText(RenderUtil.minecraft.f_91062_, text, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }

    public static void renderWorldText(Font font, Component text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(RenderUtil.minecraft.f_91063_.m_109153_().m_253121_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float backgroundOpacity = RenderUtil.minecraft.f_91066_.m_92141_(0.25f);
        int packedOverlay = (int)(backgroundOpacity * 255.0f) << 24;
        float x = -font.m_92852_((FormattedText)text) / 2;
        font.m_272077_(text, x, 0.0f, 0x20FFFFFF, false, matrix, bufferSource, Font.DisplayMode.SEE_THROUGH, packedOverlay, packedLight);
        font.m_272077_(text, x, 0.0f, -1, false, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }
}

