/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.client.model.DeformableMinecartModel;
import mods.railcraft.client.model.MaintenanceLampModel;
import mods.railcraft.client.model.MaintenanceModel;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.renderer.entity.cart.ContentsMinecartRenderer;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public abstract class MaintenanceMinecartRenderer
extends ContentsMinecartRenderer<MaintenanceMinecart> {
    private static final ResourceLocation LAMP_ON_TEX = new ResourceLocation("railcraft", "textures/entity/minecart/maintenance_lamp_on.png");
    private static final ResourceLocation LAMP_OFF_TEX = new ResourceLocation("railcraft", "textures/entity/minecart/maintenance_lamp_off.png");
    private static final ResourceLocation LAMP_DISABLED_TEX = new ResourceLocation("railcraft", "textures/entity/minecart/maintenance_lamp_disabled.png");
    private final ResourceLocation maintenanceTextureLocation;
    private final MinecartModel<MaintenanceMinecart> bodyModel;
    private final DeformableMinecartModel<MaintenanceMinecart> snowModel;
    private final Model maintenanceModel;
    private final Model lampModel;

    public MaintenanceMinecartRenderer(EntityRendererProvider.Context context, ResourceLocation maintenanceTextureLocation) {
        super(context);
        this.maintenanceTextureLocation = maintenanceTextureLocation;
        this.bodyModel = new MinecartModel(context.m_174023_(ModelLayers.f_171198_));
        this.snowModel = new DeformableMinecartModel(context.m_174023_(RailcraftModelLayers.MINECART_SNOW));
        this.maintenanceModel = new MaintenanceModel(context.m_174023_(RailcraftModelLayers.MAINTENANCE));
        this.lampModel = new MaintenanceLampModel(context.m_174023_(RailcraftModelLayers.MAINTENANCE_LAMP));
    }

    @Override
    public void renderContents(MaintenanceMinecart cart, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float red, float green, float blue, float alpha) {
        VertexConsumer maintenanceVertexConsumer = bufferSource.m_6299_(this.maintenanceModel.m_103119_(this.maintenanceTextureLocation));
        this.maintenanceModel.m_7695_(poseStack, maintenanceVertexConsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, alpha);
        poseStack.m_85836_();
        boolean blinking = cart.isBlinking();
        ResourceLocation textureLocation = blinking ? LAMP_ON_TEX : (cart.mode() == MaintenanceMinecart.Mode.OFF ? LAMP_DISABLED_TEX : LAMP_OFF_TEX);
        VertexConsumer lampVertexConsumer = bufferSource.m_6299_(this.lampModel.m_103119_(textureLocation));
        this.lampModel.m_7695_(poseStack, lampVertexConsumer, blinking ? 0xF000F0 : packedLight, OverlayTexture.f_118083_, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    @Override
    protected EntityModel<? super MaintenanceMinecart> getBodyModel(MaintenanceMinecart cart) {
        return this.bodyModel;
    }

    @Override
    protected EntityModel<? super MaintenanceMinecart> getSnowModel(MaintenanceMinecart cart) {
        return this.snowModel;
    }
}

