/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mods.railcraft.api.signal.BlockSignalEntity;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.TokenSignalEntity;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.world.item.GogglesItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SignalAuraRenderUtil {
    private static final Minecraft minecraft = Minecraft.m_91087_();

    public static void tryRenderSignalAura(BlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (blockEntity instanceof SignalControllerEntity) {
            SignalControllerEntity provider = (SignalControllerEntity)blockEntity;
            Collection<BlockPos> peers = provider.getSignalController().peers();
            if (GogglesItem.isGoggleAuraActive((Player)SignalAuraRenderUtil.minecraft.f_91074_, GogglesItem.Aura.TUNING)) {
                SignalAuraRenderUtil.renderSignalAura(blockEntity, poseStack, bufferSource, peers, ColorProfile.COORD_RAINBOW);
            } else if (GogglesItem.isGoggleAuraActive((Player)SignalAuraRenderUtil.minecraft.f_91074_, GogglesItem.Aura.SIGNALLING)) {
                SignalAuraRenderUtil.renderSignalAura(blockEntity, poseStack, bufferSource, peers, ColorProfile.CONTROLLER_ASPECT);
            }
        }
        if (blockEntity instanceof BlockSignalEntity) {
            BlockSignalEntity blockSignal = (BlockSignalEntity)blockEntity;
            Collection<BlockPos> peers = blockSignal.signalNetwork().peers();
            if (GogglesItem.isGoggleAuraActive((Player)SignalAuraRenderUtil.minecraft.f_91074_, GogglesItem.Aura.SURVEYING)) {
                SignalAuraRenderUtil.renderSignalAura(blockEntity, poseStack, bufferSource, peers, ColorProfile.COORD_RAINBOW);
            } else if (GogglesItem.isGoggleAuraActive((Player)SignalAuraRenderUtil.minecraft.f_91074_, GogglesItem.Aura.SIGNALLING)) {
                SignalAuraRenderUtil.renderSignalAura(blockEntity, poseStack, bufferSource, peers, ColorProfile.CONSTANT_BLUE);
            }
        } else if (blockEntity instanceof TokenSignalEntity) {
            TokenSignalEntity tokenSignal = (TokenSignalEntity)blockEntity;
            List<BlockPos> centroid = Collections.singletonList(tokenSignal.ringCentroidPos());
            if (GogglesItem.isGoggleAuraActive((Player)SignalAuraRenderUtil.minecraft.f_91074_, GogglesItem.Aura.SURVEYING)) {
                SignalAuraRenderUtil.renderSignalAura(blockEntity, poseStack, bufferSource, centroid, (t, s, d) -> tokenSignal.ringId().hashCode());
            } else if (GogglesItem.isGoggleAuraActive((Player)SignalAuraRenderUtil.minecraft.f_91074_, GogglesItem.Aura.SIGNALLING)) {
                SignalAuraRenderUtil.renderSignalAura(blockEntity, poseStack, bufferSource, centroid, ColorProfile.CONSTANT_BLUE);
            }
        }
    }

    private static void renderSignalAura(BlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, Collection<BlockPos> endPoints, ColorSupplier colorProfile) {
        if (endPoints.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        for (BlockPos target : endPoints) {
            BlockEntity be = SignalAuraRenderUtil.minecraft.f_91073_.m_7702_(target);
            if (be == null || be.m_58901_()) continue;
            int color = colorProfile.getColor(blockEntity, blockEntity.m_58899_(), target);
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            consumer.m_252986_(matrix, 0.5f, 0.5f, 0.5f).m_85950_(c1, c2, c3, 1.0f).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            float endX = 0.5f + (float)target.m_123341_() - (float)blockEntity.m_58899_().m_123341_();
            float endY = 0.5f + (float)target.m_123342_() - (float)blockEntity.m_58899_().m_123342_();
            float endZ = 0.5f + (float)target.m_123343_() - (float)blockEntity.m_58899_().m_123343_();
            consumer.m_252986_(matrix, endX, endY, endZ).m_85950_(c1, c2, c3, 1.0f).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        }
        poseStack.m_85849_();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ColorProfile implements ColorSupplier
    {
        COORD_RAINBOW{
            private final BlockPos[] coords = new BlockPos[2];

            @Override
            public int getColor(BlockEntity blockEntity, BlockPos source, BlockPos target) {
                this.coords[0] = source;
                this.coords[1] = target;
                Arrays.sort(this.coords);
                return Arrays.hashCode(this.coords);
            }
        }
        ,
        CONSTANT_BLUE{

            @Override
            public int getColor(BlockEntity blockEntity, BlockPos source, BlockPos target) {
                return DyeColor.BLUE.m_41070_();
            }
        }
        ,
        CONTROLLER_ASPECT{

            @Override
            public int getColor(BlockEntity blockEntity, BlockPos source, BlockPos target) {
                if (blockEntity instanceof SignalControllerEntity) {
                    SignalAspect aspect = ((SignalControllerEntity)blockEntity).getSignalController().aspect();
                    return switch (aspect) {
                        case SignalAspect.GREEN -> DyeColor.LIME.m_41070_();
                        case SignalAspect.YELLOW, SignalAspect.BLINK_YELLOW -> DyeColor.YELLOW.m_41070_();
                        default -> DyeColor.RED.m_41070_();
                    };
                }
                return CONSTANT_BLUE.getColor(blockEntity, source, target);
            }
        };

    }

    @FunctionalInterface
    public static interface ColorSupplier {
        public int getColor(BlockEntity var1, BlockPos var2, BlockPos var3);
    }
}

