/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.client.renderer.blockentity.FluidManipulatorRenderer;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.world.level.block.entity.manipulator.FluidLoaderBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class FluidLoaderRenderer
extends FluidManipulatorRenderer<FluidLoaderBlockEntity> {
    private static final float PIPE_OFFSET = 0.3125f;
    public static final ResourceLocation PIPE_SIDE_TEXTURE_LOCATION = new ResourceLocation("railcraft", "entity/fluid_loader/pipe_side");
    public static final ResourceLocation PIPE_END_TEXTURE_LOCATION = new ResourceLocation("railcraft", "entity/fluid_loader/pipe_end");
    public static final CuboidModel pipeModel = new CuboidModel(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.0625f, 0.6875f);

    @Override
    public void render(FluidLoaderBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        Minecraft minecraft = Minecraft.m_91087_();
        CuboidModel.Face sideFace = new CuboidModel.Face(pipeModel).setSprite((TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(PIPE_SIDE_TEXTURE_LOCATION));
        pipeModel.set(Direction.NORTH, sideFace);
        pipeModel.set(Direction.SOUTH, sideFace);
        pipeModel.set(Direction.EAST, sideFace);
        pipeModel.set(Direction.WEST, sideFace);
        CuboidModel.Face endFace = new CuboidModel.Face(pipeModel).setSprite((TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(PIPE_END_TEXTURE_LOCATION));
        pipeModel.set(Direction.UP, endFace);
        pipeModel.set(Direction.DOWN, endFace);
        pipeModel.setPackedLight(packedLight);
        pipeModel.setPackedOverlay(packedOverlay);
        poseStack.m_85836_();
        pipeModel.setMinY(0.0625f - blockEntity.getPipeLength(partialTick));
        VertexConsumer vertexBuilder = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)InventoryMenu.f_39692_));
        CuboidModelRenderer.render(pipeModel, poseStack, vertexBuilder, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
        poseStack.m_85849_();
    }
}

