/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class RailcraftButton
extends Button {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("railcraft", "textures/gui/widgets.png");
    private TexturePosition texturePosition;

    protected RailcraftButton(AbstractBuilder<?, ?> builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, builder.createNarration);
        this.texturePosition = builder.texturePosition;
    }

    public void setTexturePosition(TexturePosition texturePosition) {
        this.texturePosition = texturePosition;
    }

    protected int getYImage(boolean hovered) {
        if (!this.f_93623_) {
            return 0;
        }
        return hovered ? 2 : 1;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.m_91087_().f_91062_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS_LOCATION);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int i = this.getYImage(this.m_198029_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int xOffset = this.texturePosition.getX();
        int yOffset = this.texturePosition.getY();
        int h = this.texturePosition.getHeight();
        int w = this.texturePosition.getWidth();
        guiGraphics.m_280218_(WIDGETS_LOCATION, this.m_252754_(), this.m_252907_(), xOffset, yOffset + i * h, this.f_93618_ / 2, h);
        guiGraphics.m_280218_(WIDGETS_LOCATION, this.m_252754_() + this.f_93618_ / 2, this.m_252907_(), xOffset + w - this.f_93618_ / 2, yOffset + i * h, this.f_93618_ / 2, h);
        int j = this.getFGColor();
        guiGraphics.m_280653_(font, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    public static Builder builder(Component message, Button.OnPress onPress, TexturePosition texturePosition) {
        return new Builder(message, onPress, texturePosition);
    }

    public static Builder builder(String translationKey, Button.OnPress onPress, TexturePosition texturePosition) {
        return new Builder((Component)Component.m_237115_((String)translationKey), onPress, texturePosition);
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return f_252438_;
    }

    protected static abstract class AbstractBuilder<SELF extends AbstractBuilder<SELF, T>, T extends RailcraftButton> {
        private final Function<SELF, T> factory;
        private final Component message;
        private final Button.OnPress onPress;
        private final TexturePosition texturePosition;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration = RailcraftButton.access$000();

        public AbstractBuilder(Function<SELF, T> factory, Component message, Button.OnPress onPress, TexturePosition texturePosition) {
            this.factory = factory;
            this.message = message;
            this.onPress = onPress;
            this.texturePosition = texturePosition;
        }

        public SELF pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this.self();
        }

        public SELF width(int width) {
            this.width = width;
            return this.self();
        }

        public SELF size(int width, int height) {
            this.width = width;
            this.height = height;
            return this.self();
        }

        public SELF bounds(int x, int y, int width, int height) {
            return ((AbstractBuilder)this.pos(x, y)).size(width, height);
        }

        public SELF tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this.self();
        }

        public SELF createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this.self();
        }

        public T build() {
            RailcraftButton button = (RailcraftButton)((Object)this.factory.apply(this.self()));
            button.m_257544_(this.tooltip);
            return (T)((Object)button);
        }

        protected SELF self() {
            return (SELF)this;
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder, RailcraftButton> {
        public Builder(Component message, Button.OnPress onPress, TexturePosition texturePosition) {
            super(RailcraftButton::new, message, onPress, texturePosition);
        }
    }
}

