/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetRoutingTrackAttributesMessage;
import mods.railcraft.world.inventory.RoutingTrackMenu;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.track.RoutingTrackBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class RoutingTrackScreen
extends RailcraftMenuScreen<RoutingTrackMenu> {
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private static final ResourceLocation WIDGETS_TEXTURE_LOCATION = new ResourceLocation("railcraft", "textures/gui/container/routing_track.png");
    private final RoutingTrackBlockEntity routingBlockEntity;
    private MultiButton<LockableSwitchTrackActuatorBlockEntity.Lock> lockButton;
    private int refreshTimer;

    public RoutingTrackScreen(RoutingTrackMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.routingBlockEntity = menu.getRoutingBlockEntity();
        this.f_97727_ = 140;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.lockButton = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.routingBlockEntity.getLock()).bounds(this.f_97735_ + 152, this.f_97736_ + 8, 16, 16)).tooltipFactory(this::updateLockButtonTooltip).stateCallback(this::setLock).build()));
        this.updateButtons();
    }

    private void setLock(LockableSwitchTrackActuatorBlockEntity.Lock lock) {
        if (this.routingBlockEntity.getLock() != lock) {
            this.routingBlockEntity.setLock(lock.equals(LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED) ? null : this.f_96541_.m_91094_().m_92548_());
            this.sendAttributes();
        }
    }

    private Optional<Tooltip> updateLockButtonTooltip(LockableSwitchTrackActuatorBlockEntity.Lock lock) {
        return Optional.of(Tooltip.m_257550_((Component)(switch (lock) {
            default -> throw new IncompatibleClassChangeError();
            case LockableSwitchTrackActuatorBlockEntity.Lock.LOCKED -> Component.m_237110_((String)Translations.Screen.ACTION_SIGNAL_BOX_LOCKED, (Object[])new Object[]{this.routingBlockEntity.getOwnerOrThrow().getName()});
            case LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED -> Component.m_237115_((String)Translations.Screen.ACTION_SIGNAL_BOX_UNLOCKED);
        })));
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.refreshTimer++ >= 20) {
            this.refreshTimer = 0;
            this.updateButtons();
        }
    }

    private void updateButtons() {
        boolean canAccess;
        this.lockButton.f_93623_ = canAccess = this.routingBlockEntity.canAccess(this.f_96541_.m_91094_().m_92548_());
        this.lockButton.setState(this.routingBlockEntity.getLock());
    }

    private void sendAttributes() {
        if (!this.routingBlockEntity.canAccess(this.f_96541_.m_91094_().m_92548_())) {
            return;
        }
        NetworkChannel.GAME.sendToServer(new SetRoutingTrackAttributesMessage(this.routingBlockEntity.m_58899_(), this.lockButton.getState()));
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return WIDGETS_TEXTURE_LOCATION;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_TITLE), 64, 29, 0x404040, false);
    }
}

