/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.inventory.ManipulatorScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetItemManipulatorAttributesMessage;
import mods.railcraft.world.inventory.ItemManipulatorMenu;
import mods.railcraft.world.level.block.entity.manipulator.ItemManipulatorBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ItemManipulatorScreen
extends ManipulatorScreen<ItemManipulatorMenu> {
    private static final ResourceLocation WIDGETS_TEXTURE_LOCATION = new ResourceLocation("railcraft", "textures/gui/container/item_manipulator.png");
    private static final Component FILTERS_TEXT = Component.m_237115_((String)Translations.Screen.ITEM_MANIPULATOR_FILTERS);
    private static final Component BUFFER_TEXT = Component.m_237115_((String)Translations.Screen.ITEM_MANIPULATOR_BUFFER);
    private MultiButton<ManipulatorBlockEntity.TransferMode> transferModeButton;

    public ItemManipulatorScreen(ItemManipulatorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int centreX = (this.f_96543_ - this.getXSize()) / 2;
        int centreY = (this.f_96544_ - this.getYSize()) / 2;
        this.transferModeButton = (MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, ((ItemManipulatorBlockEntity)((ItemManipulatorMenu)this.f_97732_).getManipulator()).getTransferMode()).bounds(centreX + 73, centreY + 45, 30, 16)).stateCallback(this::setTransferMode).build();
        this.m_142416_((GuiEventListener)this.transferModeButton);
    }

    private void setTransferMode(ManipulatorBlockEntity.TransferMode transferMode) {
        if (transferMode != ((ItemManipulatorBlockEntity)((ItemManipulatorMenu)this.f_97732_).getManipulator()).getTransferMode()) {
            ((ItemManipulatorBlockEntity)((ItemManipulatorMenu)this.f_97732_).getManipulator()).setTransferMode(transferMode);
            this.sendAttributes();
        }
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280614_(this.f_96547_, FILTERS_TEXT, 18, 16, -12566464, false);
        guiGraphics.m_280614_(this.f_96547_, BUFFER_TEXT, 126, 16, -12566464, false);
    }

    @Override
    protected void refresh() {
        super.refresh();
        this.transferModeButton.setState(((ItemManipulatorBlockEntity)((ItemManipulatorMenu)this.f_97732_).getManipulator()).getTransferMode());
    }

    @Override
    protected void sendAttributes() {
        ItemManipulatorBlockEntity manipulator = (ItemManipulatorBlockEntity)((ItemManipulatorMenu)this.f_97732_).getManipulator();
        NetworkChannel.GAME.sendToServer(new SetItemManipulatorAttributesMessage(manipulator.m_58899_(), manipulator.getRedstoneMode(), manipulator.getTransferMode()));
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return WIDGETS_TEXTURE_LOCATION;
    }
}

