/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetSignalCapacitorBoxAttributesMessage;
import mods.railcraft.world.level.block.entity.signal.SignalCapacitorBoxBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SignalCapacitorBoxScreen
extends IngameWindowScreen {
    private final SignalCapacitorBoxBlockEntity signalBox;
    private MultiButton<SignalCapacitorBoxBlockEntity.Mode> modeButton;

    public SignalCapacitorBoxScreen(SignalCapacitorBoxBlockEntity signalBox) {
        super(signalBox.m_5446_());
        this.signalBox = signalBox;
    }

    public void m_7856_() {
        int centredX = (this.f_96543_ - this.windowWidth) / 2;
        int centredY = (this.f_96544_ - this.windowHeight) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-10"), __ -> this.incrementTicksToPower(-10)).m_252987_(centredX + 13, centredY + 38, 30, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-1"), __ -> this.incrementTicksToPower(-1)).m_252987_(centredX + 53, centredY + 38, 30, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+1"), __ -> this.incrementTicksToPower(1)).m_252987_(centredX + 93, centredY + 38, 30, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+10"), __ -> this.incrementTicksToPower(10)).m_252987_(centredX + 133, centredY + 38, 30, 20).m_253136_());
        this.modeButton = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.signalBox.getMode()).bounds(centredX + 23, centredY + 65, 130, 15)).stateCallback(this::setMode).build()));
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent componentDuration = Component.m_237110_((String)Translations.Screen.SIGNAL_CAPACITOR_BOX_DURATION, (Object[])new Object[]{this.signalBox.getTicksToPower() / 20});
        GuiUtil.drawCenteredString(guiGraphics, this.f_96547_, (Component)componentDuration, this.windowWidth, 25);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.modeButton.setState(this.signalBox.getMode());
    }

    private void setMode(SignalCapacitorBoxBlockEntity.Mode mode) {
        if (this.signalBox.getMode() != mode) {
            this.signalBox.setMode(mode);
            this.sendAttributes();
        }
    }

    private void incrementTicksToPower(int incrementSeconds) {
        short ticksToPower = (short)Math.max(0, this.signalBox.getTicksToPower() + incrementSeconds * 20);
        if (this.signalBox.getTicksToPower() != ticksToPower) {
            this.signalBox.setTicksToPower(ticksToPower);
            this.sendAttributes();
        }
    }

    private void sendAttributes() {
        NetworkChannel.GAME.sendToServer(new SetSignalCapacitorBoxAttributesMessage(this.signalBox.m_58899_(), this.signalBox.getTicksToPower(), this.modeButton.getState()));
    }
}

