/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.RailcraftPageButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.EditRoutingTableBookMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class RoutingTableBookScreen
extends Screen {
    public static final ResourceLocation BOOK_LOCATION = new ResourceLocation("railcraft", "textures/gui/item/routing_table_book.png");
    private static final int TEXT_WIDTH = 220;
    private static final int TEXT_HEIGHT = 128;
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 192;
    private static final int BOOK_MAX_PAGES = 50;
    private static final Component EDIT_TITLE_LABEL = Component.m_237115_((String)"book.editTitle");
    private static final FormattedCharSequence BLACK_CURSOR = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_.m_131140_(ChatFormatting.BLACK));
    private static final FormattedCharSequence GRAY_CURSOR = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY));
    private final Player owner;
    private final ItemStack book;
    private final InteractionHand hand;
    private boolean isModified;
    private boolean editingTitle;
    private int frameTick;
    private int currentPage;
    private final List<String> pages = Lists.newArrayList();
    private String title = "";
    private final TextFieldHelper pageEdit = new TextFieldHelper(this::getCurrentPageText, this::setCurrentPageText, this::getClipboard, this::setClipboard, s -> s.length() < 1024 && this.f_96547_.m_92920_(s, 220) <= 128);
    private final TextFieldHelper titleEdit = new TextFieldHelper(() -> this.title, s -> {
        this.title = s;
    }, this::getClipboard, this::setClipboard, s -> s.length() < 16);
    private long lastClickTime;
    private int lastIndex = -1;
    private PageButton forwardButton;
    private PageButton backButton;
    private RailcraftButton titleButton;
    private RailcraftButton helpButton;
    @Nullable
    private DisplayCache displayCache = DisplayCache.EMPTY;
    private Component pageMsg = CommonComponents.f_237098_;
    private final Component ownerText;
    private boolean readingManual;
    private final int numManualPages;

    public RoutingTableBookScreen(Player owner, ItemStack book, InteractionHand hand) {
        super(GameNarrator.f_93310_);
        this.owner = owner;
        this.book = book;
        this.hand = hand;
        this.ownerText = Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{owner.m_7755_()}).m_130940_(ChatFormatting.DARK_GRAY);
        CompoundTag tag = book.m_41783_();
        if (tag != null) {
            BookViewScreen.m_169696_((CompoundTag)tag, this.pages::add);
        }
        if (this.pages.isEmpty()) {
            this.pages.add("");
        }
        this.numManualPages = Translations.RoutingTable.MANUAL_PAGES.size();
    }

    private void setClipboard(String s) {
        if (this.f_96541_ != null) {
            TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)s);
        }
    }

    private String getClipboard() {
        return this.f_96541_ != null ? TextFieldHelper.m_95169_((Minecraft)this.f_96541_) : "";
    }

    private int getNumPages() {
        return this.pages.size();
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.frameTick;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        this.clearDisplayCache();
        this.titleButton = ((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.NAME, button -> {
            this.editingTitle = !this.editingTitle;
            this.readingManual = false;
            this.currentPage = 0;
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).pos(0, this.f_96544_ / 2 + 90)).size(65, 20)).build();
        this.helpButton = ((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.HELP, button -> {
            this.readingManual = !this.readingManual;
            this.editingTitle = false;
            this.currentPage = 0;
            this.clearDisplayCacheAfterPageChange();
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).pos(0, this.f_96544_ / 2 + 90)).size(65, 20)).build();
        List<RailcraftButton> buttons = List.of(this.titleButton, this.helpButton, ((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.f_130655_, button -> {
            this.saveChanges();
            this.f_96541_.m_91152_(null);
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).pos(0, this.f_96544_ / 2 + 90)).size(65, 20)).build());
        GuiUtil.newButtonRowAuto(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, this.f_96543_ / 2 - 100, 200, buttons);
        int xOffset = (this.f_96543_ - 256) / 2;
        int yOffset = (this.f_96544_ - 192) / 2;
        this.forwardButton = (PageButton)this.m_142416_((GuiEventListener)new RailcraftPageButton(xOffset + 200, yOffset + 150, true, BOOK_LOCATION, button -> this.pageForward()));
        this.backButton = (PageButton)this.m_142416_((GuiEventListener)new RailcraftPageButton(xOffset + 30, yOffset + 150, false, BOOK_LOCATION, button -> this.pageBack()));
        this.updateButtonVisibility();
    }

    private void pageForward() {
        if (this.readingManual) {
            if (this.currentPage < this.getMaxPages() - 1) {
                ++this.currentPage;
            }
            return;
        }
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        } else {
            this.appendPageToBook();
            if (this.currentPage < this.getNumPages() - 1) {
                ++this.currentPage;
            }
        }
        this.updateButtonVisibility();
        this.clearDisplayCacheAfterPageChange();
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        if (!this.readingManual) {
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
        }
    }

    private void updateButtonVisibility() {
        this.forwardButton.f_93624_ = !this.editingTitle && this.currentPage < this.getMaxPages() - 1;
        this.backButton.f_93624_ = !this.editingTitle && this.currentPage > 0;
        this.helpButton.m_93666_((Component)(this.readingManual ? CommonComponents.f_130660_ : Component.m_237115_((String)Translations.Screen.HELP)));
        this.titleButton.m_93666_((Component)(this.editingTitle ? CommonComponents.f_130660_ : Component.m_237115_((String)Translations.Screen.NAME)));
    }

    private int getMaxPages() {
        if (this.readingManual) {
            return this.numManualPages;
        }
        if (this.editingTitle) {
            return 0;
        }
        return 50;
    }

    private void eraseEmptyTrailingPages() {
        ListIterator<String> listiterator = this.pages.listIterator(this.pages.size());
        while (listiterator.hasPrevious() && listiterator.previous().isEmpty()) {
            listiterator.remove();
        }
    }

    private void saveChanges() {
        if (this.isModified) {
            this.eraseEmptyTrailingPages();
            this.updateLocalCopy();
            NetworkChannel.GAME.sendToServer(new EditRoutingTableBookMessage(this.hand, this.pages, Optional.of(this.title.trim())));
        }
    }

    private void updateLocalCopy() {
        if (!this.pages.isEmpty()) {
            ListTag listtag = new ListTag();
            this.pages.stream().map(StringTag::m_129297_).forEach(arg_0 -> listtag.add(arg_0));
            this.book.m_41700_("pages", (Tag)listtag);
        }
        this.book.m_41700_("author", (Tag)StringTag.m_129297_((String)this.owner.m_36316_().getName()));
        this.book.m_41700_("title", (Tag)StringTag.m_129297_((String)this.title.trim()));
    }

    private void appendPageToBook() {
        if (this.getNumPages() < 50) {
            this.pages.add("");
            this.isModified = true;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.editingTitle) {
            return this.titleKeyPressed(keyCode, scanCode, modifiers);
        }
        if (this.bookKeyPressed(keyCode, scanCode, modifiers)) {
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (super.m_5534_(codePoint, modifiers)) {
            return true;
        }
        if (this.editingTitle) {
            if (this.titleEdit.m_95143_(codePoint)) {
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
            return false;
        }
        if (SharedConstants.m_136188_((char)codePoint)) {
            this.pageEdit.m_95158_(Character.toString(codePoint));
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    private boolean bookKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (Screen.m_96634_((int)keyCode)) {
            this.pageEdit.m_95188_();
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            this.pageEdit.m_95178_();
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            this.pageEdit.m_95165_();
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            this.pageEdit.m_95142_();
            return true;
        }
        TextFieldHelper.CursorStep cursorStep = Screen.m_96637_() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        switch (keyCode) {
            case 257: 
            case 335: {
                this.pageEdit.m_95158_("\n");
                return true;
            }
            case 259: {
                this.pageEdit.m_232572_(-1, cursorStep);
                return true;
            }
            case 261: {
                this.pageEdit.m_232572_(1, cursorStep);
                return true;
            }
            case 262: {
                this.pageEdit.m_232575_(1, Screen.m_96638_(), cursorStep);
                return true;
            }
            case 263: {
                this.pageEdit.m_232575_(-1, Screen.m_96638_(), cursorStep);
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 266: {
                this.backButton.m_5691_();
                return true;
            }
            case 267: {
                this.forwardButton.m_5691_();
                return true;
            }
            case 268: {
                this.keyHome();
                return true;
            }
            case 269: {
                this.keyEnd();
                return true;
            }
        }
        return false;
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int yChange) {
        int i = this.pageEdit.m_95194_();
        int j = this.getDisplayCache().changeLine(i, yChange);
        this.pageEdit.m_95179_(j, Screen.m_96638_());
    }

    private void keyHome() {
        if (Screen.m_96637_()) {
            this.pageEdit.m_95176_(Screen.m_96638_());
        } else {
            int i = this.pageEdit.m_95194_();
            int j = this.getDisplayCache().findLineStart(i);
            this.pageEdit.m_95179_(j, Screen.m_96638_());
        }
    }

    private void keyEnd() {
        if (Screen.m_96637_()) {
            this.pageEdit.m_95186_(Screen.m_96638_());
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            int i = this.pageEdit.m_95194_();
            int j = displayCache.findLineEnd(i);
            this.pageEdit.m_95179_(j, Screen.m_96638_());
        }
    }

    private boolean titleKeyPressed(int keyCode, int pScanCode, int pModifiers) {
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.saveChanges();
                    this.f_96541_.m_91152_(null);
                }
                return true;
            }
            case 259: {
                this.titleEdit.m_95189_(-1);
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
        }
        return false;
    }

    private String getCurrentPageText() {
        return this.currentPage >= 0 && this.currentPage < this.pages.size() ? this.pages.get(this.currentPage) : "";
    }

    private void setCurrentPageText(String text) {
        if (this.currentPage >= 0 && this.currentPage < this.pages.size()) {
            this.pages.set(this.currentPage, text);
            this.isModified = true;
            this.clearDisplayCache();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.m_7522_(null);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BOOK_LOCATION);
        int xOffset = (this.f_96543_ - 256) / 2;
        int yOffset = (this.f_96544_ - 192) / 2;
        guiGraphics.m_280218_(BOOK_LOCATION, xOffset, yOffset, 0, 0, 256, 192);
        if (this.editingTitle) {
            boolean flag = this.frameTick / 6 % 2 == 0;
            FormattedCharSequence formattedcharsequence = FormattedCharSequence.m_13696_((FormattedCharSequence)FormattedCharSequence.m_13714_((String)this.title, (Style)Style.f_131099_), (FormattedCharSequence)(flag ? BLACK_CURSOR : GRAY_CURSOR));
            int l = this.f_96547_.m_92852_((FormattedText)EDIT_TITLE_LABEL);
            guiGraphics.m_280614_(this.f_96547_, EDIT_TITLE_LABEL, xOffset + 160 - l, yOffset + 34, 0, false);
            int l1 = this.f_96547_.m_92724_(formattedcharsequence);
            guiGraphics.m_280649_(this.f_96547_, formattedcharsequence, xOffset + 120 - l1 / 2, yOffset + 50, 0, false);
            int l2 = this.f_96547_.m_92852_((FormattedText)this.ownerText);
            guiGraphics.m_280614_(this.f_96547_, this.ownerText, xOffset + 130 - l2, yOffset + 60, 0, false);
        } else if (this.readingManual) {
            MutableComponent manualPageIndicator = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.getMaxPages()});
            int l = this.f_96547_.m_92852_((FormattedText)manualPageIndicator);
            guiGraphics.m_280614_(this.f_96547_, (Component)manualPageIndicator, xOffset - l + 225, yOffset + 15, 0, false);
            MutableComponent page = Component.m_237115_((String)Translations.RoutingTable.MANUAL_PAGES.get(this.currentPage));
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)page, xOffset + 20, yOffset + 27, 220, -12566464);
        } else {
            int l = this.f_96547_.m_92852_((FormattedText)this.pageMsg);
            guiGraphics.m_280614_(this.f_96547_, this.pageMsg, xOffset - l + 225, yOffset + 15, 0, false);
            DisplayCache displayCache = this.getDisplayCache();
            for (LineInfo lineinfo : displayCache.lines) {
                guiGraphics.m_280614_(this.f_96547_, lineinfo.asComponent, lineinfo.x, lineinfo.y, -16777216, false);
            }
            this.renderHighlight(guiGraphics, displayCache.selection);
            this.renderCursor(guiGraphics, displayCache.cursor, displayCache.cursorAtEnd);
        }
        this.updateButtonVisibility();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderCursor(GuiGraphics guiGraphics, Pos2i cursorPos, boolean isEndOfText) {
        if (this.frameTick / 6 % 2 == 0) {
            cursorPos = this.convertLocalToScreen(cursorPos);
            if (!isEndOfText) {
                guiGraphics.m_280509_(cursorPos.x, cursorPos.y - 1, cursorPos.x + 1, cursorPos.y + 9, -16777216);
            } else {
                guiGraphics.m_280056_(this.f_96547_, "_", cursorPos.x, cursorPos.y, 0, false);
            }
        }
    }

    private void renderHighlight(GuiGraphics guiGraphics, Rect2i[] selected) {
        for (Rect2i rect2i : selected) {
            int i = rect2i.m_110085_();
            int j = rect2i.m_110086_();
            int k = i + rect2i.m_110090_();
            int l = j + rect2i.m_110091_();
            guiGraphics.m_285944_(RenderType.m_285783_(), i, j, k, l, -16776961);
        }
    }

    private Pos2i convertScreenToLocal(Pos2i screenPos) {
        int xOffset = (this.f_96543_ - 256) / 2;
        int yOffset = (this.f_96544_ - 192) / 2;
        int x = screenPos.x - xOffset - 20;
        int y = screenPos.y - yOffset - 27;
        return new Pos2i(x, y);
    }

    private Pos2i convertLocalToScreen(Pos2i localScreenPos) {
        int xOffset = (this.f_96543_ - 256) / 2;
        int yOffset = (this.f_96544_ - 192) / 2;
        int x = localScreenPos.x + xOffset + 20;
        int y = localScreenPos.y + yOffset + 27;
        return new Pos2i(x, y);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            long i = Util.m_137550_();
            DisplayCache displayCache = this.getDisplayCache();
            int j = displayCache.getIndexAtPosition(this.f_96547_, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (j >= 0) {
                if (j == this.lastIndex && i - this.lastClickTime < 250L) {
                    if (!this.pageEdit.m_95198_()) {
                        this.selectWord(j);
                    } else {
                        this.pageEdit.m_95188_();
                    }
                } else {
                    this.pageEdit.m_95179_(j, Screen.m_96638_());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = j;
            this.lastClickTime = i;
        }
        return true;
    }

    private void selectWord(int pIndex) {
        String s = this.getCurrentPageText();
        this.pageEdit.m_95147_(StringSplitter.m_92355_((String)s, (int)-1, (int)pIndex, (boolean)false), StringSplitter.m_92355_((String)s, (int)1, (int)pIndex, (boolean)false));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button == 0) {
            DisplayCache displayCache = this.getDisplayCache();
            int i = displayCache.getIndexAtPosition(this.f_96547_, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            this.pageEdit.m_95179_(i, true);
            this.clearDisplayCache();
        }
        return true;
    }

    private DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
            this.pageMsg = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.getNumPages()});
        }
        return this.displayCache;
    }

    private void clearDisplayCache() {
        this.displayCache = null;
    }

    private void clearDisplayCacheAfterPageChange() {
        this.pageEdit.m_95193_();
        this.clearDisplayCache();
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i pos;
        boolean flag;
        String s = this.getCurrentPageText();
        if (s.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        int i = this.pageEdit.m_95194_();
        int j = this.pageEdit.m_95197_();
        IntArrayList intlist = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringsplitter = this.f_96547_.m_92865_();
        stringsplitter.m_92364_(s, 220, Style.f_131099_, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$10(mutableint, s, mutableboolean, (IntList)intlist, list, arg_0, arg_1, arg_2));
        int[] aint = intlist.toIntArray();
        boolean bl = flag = i == s.length();
        if (flag && mutableboolean.isTrue()) {
            pos = new Pos2i(0, list.size() * 9);
        } else {
            int k = RoutingTableBookScreen.findLineFromPos(aint, i);
            int l = this.f_96547_.m_92895_(s.substring(aint[k], i));
            pos = new Pos2i(l, k * 9);
        }
        ArrayList list1 = Lists.newArrayList();
        if (i != j) {
            int k1;
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = RoutingTableBookScreen.findLineFromPos(aint, l2);
            if (j1 == (k1 = RoutingTableBookScreen.findLineFromPos(aint, i1))) {
                int l1 = j1 * 9;
                int i2 = aint[j1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > aint.length ? s.length() : aint[j1 + 1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i3, j1 * 9, aint[j1]));
                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(aint[j3], aint[j3 + 1]);
                    int k2 = (int)stringsplitter.m_92353_(s1);
                    list1.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                list1.add(this.createPartialLineSelection(s, stringsplitter, aint[k1], i1, k1 * 9, aint[k1]));
            }
        }
        return new DisplayCache(s, pos, flag, aint, list.toArray(new LineInfo[0]), list1.toArray(new Rect2i[0]));
    }

    static int findLineFromPos(int[] lineStarts, int find) {
        int i = Arrays.binarySearch(lineStarts, find);
        return i < 0 ? -(i + 2) : i;
    }

    private Rect2i createPartialLineSelection(String input, StringSplitter splitter, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s = input.substring(p_98125_, p_98122_);
        String s1 = input.substring(p_98125_, p_98123_);
        Pos2i corner1 = new Pos2i((int)splitter.m_92353_(s), p_98124_);
        Pos2i corner2 = new Pos2i((int)splitter.m_92353_(s1), p_98124_ + 9);
        return this.createSelection(corner1, corner2);
    }

    private Rect2i createSelection(Pos2i pCorner1, Pos2i pCorner2) {
        Pos2i pos = this.convertLocalToScreen(pCorner1);
        Pos2i pos1 = this.convertLocalToScreen(pCorner2);
        int i = Math.min(pos.x, pos1.x);
        int j = Math.max(pos.x, pos1.x);
        int k = Math.min(pos.y, pos1.y);
        int l = Math.max(pos.y, pos1.y);
        return new Rect2i(i, k, j - i, l - k);
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$10(MutableInt mutableint, String s, MutableBoolean mutableboolean, IntList intlist, List list, Style style, int beginIndex, int endIndex) {
        int k3 = mutableint.getAndIncrement();
        String s2 = s.substring(beginIndex, endIndex);
        mutableboolean.setValue(s2.endsWith("\n"));
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        int l3 = k3 * 9;
        Pos2i pos = this.convertLocalToScreen(new Pos2i(0, l3));
        intlist.add(beginIndex);
        list.add(new LineInfo(style, s3, pos.x, pos.y));
    }

    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(Style.f_131099_, "", 0, 0)}, new Rect2i[0]);
        private final String fullText;
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final Rect2i[] selection;

        public DisplayCache(String fullText, Pos2i cursor, boolean cursorAtEnd, int[] lineStarts, LineInfo[] lines, Rect2i[] selection) {
            this.fullText = fullText;
            this.cursor = cursor;
            this.cursorAtEnd = cursorAtEnd;
            this.lineStarts = lineStarts;
            this.lines = lines;
            this.selection = selection;
        }

        public int getIndexAtPosition(Font font, Pos2i cursorPosition) {
            int i = cursorPosition.y / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            return this.lineStarts[i] + font.m_92865_().m_92360_(this.lines[i].contents, cursorPosition.x, this.lines[i].style);
        }

        public int changeLine(int xChange, int yChange) {
            int k;
            int i = RoutingTableBookScreen.findLineFromPos(this.lineStarts, xChange);
            int j = i + yChange;
            if (0 <= j && j < this.lineStarts.length) {
                int l = xChange - this.lineStarts[i];
                int i1 = this.lines[j].contents.length();
                k = this.lineStarts[j] + Math.min(l, i1);
            } else {
                k = xChange;
            }
            return k;
        }

        public int findLineStart(int line) {
            int i = RoutingTableBookScreen.findLineFromPos(this.lineStarts, line);
            return this.lineStarts[i];
        }

        public int findLineEnd(int line) {
            int i = RoutingTableBookScreen.findLineFromPos(this.lineStarts, line);
            return this.lineStarts[i] + this.lines[i].contents.length();
        }
    }

    static class LineInfo {
        final Style style;
        final String contents;
        final Component asComponent;
        final int x;
        final int y;

        public LineInfo(Style style, String contents, int x, int y) {
            this.style = style;
            this.contents = contents;
            this.x = x;
            this.y = y;
            this.asComponent = Component.m_237113_((String)contents).m_6270_(style);
        }
    }

    record Pos2i(int x, int y) {
    }
}

