/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.EditTicketAttributeMessage;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class GoldenTicketScreen
extends IngameWindowScreen {
    private static final ResourceLocation TICKET_LOCATION = new ResourceLocation("railcraft", "textures/gui/item/golden_ticket.png");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 136;
    private static final String PREFIX = "Dest=";
    private final ItemStack itemStack;
    private final InteractionHand hand;
    private String dest;
    private RailcraftButton helpButton;
    private EditBox editBoxDest;
    private boolean readingManual;

    public GoldenTicketScreen(ItemStack itemStack, InteractionHand hand) {
        super(GameNarrator.f_93310_, TICKET_LOCATION, 256, 136);
        this.itemStack = itemStack;
        this.hand = hand;
        this.dest = PREFIX + TicketItem.getDestination(this.itemStack);
        this.readingManual = false;
    }

    protected void m_7856_() {
        this.helpButton = ((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.HELP, button -> {
            this.readingManual = !this.readingManual;
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).pos(0, this.f_96544_ / 2 + 75)).size(65, 20)).build();
        List<RailcraftButton> buttons = List.of(((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.f_130655_, button -> {
            this.sendMessageToServer();
            this.f_96541_.m_91152_(null);
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).pos(0, this.f_96544_ / 2 + 75)).size(65, 20)).build(), this.helpButton, ((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(null), (TexturePosition)ButtonTexture.LARGE_BUTTON).pos(0, this.f_96544_ / 2 + 75)).size(65, 20)).build());
        GuiUtil.newButtonRowAuto(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, this.f_96543_ / 2 - 100, 200, buttons);
        this.editBoxDest = new EditBox(this.f_96547_, this.f_96543_ / 2 - 117, this.f_96544_ / 2 + 23, 234, 20, (Component)Component.m_237119_());
        this.editBoxDest.m_94144_(this.dest);
        this.editBoxDest.m_94182_(false);
        this.m_142416_((GuiEventListener)this.editBoxDest);
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.readingManual) {
            this.editBoxDest.m_94194_(false);
            MutableComponent about = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_ABOUT);
            MutableComponent help = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_HELP).m_130940_(ChatFormatting.BLACK);
            GuiUtil.drawCenteredString(guiGraphics, this.f_96547_, (Component)about, this.windowWidth, 15);
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)help, 15, 30, 230, -12566464);
            this.helpButton.m_93666_(CommonComponents.f_130660_);
        } else {
            MutableComponent title = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_TITLE).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
            MutableComponent desc1 = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_DESC_1);
            MutableComponent desc2 = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_DESC_2);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            GuiUtil.drawCenteredString(guiGraphics, this.f_96547_, (Component)title, 128, 8, true);
            poseStack.m_85849_();
            GuiUtil.drawCenteredString(guiGraphics, this.f_96547_, (Component)desc1, this.windowWidth, 45);
            GuiUtil.drawCenteredString(guiGraphics, this.f_96547_, (Component)desc2, this.windowWidth, 60);
            this.editBoxDest.m_94194_(true);
            this.helpButton.m_93666_((Component)Component.m_237115_((String)Translations.Screen.HELP));
        }
    }

    private void sendMessageToServer() {
        this.dest = this.editBoxDest.m_94155_();
        boolean isValid = this.dest.startsWith(PREFIX);
        if (!isValid) {
            return;
        }
        this.dest = this.dest.trim();
        String destWithoutPrefix = this.dest.substring(PREFIX.length());
        boolean success = TicketItem.setTicketData(this.itemStack, destWithoutPrefix, this.f_96541_.f_91074_.m_36316_());
        if (success) {
            NetworkChannel.GAME.sendToServer(new EditTicketAttributeMessage(this.hand, destWithoutPrefix));
        }
    }
}

