/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.carts;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.StringRepresentable;

public enum Side implements StringRepresentable
{
    FRONT("front"),
    BACK("back");

    private final String name;

    private Side(String name) {
        this.name = name;
    }

    public Side opposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FRONT -> BACK;
            case BACK -> FRONT;
        };
    }

    public boolean isFront() {
        return this == FRONT;
    }

    public boolean isBack() {
        return this == BACK;
    }

    public String getName() {
        return this.name;
    }

    public String m_7912_() {
        return this.getName();
    }

    public static Optional<Side> getByName(String name) {
        return Stream.of(Side.values()).filter(link -> link.name.equals(name)).findFirst();
    }
}

