/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.google.gson.JsonObject;
import mods.railcraft.util.Conditions;
import mods.railcraft.util.JsonUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MultiBlockFormedTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("railcraft", "multiblock_formed");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
        BlockEntityType type = JsonUtil.getFromRegistry(json, "type", ForgeRegistries.BLOCK_ENTITY_TYPES).orElse(null);
        NbtPredicate nbt = JsonUtil.getAsJsonObject(json, "nbt").map(NbtPredicate::m_57481_).orElse(NbtPredicate.f_57471_);
        return new Instance(contextAwarePredicate, type, nbt);
    }

    public void trigger(ServerPlayer playerEntity, RailcraftBlockEntity blockEntity) {
        this.m_66234_(playerEntity, criterionInstance -> criterionInstance.matches(blockEntity));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final BlockEntityType<?> type;
        private final NbtPredicate predicate;

        private Instance(ContextAwarePredicate contextAwarePredicate, @Nullable BlockEntityType<?> type, NbtPredicate predicate) {
            super(ID, contextAwarePredicate);
            this.type = type;
            this.predicate = predicate;
        }

        public static Instance formedMultiBlock(BlockEntityType<?> tileEntityType) {
            return Instance.formedMultiBlock(tileEntityType, NbtPredicate.f_57471_);
        }

        public static Instance formedMultiBlock(BlockEntityType<?> tileEntityType, NbtPredicate nbtPredicate) {
            return new Instance(ContextAwarePredicate.f_285567_, tileEntityType, nbtPredicate);
        }

        public boolean matches(RailcraftBlockEntity blockEntity) {
            return Conditions.check(this.type, blockEntity.m_58903_()) && this.predicate.m_57483_((Tag)blockEntity.m_187482_());
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject json = new JsonObject();
            if (this.type != null) {
                json.addProperty("type", ForgeRegistries.BLOCK_ENTITY_TYPES.getKey(this.type).toString());
            }
            json.add("nbt", this.predicate.m_57476_());
            return json;
        }
    }
}

