/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsTabControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.Tab;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTab;

public abstract class StorageSettingsTabControlBase
extends SettingsTabControl<SettingsScreen, SettingsTab<?>> {
    private final List<SettingsTab<?>> settingsTabs = new ArrayList();
    protected final SettingsScreen screen;

    protected static <C extends SettingsContainerBase<?>, T extends SettingsTab<C>> void addFactory(ImmutableMap.Builder<String, ISettingsTabFactory<?, ?>> builder, String categoryName, ISettingsTabFactory<C, T> factory) {
        builder.put((Object)categoryName, factory);
    }

    protected StorageSettingsTabControlBase(SettingsScreen screen, Position position) {
        super(position);
        this.screen = screen;
        this.addChild(this.instantiateReturnBackTab());
        ((SettingsContainerMenu)screen.m_6262_()).forEachSettingsContainer((categoryName, settingsContainer) -> {
            if (this.isSettingsCategoryDisabled((String)categoryName)) {
                return;
            }
            this.settingsTabs.add(this.addSettingsTab(() -> {}, () -> {}, this.instantiateContainer((String)categoryName, (SettingsContainerBase)settingsContainer, new Position(this.x, this.getTopY()), screen)));
        });
    }

    protected boolean isSettingsCategoryDisabled(String categoryName) {
        return false;
    }

    protected abstract Tab instantiateReturnBackTab();

    public void renderSlotOverlays(GuiGraphics guiGraphics, Slot slot, ISlotOverlayRenderer overlayRenderer) {
        ArrayList colors = new ArrayList();
        this.settingsTabs.forEach(tab -> tab.getSlotOverlayColor(slot.f_40219_).ifPresent(colors::add));
        if (colors.isEmpty()) {
            return;
        }
        int stripeHeight = 16 / colors.size();
        int i = 0;
        Iterator iterator = colors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            int yOffset = i * stripeHeight;
            overlayRenderer.renderSlotOverlay(guiGraphics, slot.f_40220_, slot.f_40221_ + yOffset, i == colors.size() - 1 ? 16 - yOffset : stripeHeight, color);
            ++i;
        }
    }

    public ItemStack getSlotStackDisplayOverride(int slotNumber) {
        for (SettingsTab<?> settingsTab : this.settingsTabs) {
            ItemStack stack = settingsTab.getItemDisplayOverride(slotNumber);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void renderSlotExtra(GuiGraphics guiGraphics, Slot slot) {
        this.settingsTabs.forEach(tab -> tab.renderExtra(guiGraphics, slot));
    }

    public void handleSlotClick(Slot slot, int mouseButton) {
        this.getOpenTab().ifPresent(tab -> tab.handleSlotClick(slot, mouseButton));
    }

    public boolean renderGuiItem(GuiGraphics guiGraphics, ItemRenderer itemRenderer, ItemStack itemstack, Slot slot) {
        for (SettingsTab<?> tab : this.settingsTabs) {
            int rotation = tab.getItemRotation(slot.f_40219_);
            if (rotation == 0) continue;
            GuiHelper.tryRenderGuiItem(itemRenderer, (LivingEntity)this.minecraft.f_91074_, itemstack, slot.f_40220_, slot.f_40221_, rotation);
            return true;
        }
        if (!itemstack.m_41619_()) {
            guiGraphics.m_280480_(itemstack, slot.f_40220_, slot.f_40221_);
            return true;
        }
        return false;
    }

    public void drawSlotStackOverlay(GuiGraphics guiGraphics, Slot slot) {
        for (SettingsTab<?> tab : this.settingsTabs) {
            tab.drawSlotStackOverlay(guiGraphics, slot);
        }
    }

    private <C extends SettingsContainerBase<?>> SettingsTab<C> instantiateContainer(String categoryName, C container, Position position, SettingsScreen screen) {
        return this.getSettingsTabFactory(categoryName).create(container, position, screen);
    }

    protected abstract <C extends SettingsContainerBase<?>, T extends SettingsTab<C>> ISettingsTabFactory<C, T> getSettingsTabFactory(String var1);

    public static interface ISlotOverlayRenderer {
        public void renderSlotOverlay(GuiGraphics var1, int var2, int var3, int var4, int var5);
    }

    public static interface ISettingsTabFactory<C extends SettingsContainerBase<?>, T extends SettingsTab<C>> {
        public T create(C var1, Position var2, SettingsScreen var3);
    }
}

