/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.block.HarvesterBlock;
import com.blakebr0.mysticalagriculture.container.HarvesterContainer;
import com.blakebr0.mysticalagriculture.container.inventory.UpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class HarvesterTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final Method GET_SEED = ObfuscationReflectionHelper.findMethod(CropBlock.class, (String)"m_6404_", (Class[])new Class[0]);
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 100;
    public static final int FUEL_USAGE = 40;
    public static final int SCAN_FUEL_USAGE = 10;
    public static final int FUEL_CAPACITY = 80000;
    public static final int BASE_RANGE = 1;
    private final BaseItemStackHandler inventory;
    private final UpgradeItemStackHandler upgradeInventory;
    private final DynamicEnergyStorage energy;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private List<BlockPos> positions;
    private BlockPos lastPosition = BlockPos.f_121853_;
    private MachineUpgradeTier tier;
    private Direction direction;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;

    public HarvesterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.HARVESTER.get(), pos, state);
        this.inventory = HarvesterTileEntity.createInventoryHandler(() -> ((HarvesterTileEntity)this).markDirtyAndDispatch());
        this.upgradeInventory = new UpgradeItemStackHandler();
        this.energy = new DynamicEnergyStorage(80000, () -> ((HarvesterTileEntity)this).markDirtyAndDispatch());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.mysticalagriculture.harvester").build();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return HarvesterContainer.create(i, inventory, this.inventory, this.upgradeInventory, this.m_58899_());
    }

    @Override
    public UpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.fuelLeft = tag.m_128451_("FuelLeft");
        this.fuelItemValue = tag.m_128451_("FuelItemValue");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
        this.lastPosition = BlockPos.m_122022_((long)tag.m_128454_("LastPosition"));
        this.upgradeInventory.deserializeNBT(tag.m_128469_("UpgradeInventory"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("FuelLeft", this.fuelLeft);
        tag.m_128405_("FuelItemValue", this.fuelItemValue);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
        tag.m_128356_("LastPosition", this.lastPosition.m_121878_());
        tag.m_128365_("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == ForgeCapabilities.ENERGY) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, this.energyCapability);
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HarvesterTileEntity tile) {
        boolean mark = false;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(0);
            if (tile.fuelLeft <= 0 && !fuel.m_41619_()) {
                tile.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel, null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    mark = true;
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                mark = true;
            }
        }
        MachineUpgradeTier tier = tile.getMachineTier();
        Direction direction = (Direction)state.m_61143_((Property)HarvesterBlock.FACING);
        if (tier != tile.tier || direction != tile.direction) {
            int range = tier != null ? 1 + tier.getAddedRange() : 1;
            BlockPos center = pos.m_5484_(direction, range + 1);
            tile.tier = tier;
            tile.direction = direction;
            tile.positions = HarvesterTileEntity.getWorkingArea(center, range, direction);
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            mark = true;
        }
        boolean isDisabled = level.m_276867_(tile.m_58899_());
        int operationTime = tile.getOperationTime();
        if (tile.progress > operationTime && !isDisabled) {
            BlockPos nextPos = tile.findNextPosition();
            BlockState cropState = level.m_8055_(nextPos);
            Block block = cropState.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Item seed = HarvesterTileEntity.getSeed(block);
                if (seed != null && crop.m_52307_(cropState)) {
                    List drops = Block.m_49869_((BlockState)cropState, (ServerLevel)((ServerLevel)level), (BlockPos)nextPos, (BlockEntity)tile);
                    for (ItemStack drop : drops) {
                        Item item = drop.m_41720_();
                        if (drop.m_41619_() || item != seed) continue;
                        drop.m_41774_(1);
                        break;
                    }
                    for (ItemStack drop : drops) {
                        if (drop.m_41619_()) continue;
                        tile.addItemToInventory(drop, level, nextPos);
                    }
                    level.m_46597_(nextPos, crop.m_52289_(0));
                    tile.energy.extractEnergy(tile.getFuelUsage(), false);
                } else {
                    tile.energy.extractEnergy(10, false);
                }
            }
            tile.progress = 0;
            mark = true;
        }
        boolean wasRunning = tile.isRunning;
        if (!isDisabled && tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            ++tile.progress;
            tile.isRunning = true;
            mark = true;
        } else {
            tile.isRunning = false;
        }
        if (wasRunning != tile.isRunning) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HarvesterBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            mark = true;
        }
        if (mark) {
            tile.markDirtyAndDispatch();
        }
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return HarvesterTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        return BaseItemStackHandler.create((int)16, (Runnable)onContentsChanged, builder -> {
            builder.setCanInsert((slot, stack) -> slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack, null) > 0);
            builder.setCanExtract(slot -> slot > 0);
        });
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        if (this.tier == null) {
            return 100;
        }
        return (int)(100.0 * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 40;
        }
        return (int)(40.0 * this.tier.getFuelUsageMultiplier());
    }

    private static List<BlockPos> getWorkingArea(BlockPos center, int range, Direction direction) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        switch (direction) {
            case NORTH: {
                for (int x = -range; x < range + 1; ++x) {
                    for (int z = -range; z < range + 1; ++z) {
                        positions.add(new BlockPos(center.m_123341_() + x, center.m_123342_(), center.m_123343_() + z));
                    }
                }
                break;
            }
            case SOUTH: {
                for (int x = range; x > -range - 1; --x) {
                    for (int z = range; z > -range - 1; --z) {
                        positions.add(new BlockPos(center.m_123341_() + x, center.m_123342_(), center.m_123343_() + z));
                    }
                }
                break;
            }
            case EAST: {
                for (int z = -range; z < range + 1; ++z) {
                    for (int x = range; x > -range - 1; --x) {
                        positions.add(new BlockPos(center.m_123341_() + x, center.m_123342_(), center.m_123343_() + z));
                    }
                }
                break;
            }
            case WEST: {
                for (int z = range; z > -range - 1; --z) {
                    for (int x = -range; x < range + 1; ++x) {
                        positions.add(new BlockPos(center.m_123341_() + x, center.m_123342_(), center.m_123343_() + z));
                    }
                }
                break;
            }
        }
        return positions;
    }

    private BlockPos findNextPosition() {
        if (this.lastPosition == null) {
            this.lastPosition = this.positions.get(0);
            return this.lastPosition;
        }
        int index = this.positions.indexOf(this.lastPosition);
        if (index == -1 || index >= this.positions.size() - 1) {
            this.lastPosition = this.positions.get(0);
            return this.lastPosition;
        }
        this.lastPosition = this.positions.get(index + 1);
        return this.lastPosition;
    }

    private void addItemToInventory(ItemStack stack, Level level, BlockPos pos) {
        int remaining = stack.m_41613_();
        for (int i = 1; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) {
                this.inventory.setStackInSlot(i, stack.m_41777_());
                return;
            }
            if (StackHelper.areStacksEqual((ItemStack)stackInSlot, (ItemStack)stack)) {
                int insertSize = Math.min(remaining, stackInSlot.m_41741_() - stackInSlot.m_41613_());
                this.inventory.setStackInSlot(i, StackHelper.grow((ItemStack)stackInSlot, (int)insertSize));
                remaining -= insertSize;
            }
            if (remaining != 0) continue;
            return;
        }
        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)StackHelper.withSize((ItemStack)stack, (int)remaining, (boolean)false));
    }

    private static Item getSeed(Block block) {
        try {
            return (Item)GET_SEED.invoke((Object)block, new Object[0]);
        }
        catch (Exception e) {
            MysticalAgriculture.LOGGER.error("Unable to get seed from crop {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }
}

