/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.registry;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.registry.IAugmentRegistry;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.item.AugmentItem;
import com.blakebr0.mysticalagriculture.registry.PluginRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.IForgeRegistry;

public final class AugmentRegistry
implements IAugmentRegistry {
    private static final AugmentRegistry INSTANCE = new AugmentRegistry();
    private final Map<ResourceLocation, Augment> augments = new LinkedHashMap<ResourceLocation, Augment>();

    @Override
    public void register(Augment augment) {
        if (this.augments.values().stream().noneMatch(c -> c.getId().equals((Object)augment.getId()))) {
            this.augments.put(augment.getId(), augment);
        } else {
            MysticalAgriculture.LOGGER.info("{} tried to register a duplicate augment with id {}, skipping", (Object)augment.getModId(), (Object)augment.getId());
        }
    }

    @Override
    public List<Augment> getAugments() {
        return List.copyOf(this.augments.values());
    }

    @Override
    public Augment getAugmentById(ResourceLocation id) {
        return this.augments.get(id);
    }

    public static AugmentRegistry getInstance() {
        return INSTANCE;
    }

    public void onRegisterItems(IForgeRegistry<Item> registry) {
        PluginRegistry.getInstance().forEach((plugin, config) -> plugin.onRegisterAugments(this));
        this.augments.forEach((id, a) -> {
            AugmentItem item = new AugmentItem((Augment)a);
            registry.register(new ResourceLocation("mysticalagriculture", a.getNameWithSuffix("augment")), (Object)item);
        });
        PluginRegistry.getInstance().forEach((plugin, config) -> plugin.onPostRegisterAugments(this));
    }
}

