/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.crafting.recipe.SoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.SoulExtractorCrafting")
@ZenRegister
public final class SoulExtractorCrafting {
    @ZenCodeType.Method
    public static void addRecipe(final String id, final IIngredient input, final String type, final double souls) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                MobSoulType mobSoulType = MobSoulTypeRegistry.getInstance().getMobSoulTypeById(new ResourceLocation(type));
                SoulExtractionRecipe recipe = new SoulExtractionRecipe(new ResourceLocation("crafttweaker", id), input.asVanillaIngredient(), mobSoulType, souls);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Soul Extractor Crafting recipe for " + input.getCommandString() + " to " + type;
            }

            public String systemName() {
                return "mysticalagriculture";
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.SOUL_EXTRACTION.get(), new HashMap())).values().stream().filter(r -> ((Ingredient)r.m_7527_().get(0)).test(stack.getInternal())).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.SOUL_EXTRACTION.get())).remove(r));
            }

            public String describe() {
                return "Removing Soul Extractor Crafting recipes for item " + stack.getCommandString();
            }

            public String systemName() {
                return "mysticalagriculture";
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final String type) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.SOUL_EXTRACTION.get(), new HashMap())).values().stream().filter(r -> type.equals(((ISoulExtractionRecipe)r).getMobSoulType().getId().toString())).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.SOUL_EXTRACTION.get())).remove(r));
            }

            public String describe() {
                return "Removing Soul Extractor Crafting recipes for mob soul type " + type;
            }

            public String systemName() {
                return "mysticalagriculture";
            }
        });
    }
}

