/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.EnchanterRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.EnchanterCrafting")
@ZenRegister
public final class EnchanterCrafting {
    @ZenCodeType.Method
    public static void addRecipe(final String id, final String enchantmentID, final IItemStack[] inputs) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentID));
                EnchanterRecipe recipe = new EnchanterRecipe(new ResourceLocation("crafttweaker", id), EnchanterCrafting.toIngredientsList((IIngredient[])inputs), Arrays.stream(inputs).map(IItemStack::getAmount).toList(), enchantment);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Enchanter Crafting recipe for enchantment " + enchantmentID;
            }

            public String systemName() {
                return "mysticalagriculture";
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final String enchantmentID) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.ENCHANTER.get(), new HashMap())).values().stream().filter(r -> {
                    Enchantment enchantment = ((IEnchanterRecipe)r).getEnchantment();
                    return enchantment != null && Objects.equals(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment), new ResourceLocation(enchantmentID));
                }).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.ENCHANTER.get())).remove(r));
            }

            public String describe() {
                return "Removing Infusion Crafting recipes for enchantment " + enchantmentID;
            }

            public String systemName() {
                return "mysticalagriculture";
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... iingredients) {
        NonNullList ingredients = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
        for (int i = 0; i < iingredients.length; ++i) {
            ingredients.set(i, (Object)iingredients[i].asVanillaIngredient());
        }
        return ingredients;
    }
}

