/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.crafting.recipe.AwakeningRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.AwakeningCrafting")
@ZenRegister
public final class AwakeningCrafting {
    @ZenCodeType.Method
    public static void addRecipe(String id, IItemStack output, IIngredient[] inputs, IItemStack[] essences) {
        AwakeningCrafting.addRecipe(id, output, inputs, essences, false);
    }

    @ZenCodeType.Method
    public static void addRecipe(final String id, final IItemStack output, final IIngredient[] inputs, final IItemStack[] essences, final boolean transferNBT) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                AwakeningRecipe recipe = new AwakeningRecipe(new ResourceLocation("crafttweaker", id), AwakeningCrafting.toIngredientsList(inputs), AwakeningCrafting.toItemStackList(essences), output.getInternal(), transferNBT);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Awakening Crafting recipe for " + output.getCommandString();
            }

            public String systemName() {
                return "mysticalagriculture";
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                RegistryAccess.Frozen access = ServerLifecycleHooks.getCurrentServer().m_206579_();
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.AWAKENING.get(), new HashMap())).values().stream().filter(r -> r.m_8043_((RegistryAccess)access).m_150930_(stack.getInternal().m_41720_())).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.AWAKENING.get())).remove(r));
            }

            public String describe() {
                return "Removing Awakening Crafting recipes for " + stack.getCommandString();
            }

            public String systemName() {
                return "mysticalagriculture";
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... iingredients) {
        NonNullList ingredients = NonNullList.m_122780_((int)5, (Object)Ingredient.f_43901_);
        for (int i = 0; i < iingredients.length; ++i) {
            ingredients.set(i, (Object)iingredients[i].asVanillaIngredient());
        }
        return ingredients;
    }

    private static NonNullList<ItemStack> toItemStackList(IItemStack ... iitemStacks) {
        NonNullList itemStacks = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        for (int i = 0; i < iitemStacks.length; ++i) {
            itemStacks.set(i, (Object)iitemStacks[i].getInternal());
        }
        return itemStacks;
    }
}

