/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.handler;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.mysticalagriculture.crafting.recipe.AwakeningRecipe;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.AwakeningAltarTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.InfusionAltarTileEntity;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class GuiOverlayHandler {
    private static final IGuiOverlay ALTAR_OVERLAY = (gui, gfx, partialTicks, width, height) -> {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        HitResult patt1147$temp = mc.f_91077_;
        if (patt1147$temp instanceof BlockHitResult) {
            BaseInventoryTileEntity altar;
            ISpecialRecipe recipe;
            BlockHitResult result = (BlockHitResult)patt1147$temp;
            BlockPos pos = result.m_82425_();
            BlockEntity tile = level.m_7702_(pos);
            ItemStack stack = ItemStack.f_41583_;
            if (tile instanceof InfusionAltarTileEntity && (recipe = (altar = (InfusionAltarTileEntity)tile).getActiveRecipe()) != null) {
                stack = recipe.m_8043_(level.m_9598_());
            }
            if (tile instanceof AwakeningAltarTileEntity && (recipe = (altar = (AwakeningAltarTileEntity)tile).getActiveRecipe()) != null) {
                stack = recipe.m_8043_(level.m_9598_());
                GuiOverlayHandler.drawEssenceRequirements(gfx, (AwakeningRecipe)recipe, (AwakeningAltarTileEntity)altar);
            }
            if (!stack.m_41619_()) {
                int x = mc.m_91268_().m_85445_() / 2 - 11;
                int y = mc.m_91268_().m_85446_() / 2 - 8;
                gfx.m_280480_(stack, x + 26, y);
                gfx.m_280370_(mc.f_91062_, stack, x + 26, y);
                gfx.m_280430_(mc.f_91062_, stack.m_41786_(), x + 48, y + 5, 0xF9FFFE);
            }
        }
    };
    private static final IGuiOverlay ESSENCE_VESSEL_OVERLAY = (gui, gfx, partialTicks, width, height) -> {
        EssenceVesselTileEntity vessel;
        ItemStack stack;
        BlockHitResult result;
        BlockPos pos;
        BlockEntity tile;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        HitResult patt2593$temp = mc.f_91077_;
        if (patt2593$temp instanceof BlockHitResult && (tile = mc.f_91073_.m_7702_(pos = (result = (BlockHitResult)patt2593$temp).m_82425_())) instanceof EssenceVesselTileEntity && !(stack = (vessel = (EssenceVesselTileEntity)tile).getInventory().getStackInSlot(0)).m_41619_()) {
            int x = mc.m_91268_().m_85445_() / 2 - 11;
            int y = mc.m_91268_().m_85446_() / 2 - 8;
            gfx.m_280480_(stack, x + 26, y);
            gfx.m_280370_(mc.f_91062_, stack, x + 26, y);
            gfx.m_280430_(mc.f_91062_, stack.m_41786_(), x + 48, y + 5, 0xF9FFFE);
        }
    };

    @SubscribeEvent
    public void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "altar_overlay", ALTAR_OVERLAY);
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "essence_vessel_overlay", ESSENCE_VESSEL_OVERLAY);
    }

    private static void drawEssenceRequirements(GuiGraphics gfx, AwakeningRecipe recipe, AwakeningAltarTileEntity altar) {
        Minecraft mc = Minecraft.m_91087_();
        int x = mc.m_91268_().m_85445_() / 2 - 11;
        int y = mc.m_91268_().m_85446_() / 2 - 4;
        Objects.requireNonNull(mc.f_91062_);
        int lineHeight = 9 + 6;
        boolean hasMissingEssences = false;
        int xOffset = 0;
        Map<ItemStack, Integer> missingEssences = recipe.getMissingEssences((List<ItemStack>)altar.getEssenceItems());
        for (Map.Entry<ItemStack, Integer> essence : missingEssences.entrySet()) {
            gfx.m_280480_(essence.getKey(), x + 26 + xOffset, y + 2 * lineHeight);
            gfx.m_280488_(mc.f_91062_, GuiOverlayHandler.getEssenceDisplayName(essence.getKey(), essence.getValue()), x + 48 + xOffset, y + 5 + 2 * lineHeight, 0xF9FFFE);
            xOffset += 56;
            hasMissingEssences = true;
        }
        if (hasMissingEssences) {
            gfx.m_280430_(mc.f_91062_, (Component)ModTooltips.MISSING_ESSENCES.build(), x + 28, y + 5 + lineHeight, 0xF9FFFE);
        }
    }

    private static String getEssenceDisplayName(ItemStack stack, int missing) {
        int required = stack.m_41613_();
        return required - missing + "/" + required;
    }
}

